/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.twovaluelogic;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.twovaluelogic.NNModeFunction;

public class ModeFunctionTest {
    private NNModeFunction modeFunction;

    @Before
    public void setUp() {
        this.modeFunction = NNModeFunction.INSTANCE;
    }

    @Test
    public void invokeListNull() {
        FunctionTestUtil.assertResult(this.modeFunction.invoke((List)null), null);
    }

    @Test
    public void invokeListEmpty() {
        FunctionTestUtil.assertResult(this.modeFunction.invoke(Collections.emptyList()), null);
    }

    @Test
    public void invokeListTypeHeterogenous() {
        FunctionTestUtil.assertResultError(this.modeFunction.invoke(Arrays.asList(1, "test")), InvalidParametersEvent.class);
    }

    @Test
    public void invokeListParamSupportedTypesWithNull() {
        FunctionTestUtil.assertResult(this.modeFunction.invoke(Arrays.asList(20, 30, null, 20L, null, BigDecimal.TEN)), Arrays.asList(BigDecimal.valueOf(20L)));
        FunctionTestUtil.assertResult(this.modeFunction.invoke(Arrays.asList(20, 30, null, 20L, 30, BigDecimal.TEN)), Arrays.asList(BigDecimal.valueOf(20L), BigDecimal.valueOf(30L)));
        FunctionTestUtil.assertResult(this.modeFunction.invoke(Arrays.asList(null, null, null)), null);
    }

    @Test
    public void invokeArrayNull() {
        FunctionTestUtil.assertResult(this.modeFunction.invoke((Object[])null), null);
    }

    @Test
    public void invokeArrayEmpty() {
        FunctionTestUtil.assertResult(this.modeFunction.invoke(new Object[0]), null);
    }

    @Test
    public void invokeArrayTypeHeterogenous() {
        FunctionTestUtil.assertResultError(this.modeFunction.invoke(new Object[]{1, "test"}), InvalidParametersEvent.class);
    }

    @Test
    public void invokeArrayParamSupportedTypesWithNull() {
        FunctionTestUtil.assertResult(this.modeFunction.invoke(Arrays.asList(20, 30, null, 20L, null, BigDecimal.TEN)), Arrays.asList(BigDecimal.valueOf(20L)));
        FunctionTestUtil.assertResult(this.modeFunction.invoke(Arrays.asList(20, 30, null, 20L, 30, BigDecimal.TEN)), Arrays.asList(BigDecimal.valueOf(20L), BigDecimal.valueOf(30L)));
        FunctionTestUtil.assertResult(this.modeFunction.invoke(Arrays.asList(null, null, null)), null);
    }
}

