/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.parser.feel11;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.ASTNode;
import org.kie.dmn.feel.lang.ast.AtLiteralNode;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.BetweenNode;
import org.kie.dmn.feel.lang.ast.BooleanNode;
import org.kie.dmn.feel.lang.ast.ContextEntryNode;
import org.kie.dmn.feel.lang.ast.ContextNode;
import org.kie.dmn.feel.lang.ast.FilterExpressionNode;
import org.kie.dmn.feel.lang.ast.ForExpressionNode;
import org.kie.dmn.feel.lang.ast.FormalParameterNode;
import org.kie.dmn.feel.lang.ast.FunctionDefNode;
import org.kie.dmn.feel.lang.ast.FunctionInvocationNode;
import org.kie.dmn.feel.lang.ast.IfExpressionNode;
import org.kie.dmn.feel.lang.ast.InNode;
import org.kie.dmn.feel.lang.ast.InfixOpNode;
import org.kie.dmn.feel.lang.ast.InstanceOfNode;
import org.kie.dmn.feel.lang.ast.IterationContextNode;
import org.kie.dmn.feel.lang.ast.ListNode;
import org.kie.dmn.feel.lang.ast.NameDefNode;
import org.kie.dmn.feel.lang.ast.NameRefNode;
import org.kie.dmn.feel.lang.ast.NamedParameterNode;
import org.kie.dmn.feel.lang.ast.NullNode;
import org.kie.dmn.feel.lang.ast.NumberNode;
import org.kie.dmn.feel.lang.ast.PathExpressionNode;
import org.kie.dmn.feel.lang.ast.QualifiedNameNode;
import org.kie.dmn.feel.lang.ast.QuantifiedExpressionNode;
import org.kie.dmn.feel.lang.ast.RangeNode;
import org.kie.dmn.feel.lang.ast.SignedUnaryNode;
import org.kie.dmn.feel.lang.ast.StringNode;
import org.kie.dmn.feel.lang.ast.TypeNode;
import org.kie.dmn.feel.lang.impl.MapBackedType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.parser.feel11.ASTBuilderVisitor;
import org.kie.dmn.feel.parser.feel11.FEELParser;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Parser;
import org.kie.dmn.feel.util.DynamicTypeUtils;
import org.kie.dmn.feel.util.Msg;

public class FEELParserTest {
    @Test
    public void testIntegerLiteral() {
        String inputExpression = "10";
        BaseNode number = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)number, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)number.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        FEELParserTest.assertLocation(inputExpression, (ASTNode)number);
    }

    @Test
    public void testNegativeIntegerLiteral() {
        String inputExpression = "-10";
        BaseNode number = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)number, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SignedUnaryNode.class)));
        MatcherAssert.assertThat((Object)number.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        FEELParserTest.assertLocation(inputExpression, (ASTNode)number);
        SignedUnaryNode sun = (SignedUnaryNode)number;
        MatcherAssert.assertThat((Object)sun.getSign(), (Matcher)CoreMatchers.is((Object)SignedUnaryNode.Sign.NEGATIVE));
        MatcherAssert.assertThat((Object)sun.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)sun.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"10"));
    }

    @Test
    public void testPositiveIntegerLiteral() {
        String inputExpression = "+10";
        BaseNode number = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)number, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SignedUnaryNode.class)));
        MatcherAssert.assertThat((Object)number.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        FEELParserTest.assertLocation(inputExpression, (ASTNode)number);
        SignedUnaryNode sun = (SignedUnaryNode)number;
        MatcherAssert.assertThat((Object)sun.getSign(), (Matcher)CoreMatchers.is((Object)SignedUnaryNode.Sign.POSITIVE));
        MatcherAssert.assertThat((Object)sun.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)sun.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"10"));
    }

    @Test
    public void testFloatLiteral() {
        String inputExpression = "10.5";
        BaseNode number = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)number, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)number.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        FEELParserTest.assertLocation(inputExpression, (ASTNode)number);
    }

    @Test
    public void testNegativeFloatLiteral() {
        String inputExpression = "-10.5";
        BaseNode number = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)number, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SignedUnaryNode.class)));
        MatcherAssert.assertThat((Object)number.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        FEELParserTest.assertLocation(inputExpression, (ASTNode)number);
        SignedUnaryNode sun = (SignedUnaryNode)number;
        MatcherAssert.assertThat((Object)sun.getSign(), (Matcher)CoreMatchers.is((Object)SignedUnaryNode.Sign.NEGATIVE));
        MatcherAssert.assertThat((Object)sun.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)sun.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"10.5"));
    }

    @Test
    public void testPositiveFloatLiteral() {
        String inputExpression = "+10.5";
        BaseNode number = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)number, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SignedUnaryNode.class)));
        MatcherAssert.assertThat((Object)number.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        FEELParserTest.assertLocation(inputExpression, (ASTNode)number);
        SignedUnaryNode sun = (SignedUnaryNode)number;
        MatcherAssert.assertThat((Object)sun.getSign(), (Matcher)CoreMatchers.is((Object)SignedUnaryNode.Sign.POSITIVE));
        MatcherAssert.assertThat((Object)sun.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)sun.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"10.5"));
    }

    @Test
    public void testBooleanTrueLiteral() {
        String inputExpression = "true";
        BaseNode bool = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)bool, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(BooleanNode.class)));
        MatcherAssert.assertThat((Object)bool.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        FEELParserTest.assertLocation(inputExpression, (ASTNode)bool);
    }

    @Test
    public void testBooleanFalseLiteral() {
        String inputExpression = "false";
        BaseNode bool = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)bool, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(BooleanNode.class)));
        MatcherAssert.assertThat((Object)bool.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        FEELParserTest.assertLocation(inputExpression, (ASTNode)bool);
    }

    @Test
    public void testAtLiteralDate() {
        String inputExpression = "@\"2016-07-29\"";
        BaseNode bool = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)bool, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(AtLiteralNode.class)));
        MatcherAssert.assertThat((Object)bool.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.DATE));
        FEELParserTest.assertLocation(inputExpression, (ASTNode)bool);
    }

    @Test
    public void testAtLiteralTime() {
        String inputExpression = "@\"23:59:00\"";
        BaseNode bool = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)bool, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(AtLiteralNode.class)));
        MatcherAssert.assertThat((Object)bool.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.TIME));
        FEELParserTest.assertLocation(inputExpression, (ASTNode)bool);
    }

    @Test
    public void testAtLiteralDateAndTime() {
        String inputExpression = "@\"2016-07-29T05:48:23\"";
        BaseNode bool = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)bool, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(AtLiteralNode.class)));
        MatcherAssert.assertThat((Object)bool.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.DATE_TIME));
        FEELParserTest.assertLocation(inputExpression, (ASTNode)bool);
    }

    @Test
    public void testAtLiteralDuration() {
        String inputExpression = "@\"P2Y2M\"";
        BaseNode bool = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)bool, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(AtLiteralNode.class)));
        MatcherAssert.assertThat((Object)bool.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.DURATION));
        FEELParserTest.assertLocation(inputExpression, (ASTNode)bool);
    }

    @Test
    public void testNullLiteral() {
        String inputExpression = "null";
        BaseNode nullLit = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)nullLit, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NullNode.class)));
        MatcherAssert.assertThat((Object)nullLit.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.UNKNOWN));
        FEELParserTest.assertLocation(inputExpression, (ASTNode)nullLit);
    }

    @Test
    public void testStringLiteral() {
        String inputExpression = "\"some string\"";
        BaseNode stringLit = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)stringLit, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringNode.class)));
        MatcherAssert.assertThat((Object)stringLit.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.STRING));
        FEELParserTest.assertLocation(inputExpression, (ASTNode)stringLit);
        MatcherAssert.assertThat((Object)stringLit.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
    }

    @Test
    public void testNameReference() {
        String inputExpression = "someSimpleName";
        BaseNode nameRef = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("someSimpleName", BuiltInType.STRING)));
        MatcherAssert.assertThat((Object)nameRef, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)nameRef.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.STRING));
        FEELParserTest.assertLocation(inputExpression, (ASTNode)nameRef);
    }

    @Test
    public void testQualifiedName() {
        String inputExpression = "My Person.Full Name";
        MapBackedType personType = new MapBackedType("Person", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("Full Name", BuiltInType.STRING), DynamicTypeUtils.entry("Age", BuiltInType.NUMBER)));
        BaseNode qualRef = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("My Person", personType)));
        MatcherAssert.assertThat((Object)qualRef, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(QualifiedNameNode.class)));
        MatcherAssert.assertThat((Object)qualRef.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.STRING));
        List parts = ((QualifiedNameNode)qualRef).getParts();
        MatcherAssert.assertThat((Object)((NameRefNode)parts.get(0)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)((NameRefNode)parts.get(0)).getResultType(), (Matcher)CoreMatchers.is((Object)personType));
        MatcherAssert.assertThat((Object)((NameRefNode)parts.get(1)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)((NameRefNode)parts.get(1)).getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.STRING));
        FEELParserTest.assertLocation(inputExpression, (ASTNode)qualRef);
    }

    @Test
    public void testParensWithLiteral() {
        String inputExpression = "(10.5 )";
        BaseNode number = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)number, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)number.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        MatcherAssert.assertThat((Object)number.getText(), (Matcher)CoreMatchers.is((Object)"10.5"));
    }

    @Test
    public void testLogicalNegation() {
        String inputExpression = "not ( true )";
        BaseNode neg = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)neg, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FunctionInvocationNode.class)));
        MatcherAssert.assertThat((Object)neg.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.UNKNOWN));
        MatcherAssert.assertThat((Object)neg.getText(), (Matcher)CoreMatchers.is((Object)"not ( true )"));
        FunctionInvocationNode not = (FunctionInvocationNode)neg;
        MatcherAssert.assertThat((Object)((BaseNode)not.getParams().getElements().get(0)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(BooleanNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)not.getParams().getElements().get(0)).getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        MatcherAssert.assertThat((Object)((BaseNode)not.getParams().getElements().get(0)).getText(), (Matcher)CoreMatchers.is((Object)"true"));
    }

    @Test
    public void testMultiplication() {
        String inputExpression = "10 * x";
        BaseNode infix = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("x", BuiltInType.NUMBER)));
        MatcherAssert.assertThat((Object)infix, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)infix.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        MatcherAssert.assertThat((Object)infix.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        InfixOpNode mult = (InfixOpNode)infix;
        MatcherAssert.assertThat((Object)mult.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)mult.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"10"));
        MatcherAssert.assertThat((Object)mult.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.MULT));
        MatcherAssert.assertThat((Object)mult.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)mult.getRight().getText(), (Matcher)CoreMatchers.is((Object)"x"));
    }

    @Test
    public void testDivision() {
        String inputExpression = "y / 5 * ( x )";
        BaseNode infix = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("x", BuiltInType.NUMBER), DynamicTypeUtils.entry("y", BuiltInType.NUMBER)));
        MatcherAssert.assertThat((Object)infix, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)infix.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        MatcherAssert.assertThat((Object)infix.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        InfixOpNode mult = (InfixOpNode)infix;
        MatcherAssert.assertThat((Object)mult.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)mult.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"y / 5"));
        InfixOpNode div = (InfixOpNode)mult.getLeft();
        MatcherAssert.assertThat((Object)div.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)div.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"y"));
        MatcherAssert.assertThat((Object)div.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.DIV));
        MatcherAssert.assertThat((Object)div.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)div.getRight().getText(), (Matcher)CoreMatchers.is((Object)"5"));
        MatcherAssert.assertThat((Object)mult.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.MULT));
        MatcherAssert.assertThat((Object)mult.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)mult.getRight().getText(), (Matcher)CoreMatchers.is((Object)"x"));
    }

    @Test
    public void testPower1() {
        String inputExpression = "y * 5 ** 3";
        BaseNode infix = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("y", BuiltInType.NUMBER)));
        MatcherAssert.assertThat((Object)infix, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)infix.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        MatcherAssert.assertThat((Object)infix.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        InfixOpNode mult = (InfixOpNode)infix;
        MatcherAssert.assertThat((Object)mult.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)mult.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"y"));
        MatcherAssert.assertThat((Object)mult.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.MULT));
        MatcherAssert.assertThat((Object)mult.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)mult.getRight().getText(), (Matcher)CoreMatchers.is((Object)"5 ** 3"));
        InfixOpNode exp = (InfixOpNode)mult.getRight();
        MatcherAssert.assertThat((Object)exp.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)exp.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"5"));
        MatcherAssert.assertThat((Object)exp.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.POW));
        MatcherAssert.assertThat((Object)exp.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)exp.getRight().getText(), (Matcher)CoreMatchers.is((Object)"3"));
    }

    @Test
    public void testPower2() {
        String inputExpression = "(y * 5) ** 3";
        BaseNode infix = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("y", BuiltInType.NUMBER)));
        MatcherAssert.assertThat((Object)infix, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)infix.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        MatcherAssert.assertThat((Object)infix.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        InfixOpNode exp = (InfixOpNode)infix;
        MatcherAssert.assertThat((Object)exp.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)exp.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"y * 5"));
        MatcherAssert.assertThat((Object)exp.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.POW));
        MatcherAssert.assertThat((Object)exp.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)exp.getRight().getText(), (Matcher)CoreMatchers.is((Object)"3"));
        InfixOpNode mult = (InfixOpNode)exp.getLeft();
        MatcherAssert.assertThat((Object)mult.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)mult.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"y"));
        MatcherAssert.assertThat((Object)mult.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.MULT));
        MatcherAssert.assertThat((Object)mult.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)mult.getRight().getText(), (Matcher)CoreMatchers.is((Object)"5"));
    }

    @Test
    public void testPower3() {
        String inputExpression = "y ** 5 * 3";
        BaseNode infix = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("y", BuiltInType.NUMBER)));
        MatcherAssert.assertThat((Object)infix, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)infix.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        MatcherAssert.assertThat((Object)infix.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        InfixOpNode mult = (InfixOpNode)infix;
        MatcherAssert.assertThat((Object)mult.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)mult.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"y ** 5"));
        MatcherAssert.assertThat((Object)mult.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.MULT));
        MatcherAssert.assertThat((Object)mult.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)mult.getRight().getText(), (Matcher)CoreMatchers.is((Object)"3"));
        InfixOpNode exp = (InfixOpNode)mult.getLeft();
        MatcherAssert.assertThat((Object)exp.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)exp.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"y"));
        MatcherAssert.assertThat((Object)exp.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.POW));
        MatcherAssert.assertThat((Object)exp.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)exp.getRight().getText(), (Matcher)CoreMatchers.is((Object)"5"));
    }

    @Test
    public void testPower4() {
        String inputExpression = "y ** ( 5 * 3 )";
        BaseNode infix = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("y", BuiltInType.NUMBER)));
        MatcherAssert.assertThat((Object)infix, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)infix.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        MatcherAssert.assertThat((Object)infix.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        InfixOpNode exp = (InfixOpNode)infix;
        MatcherAssert.assertThat((Object)exp.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)exp.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"y"));
        MatcherAssert.assertThat((Object)exp.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.POW));
        MatcherAssert.assertThat((Object)exp.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)exp.getRight().getText(), (Matcher)CoreMatchers.is((Object)"5 * 3"));
        InfixOpNode mult = (InfixOpNode)exp.getRight();
        MatcherAssert.assertThat((Object)mult.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)mult.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"5"));
        MatcherAssert.assertThat((Object)mult.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.MULT));
        MatcherAssert.assertThat((Object)mult.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)mult.getRight().getText(), (Matcher)CoreMatchers.is((Object)"3"));
    }

    @Test
    public void testAdd1() {
        String inputExpression = "y + 5 * 3";
        BaseNode infix = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("y", BuiltInType.NUMBER)));
        MatcherAssert.assertThat((Object)infix, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)infix.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        MatcherAssert.assertThat((Object)infix.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        InfixOpNode add = (InfixOpNode)infix;
        MatcherAssert.assertThat((Object)add.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)add.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"y"));
        MatcherAssert.assertThat((Object)add.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.ADD));
        MatcherAssert.assertThat((Object)add.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)add.getRight().getText(), (Matcher)CoreMatchers.is((Object)"5 * 3"));
        InfixOpNode mult = (InfixOpNode)add.getRight();
        MatcherAssert.assertThat((Object)mult.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)mult.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"5"));
        MatcherAssert.assertThat((Object)mult.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.MULT));
        MatcherAssert.assertThat((Object)mult.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)mult.getRight().getText(), (Matcher)CoreMatchers.is((Object)"3"));
    }

    @Test
    public void testSub1() {
        String inputExpression = "(y - 5) ** 3";
        BaseNode infix = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("y", BuiltInType.NUMBER)));
        MatcherAssert.assertThat((Object)infix, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)infix.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        MatcherAssert.assertThat((Object)infix.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        InfixOpNode sub = (InfixOpNode)infix;
        MatcherAssert.assertThat((Object)sub.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)sub.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"y - 5"));
        MatcherAssert.assertThat((Object)sub.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.POW));
        MatcherAssert.assertThat((Object)sub.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)sub.getRight().getText(), (Matcher)CoreMatchers.is((Object)"3"));
        InfixOpNode mult = (InfixOpNode)sub.getLeft();
        MatcherAssert.assertThat((Object)mult.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)mult.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"y"));
        MatcherAssert.assertThat((Object)mult.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.SUB));
        MatcherAssert.assertThat((Object)mult.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)mult.getRight().getText(), (Matcher)CoreMatchers.is((Object)"5"));
    }

    @Test
    public void testBetween() {
        String inputExpression = "x between 10+y and 3**z";
        BaseNode between = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)between, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(BetweenNode.class)));
        MatcherAssert.assertThat((Object)between.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        MatcherAssert.assertThat((Object)between.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        BetweenNode btw = (BetweenNode)between;
        MatcherAssert.assertThat((Object)btw.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)btw.getValue().getText(), (Matcher)CoreMatchers.is((Object)"x"));
        MatcherAssert.assertThat((Object)btw.getStart(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)btw.getStart().getText(), (Matcher)CoreMatchers.is((Object)"10+y"));
        MatcherAssert.assertThat((Object)btw.getEnd(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)btw.getEnd().getText(), (Matcher)CoreMatchers.is((Object)"3**z"));
    }

    @Test
    public void testInValueList() {
        String inputExpression = "x / 4 in ( 10+y, true, 80, someVar )";
        BaseNode inNode = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)inNode, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InNode.class)));
        MatcherAssert.assertThat((Object)inNode.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        MatcherAssert.assertThat((Object)inNode.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        InNode in = (InNode)inNode;
        MatcherAssert.assertThat((Object)in.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)in.getValue().getText(), (Matcher)CoreMatchers.is((Object)"x / 4"));
        MatcherAssert.assertThat((Object)in.getExprs(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ListNode.class)));
        MatcherAssert.assertThat((Object)in.getExprs().getText(), (Matcher)CoreMatchers.is((Object)"10+y, true, 80, someVar"));
        ListNode list = (ListNode)in.getExprs();
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(0)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(1)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(BooleanNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(2)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(3)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
    }

    @Test
    public void testInUnaryTestList() {
        String inputExpression = "x ** y in ( <=1000, >t, null, (2000..z[, ]z..2000], [(10+5)..(a*b)) )";
        BaseNode inNode = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)inNode, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InNode.class)));
        MatcherAssert.assertThat((Object)inNode.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        MatcherAssert.assertThat((Object)inNode.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        InNode in = (InNode)inNode;
        MatcherAssert.assertThat((Object)in.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)in.getValue().getText(), (Matcher)CoreMatchers.is((Object)"x ** y"));
        MatcherAssert.assertThat((Object)in.getExprs(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ListNode.class)));
        MatcherAssert.assertThat((Object)in.getExprs().getText(), (Matcher)CoreMatchers.is((Object)"<=1000, >t, null, (2000..z[, ]z..2000], [(10+5)..(a*b))"));
        ListNode list = (ListNode)in.getExprs();
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(0)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RangeNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(0)).getText(), (Matcher)CoreMatchers.is((Object)"<=1000"));
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(1)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RangeNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(1)).getText(), (Matcher)CoreMatchers.is((Object)">t"));
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(2)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NullNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(2)).getText(), (Matcher)CoreMatchers.is((Object)"null"));
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(3)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RangeNode.class)));
        RangeNode interval = (RangeNode)list.getElements().get(3);
        MatcherAssert.assertThat((Object)interval.getText(), (Matcher)CoreMatchers.is((Object)"(2000..z["));
        MatcherAssert.assertThat((Object)interval.getLowerBound(), (Matcher)CoreMatchers.is((Object)RangeNode.IntervalBoundary.OPEN));
        MatcherAssert.assertThat((Object)interval.getUpperBound(), (Matcher)CoreMatchers.is((Object)RangeNode.IntervalBoundary.OPEN));
        MatcherAssert.assertThat((Object)interval.getStart(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)interval.getEnd(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(4)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RangeNode.class)));
        interval = (RangeNode)list.getElements().get(4);
        MatcherAssert.assertThat((Object)interval.getText(), (Matcher)CoreMatchers.is((Object)"]z..2000]"));
        MatcherAssert.assertThat((Object)interval.getLowerBound(), (Matcher)CoreMatchers.is((Object)RangeNode.IntervalBoundary.OPEN));
        MatcherAssert.assertThat((Object)interval.getUpperBound(), (Matcher)CoreMatchers.is((Object)RangeNode.IntervalBoundary.CLOSED));
        MatcherAssert.assertThat((Object)interval.getStart(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)interval.getEnd(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(5)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RangeNode.class)));
        interval = (RangeNode)list.getElements().get(5);
        MatcherAssert.assertThat((Object)interval.getText(), (Matcher)CoreMatchers.is((Object)"[(10+5)..(a*b))"));
        MatcherAssert.assertThat((Object)interval.getLowerBound(), (Matcher)CoreMatchers.is((Object)RangeNode.IntervalBoundary.CLOSED));
        MatcherAssert.assertThat((Object)interval.getUpperBound(), (Matcher)CoreMatchers.is((Object)RangeNode.IntervalBoundary.OPEN));
        MatcherAssert.assertThat((Object)interval.getStart(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)interval.getEnd(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
    }

    @Test
    public void testInUnaryTest() {
        String inputExpression = "x - y in [(10+5)..(a*b))";
        BaseNode inNode = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)inNode, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InNode.class)));
        MatcherAssert.assertThat((Object)inNode.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        MatcherAssert.assertThat((Object)inNode.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        InNode in = (InNode)inNode;
        MatcherAssert.assertThat((Object)in.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)in.getValue().getText(), (Matcher)CoreMatchers.is((Object)"x - y"));
        MatcherAssert.assertThat((Object)in.getExprs(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RangeNode.class)));
        MatcherAssert.assertThat((Object)in.getExprs().getText(), (Matcher)CoreMatchers.is((Object)"[(10+5)..(a*b))"));
    }

    @Test
    public void testInUnaryTestStrings() {
        String inputExpression = "name in [\"A\"..\"Z...\")";
        BaseNode inNode = this.parse("name in [\"A\"..\"Z...\")");
        MatcherAssert.assertThat((Object)inNode, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InNode.class)));
        MatcherAssert.assertThat((Object)inNode.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        MatcherAssert.assertThat((Object)inNode.getText(), (Matcher)CoreMatchers.is((Object)"name in [\"A\"..\"Z...\")"));
        InNode in = (InNode)inNode;
        MatcherAssert.assertThat((Object)in.getExprs(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RangeNode.class)));
        RangeNode range = (RangeNode)in.getExprs();
        MatcherAssert.assertThat((Object)range.getStart().getText(), (Matcher)CoreMatchers.is((Object)"\"A\""));
        MatcherAssert.assertThat((Object)range.getEnd().getText(), (Matcher)CoreMatchers.is((Object)"\"Z...\""));
    }

    @Test
    public void testComparisonInFixOp() {
        String inputExpression = "foo >= bar * 10";
        BaseNode infix = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)infix, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)infix.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        MatcherAssert.assertThat((Object)infix.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        InfixOpNode in = (InfixOpNode)infix;
        MatcherAssert.assertThat((Object)in.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)in.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)in.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)in.getRight().getText(), (Matcher)CoreMatchers.is((Object)"bar * 10"));
    }

    @Test
    public void testConditionalLogicalOp() {
        String inputExpression = "foo < 10 and bar = \"x\" or baz";
        BaseNode infix = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)infix, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)infix.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        MatcherAssert.assertThat((Object)infix.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        InfixOpNode or = (InfixOpNode)infix;
        MatcherAssert.assertThat((Object)or.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)or.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"foo < 10 and bar = \"x\""));
        MatcherAssert.assertThat((Object)or.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.OR));
        MatcherAssert.assertThat((Object)or.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)or.getRight().getText(), (Matcher)CoreMatchers.is((Object)"baz"));
        InfixOpNode and = (InfixOpNode)or.getLeft();
        MatcherAssert.assertThat((Object)and.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)and.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"foo < 10"));
        MatcherAssert.assertThat((Object)and.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.AND));
        MatcherAssert.assertThat((Object)and.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)and.getRight().getText(), (Matcher)CoreMatchers.is((Object)"bar = \"x\""));
    }

    @Test
    public void testEmptyList() {
        String inputExpression = "[]";
        BaseNode list = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)list, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ListNode.class)));
        MatcherAssert.assertThat((Object)list.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.LIST));
        MatcherAssert.assertThat((Object)list.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        ListNode ln = (ListNode)list;
        MatcherAssert.assertThat((Object)ln.getElements(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testExpressionList() {
        String inputExpression = "[ 10, foo * bar, true ]";
        BaseNode list = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)list, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ListNode.class)));
        MatcherAssert.assertThat((Object)list.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.LIST));
        MatcherAssert.assertThat((Object)list.getText(), (Matcher)CoreMatchers.is((Object)"10, foo * bar, true"));
        ListNode ln = (ListNode)list;
        MatcherAssert.assertThat((Object)ln.getElements().size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((BaseNode)ln.getElements().get(0)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)ln.getElements().get(1)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)ln.getElements().get(2)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(BooleanNode.class)));
    }

    @Test
    public void testEmptyContext() {
        String inputExpression = "{}";
        BaseNode context = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)context, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ContextNode.class)));
        MatcherAssert.assertThat((Object)context.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        ContextNode ctx = (ContextNode)context;
        MatcherAssert.assertThat((Object)ctx.getEntries(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testContextWithMultipleEntries() {
        String inputExpression = "{ \"a string key\" : 10, a non-string key : foo+bar, a key.with + /' odd chars : [10..50] }";
        BaseNode ctxbase = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("foo", BuiltInType.NUMBER), DynamicTypeUtils.entry("bar", BuiltInType.NUMBER)));
        MatcherAssert.assertThat((Object)ctxbase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ContextNode.class)));
        MatcherAssert.assertThat((Object)ctxbase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        ContextNode ctx = (ContextNode)ctxbase;
        MatcherAssert.assertThat((Object)ctx.getEntries().size(), (Matcher)CoreMatchers.is((Object)3));
        ContextEntryNode entry = (ContextEntryNode)ctx.getEntries().get(0);
        MatcherAssert.assertThat((Object)entry.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringNode.class)));
        StringNode nameNode = (StringNode)entry.getName();
        MatcherAssert.assertThat((Object)nameNode.getText(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)nameNode.getText(), (Matcher)CoreMatchers.is((Object)"\"a string key\""));
        MatcherAssert.assertThat((Object)entry.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)entry.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        MatcherAssert.assertThat((Object)entry.getValue().getText(), (Matcher)CoreMatchers.is((Object)"10"));
        entry = (ContextEntryNode)ctx.getEntries().get(1);
        MatcherAssert.assertThat((Object)entry.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameDefNode.class)));
        NameDefNode name = (NameDefNode)entry.getName();
        MatcherAssert.assertThat((Object)name.getParts(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)name.getParts().size(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)entry.getName().getText(), (Matcher)CoreMatchers.is((Object)"a non-string key"));
        MatcherAssert.assertThat((Object)entry.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)entry.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        MatcherAssert.assertThat((Object)entry.getValue().getText(), (Matcher)CoreMatchers.is((Object)"foo+bar"));
        entry = (ContextEntryNode)ctx.getEntries().get(2);
        MatcherAssert.assertThat((Object)entry.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameDefNode.class)));
        name = (NameDefNode)entry.getName();
        MatcherAssert.assertThat((Object)name.getParts(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)name.getParts().size(), (Matcher)CoreMatchers.is((Object)9));
        MatcherAssert.assertThat((Object)entry.getName().getText(), (Matcher)CoreMatchers.is((Object)"a key.with + /' odd chars"));
        MatcherAssert.assertThat((Object)entry.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RangeNode.class)));
        MatcherAssert.assertThat((Object)entry.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.RANGE));
        MatcherAssert.assertThat((Object)entry.getValue().getText(), (Matcher)CoreMatchers.is((Object)"[10..50]"));
    }

    @Test
    public void testVariableWithInKeyword() {
        String inputExpression = "{ a variable with in keyword : 10,  another variable : a variable with in keyword + 20,  another in variable : an external in variable / 2 }";
        BaseNode ctxbase = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("an external in variable", BuiltInType.NUMBER)));
        MatcherAssert.assertThat((Object)ctxbase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ContextNode.class)));
        MatcherAssert.assertThat((Object)ctxbase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        ContextNode ctx = (ContextNode)ctxbase;
        MatcherAssert.assertThat((Object)ctx.getEntries().size(), (Matcher)CoreMatchers.is((Object)3));
        ContextEntryNode entry = (ContextEntryNode)ctx.getEntries().get(0);
        MatcherAssert.assertThat((Object)entry.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameDefNode.class)));
        NameDefNode name = (NameDefNode)entry.getName();
        MatcherAssert.assertThat((Object)name.getParts(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)name.getParts().size(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)entry.getName().getText(), (Matcher)CoreMatchers.is((Object)"a variable with in keyword"));
        MatcherAssert.assertThat((Object)entry.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)entry.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        MatcherAssert.assertThat((Object)entry.getValue().getText(), (Matcher)CoreMatchers.is((Object)"10"));
        entry = (ContextEntryNode)ctx.getEntries().get(1);
        MatcherAssert.assertThat((Object)entry.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameDefNode.class)));
        name = (NameDefNode)entry.getName();
        MatcherAssert.assertThat((Object)name.getParts(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)name.getParts().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)entry.getName().getText(), (Matcher)CoreMatchers.is((Object)"another variable"));
        MatcherAssert.assertThat((Object)entry.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)entry.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        MatcherAssert.assertThat((Object)entry.getValue().getText(), (Matcher)CoreMatchers.is((Object)"a variable with in keyword + 20"));
        entry = (ContextEntryNode)ctx.getEntries().get(2);
        MatcherAssert.assertThat((Object)entry.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameDefNode.class)));
        name = (NameDefNode)entry.getName();
        MatcherAssert.assertThat((Object)name.getParts(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)name.getParts().size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)entry.getName().getText(), (Matcher)CoreMatchers.is((Object)"another in variable"));
        MatcherAssert.assertThat((Object)entry.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)entry.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        MatcherAssert.assertThat((Object)entry.getValue().getText(), (Matcher)CoreMatchers.is((Object)"an external in variable / 2"));
    }

    @Test
    public void testNestedContexts() {
        String inputExpression = "{ a value : 10, an applicant : {     first name : \"Edson\",     last + name : \"Tirelli\",     full name : first name + last + name,     address : {        street : \"55 broadway st\",        city : \"New York\"     },     xxx: last + name } }";
        BaseNode ctxbase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)ctxbase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ContextNode.class)));
        MatcherAssert.assertThat((Object)ctxbase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        ContextNode ctx = (ContextNode)ctxbase;
        MatcherAssert.assertThat((Object)ctx.getEntries().size(), (Matcher)CoreMatchers.is((Object)2));
        ContextEntryNode entry = (ContextEntryNode)ctx.getEntries().get(0);
        MatcherAssert.assertThat((Object)entry.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameDefNode.class)));
        NameDefNode name = (NameDefNode)entry.getName();
        MatcherAssert.assertThat((Object)name.getText(), (Matcher)CoreMatchers.is((Object)"a value"));
        MatcherAssert.assertThat((Object)entry.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)entry.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.NUMBER));
        MatcherAssert.assertThat((Object)entry.getValue().getText(), (Matcher)CoreMatchers.is((Object)"10"));
        entry = (ContextEntryNode)ctx.getEntries().get(1);
        MatcherAssert.assertThat((Object)entry.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameDefNode.class)));
        name = (NameDefNode)entry.getName();
        MatcherAssert.assertThat((Object)name.getText(), (Matcher)CoreMatchers.is((Object)"an applicant"));
        MatcherAssert.assertThat((Object)entry.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ContextNode.class)));
        ContextNode applicant = (ContextNode)entry.getValue();
        MatcherAssert.assertThat((Object)applicant.getEntries().size(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)((ContextEntryNode)applicant.getEntries().get(0)).getName().getText(), (Matcher)CoreMatchers.is((Object)"first name"));
        MatcherAssert.assertThat((Object)((ContextEntryNode)applicant.getEntries().get(0)).getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.STRING));
        MatcherAssert.assertThat((Object)((ContextEntryNode)applicant.getEntries().get(1)).getName().getText(), (Matcher)CoreMatchers.is((Object)"last + name"));
        MatcherAssert.assertThat((Object)((ContextEntryNode)applicant.getEntries().get(1)).getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.STRING));
        MatcherAssert.assertThat((Object)((ContextEntryNode)applicant.getEntries().get(2)).getName().getText(), (Matcher)CoreMatchers.is((Object)"full name"));
        MatcherAssert.assertThat((Object)((ContextEntryNode)applicant.getEntries().get(2)).getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.STRING));
        MatcherAssert.assertThat((Object)((ContextEntryNode)applicant.getEntries().get(3)).getName().getText(), (Matcher)CoreMatchers.is((Object)"address"));
        MatcherAssert.assertThat((Object)((ContextEntryNode)applicant.getEntries().get(3)).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ContextNode.class)));
        ContextNode address = (ContextNode)((ContextEntryNode)applicant.getEntries().get(3)).getValue();
        MatcherAssert.assertThat((Object)address.getEntries().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((ContextEntryNode)address.getEntries().get(0)).getName().getText(), (Matcher)CoreMatchers.is((Object)"street"));
        MatcherAssert.assertThat((Object)((ContextEntryNode)address.getEntries().get(0)).getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.STRING));
        MatcherAssert.assertThat((Object)((ContextEntryNode)address.getEntries().get(1)).getName().getText(), (Matcher)CoreMatchers.is((Object)"city"));
        MatcherAssert.assertThat((Object)((ContextEntryNode)address.getEntries().get(0)).getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.STRING));
    }

    @Test
    public void testNestedContexts2() {
        String inputExpression = "{ an applicant : {     home address : {        street name: \"broadway st\",        city : \"New York\"     }  },\n  street : an applicant.home address.street name \n}";
        BaseNode ctxbase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)ctxbase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ContextNode.class)));
        MatcherAssert.assertThat((Object)ctxbase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        ContextNode ctx = (ContextNode)ctxbase;
        MatcherAssert.assertThat((Object)ctx.getEntries().size(), (Matcher)CoreMatchers.is((Object)2));
        ContextEntryNode entry = (ContextEntryNode)ctx.getEntries().get(1);
        MatcherAssert.assertThat((Object)entry.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameDefNode.class)));
        MatcherAssert.assertThat((Object)entry.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.STRING));
        NameDefNode name = (NameDefNode)entry.getName();
        MatcherAssert.assertThat((Object)name.getText(), (Matcher)CoreMatchers.is((Object)"street"));
        MatcherAssert.assertThat((Object)entry.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(QualifiedNameNode.class)));
        QualifiedNameNode qnn = (QualifiedNameNode)entry.getValue();
        MatcherAssert.assertThat((Object)((NameRefNode)qnn.getParts().get(0)).getText(), (Matcher)CoreMatchers.is((Object)"an applicant"));
        MatcherAssert.assertThat((Object)((NameRefNode)qnn.getParts().get(1)).getText(), (Matcher)CoreMatchers.is((Object)"home address"));
        MatcherAssert.assertThat((Object)((NameRefNode)qnn.getParts().get(2)).getText(), (Matcher)CoreMatchers.is((Object)"street name"));
    }

    @Test
    public void testFunctionDefinition() {
        String inputExpression = "{ is minor : function( person's age ) person's age < 21 }";
        BaseNode ctxbase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)ctxbase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ContextNode.class)));
        MatcherAssert.assertThat((Object)ctxbase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        ContextNode ctx = (ContextNode)ctxbase;
        MatcherAssert.assertThat((Object)ctx.getEntries().size(), (Matcher)CoreMatchers.is((Object)1));
        ContextEntryNode entry = (ContextEntryNode)ctx.getEntries().get(0);
        MatcherAssert.assertThat((Object)entry.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameDefNode.class)));
        NameDefNode name = (NameDefNode)entry.getName();
        MatcherAssert.assertThat((Object)name.getText(), (Matcher)CoreMatchers.is((Object)"is minor"));
        MatcherAssert.assertThat((Object)entry.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FunctionDefNode.class)));
        MatcherAssert.assertThat((Object)entry.getValue().getText(), (Matcher)CoreMatchers.is((Object)"function( person's age ) person's age < 21"));
        FunctionDefNode isMinorFunc = (FunctionDefNode)entry.getValue();
        MatcherAssert.assertThat((Object)isMinorFunc.getFormalParameters().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((FormalParameterNode)isMinorFunc.getFormalParameters().get(0)).getText(), (Matcher)CoreMatchers.is((Object)"person's age"));
        MatcherAssert.assertThat((Object)isMinorFunc.isExternal(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)isMinorFunc.getBody(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
    }

    @Test
    public void testExternalFunctionDefinition() {
        String inputExpression = "{ trigonometric cosine : function( angle ) external {    java : {        class : \"java.lang.Math\",        method signature : \"cos(double)\"    }}}";
        BaseNode ctxbase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)ctxbase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ContextNode.class)));
        MatcherAssert.assertThat((Object)ctxbase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        ContextNode ctx = (ContextNode)ctxbase;
        MatcherAssert.assertThat((Object)ctx.getEntries().size(), (Matcher)CoreMatchers.is((Object)1));
        ContextEntryNode entry = (ContextEntryNode)ctx.getEntries().get(0);
        MatcherAssert.assertThat((Object)entry.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameDefNode.class)));
        NameDefNode name = (NameDefNode)entry.getName();
        MatcherAssert.assertThat((Object)name.getText(), (Matcher)CoreMatchers.is((Object)"trigonometric cosine"));
        MatcherAssert.assertThat((Object)entry.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FunctionDefNode.class)));
        MatcherAssert.assertThat((Object)entry.getValue().getText(), (Matcher)CoreMatchers.is((Object)"function( angle ) external {    java : {        class : \"java.lang.Math\",        method signature : \"cos(double)\"    }}"));
        FunctionDefNode cos = (FunctionDefNode)entry.getValue();
        MatcherAssert.assertThat((Object)cos.getFormalParameters().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((FormalParameterNode)cos.getFormalParameters().get(0)).getText(), (Matcher)CoreMatchers.is((Object)"angle"));
        MatcherAssert.assertThat((Object)cos.isExternal(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)cos.getBody(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ContextNode.class)));
        ContextNode body = (ContextNode)cos.getBody();
        MatcherAssert.assertThat((Object)body.getEntries().size(), (Matcher)CoreMatchers.is((Object)1));
        ContextEntryNode java = (ContextEntryNode)body.getEntries().get(0);
        MatcherAssert.assertThat((Object)java.getName().getText(), (Matcher)CoreMatchers.is((Object)"java"));
        MatcherAssert.assertThat((Object)java.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ContextNode.class)));
        ContextNode def = (ContextNode)java.getValue();
        MatcherAssert.assertThat((Object)def.getEntries().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((ContextEntryNode)def.getEntries().get(0)).getName().getText(), (Matcher)CoreMatchers.is((Object)"class"));
        MatcherAssert.assertThat((Object)((ContextEntryNode)def.getEntries().get(0)).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringNode.class)));
        MatcherAssert.assertThat((Object)((ContextEntryNode)def.getEntries().get(0)).getValue().getText(), (Matcher)CoreMatchers.is((Object)"\"java.lang.Math\""));
        MatcherAssert.assertThat((Object)((ContextEntryNode)def.getEntries().get(1)).getName().getText(), (Matcher)CoreMatchers.is((Object)"method signature"));
        MatcherAssert.assertThat((Object)((ContextEntryNode)def.getEntries().get(1)).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringNode.class)));
        MatcherAssert.assertThat((Object)((ContextEntryNode)def.getEntries().get(1)).getValue().getText(), (Matcher)CoreMatchers.is((Object)"\"cos(double)\""));
    }

    @Test
    public void testForExpression() {
        String inputExpression = "for item in order.items return item.price * item.quantity";
        BaseNode forbase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)forbase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ForExpressionNode.class)));
        MatcherAssert.assertThat((Object)forbase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        MatcherAssert.assertThat((Object)forbase.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.LIST));
        ForExpressionNode forExpr = (ForExpressionNode)forbase;
        MatcherAssert.assertThat((Object)forExpr.getIterationContexts().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)forExpr.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)forExpr.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"item.price * item.quantity"));
        IterationContextNode ic = (IterationContextNode)forExpr.getIterationContexts().get(0);
        MatcherAssert.assertThat((Object)ic.getName().getText(), (Matcher)CoreMatchers.is((Object)"item"));
        MatcherAssert.assertThat((Object)ic.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(QualifiedNameNode.class)));
        MatcherAssert.assertThat((Object)ic.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"order.items"));
    }

    @Test
    public void testIfExpression() {
        String inputExpression = "if applicant.age < 18 then \"declined\" else \"accepted\"";
        BaseNode ifBase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)ifBase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(IfExpressionNode.class)));
        MatcherAssert.assertThat((Object)ifBase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        MatcherAssert.assertThat((Object)ifBase.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.STRING));
        IfExpressionNode ifExpr = (IfExpressionNode)ifBase;
        MatcherAssert.assertThat((Object)ifExpr.getCondition().getText(), (Matcher)CoreMatchers.is((Object)"applicant.age < 18"));
        MatcherAssert.assertThat((Object)ifExpr.getThenExpression().getText(), (Matcher)CoreMatchers.is((Object)"\"declined\""));
        MatcherAssert.assertThat((Object)ifExpr.getElseExpression().getText(), (Matcher)CoreMatchers.is((Object)"\"accepted\""));
    }

    @Test
    public void testQuantifiedExpressionSome() {
        String inputExpression = "some item in order.items satisfies item.price > 100";
        BaseNode someBase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)someBase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(QuantifiedExpressionNode.class)));
        MatcherAssert.assertThat((Object)someBase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        MatcherAssert.assertThat((Object)someBase.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        QuantifiedExpressionNode someExpr = (QuantifiedExpressionNode)someBase;
        MatcherAssert.assertThat((Object)someExpr.getQuantifier(), (Matcher)CoreMatchers.is((Object)QuantifiedExpressionNode.Quantifier.SOME));
        MatcherAssert.assertThat((Object)someExpr.getIterationContexts().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((IterationContextNode)someExpr.getIterationContexts().get(0)).getText(), (Matcher)CoreMatchers.is((Object)"item in order.items"));
        MatcherAssert.assertThat((Object)someExpr.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"item.price > 100"));
    }

    @Test
    public void testQuantifiedExpressionEvery() {
        String inputExpression = "every item in order.items satisfies item.price > 100";
        BaseNode everyBase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)everyBase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(QuantifiedExpressionNode.class)));
        MatcherAssert.assertThat((Object)everyBase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        MatcherAssert.assertThat((Object)everyBase.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        QuantifiedExpressionNode everyExpr = (QuantifiedExpressionNode)everyBase;
        MatcherAssert.assertThat((Object)everyExpr.getQuantifier(), (Matcher)CoreMatchers.is((Object)QuantifiedExpressionNode.Quantifier.EVERY));
        MatcherAssert.assertThat((Object)everyExpr.getIterationContexts().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((IterationContextNode)everyExpr.getIterationContexts().get(0)).getText(), (Matcher)CoreMatchers.is((Object)"item in order.items"));
        MatcherAssert.assertThat((Object)everyExpr.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"item.price > 100"));
    }

    @Test
    public void testInstanceOfExpression() {
        String inputExpression = "\"foo\" instance of string";
        BaseNode instanceOfBase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)instanceOfBase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InstanceOfNode.class)));
        MatcherAssert.assertThat((Object)instanceOfBase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        MatcherAssert.assertThat((Object)instanceOfBase.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        InstanceOfNode ioExpr = (InstanceOfNode)instanceOfBase;
        MatcherAssert.assertThat((Object)ioExpr.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringNode.class)));
        MatcherAssert.assertThat((Object)ioExpr.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"\"foo\""));
        MatcherAssert.assertThat((Object)ioExpr.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TypeNode.class)));
        MatcherAssert.assertThat((Object)ioExpr.getType().getText(), (Matcher)CoreMatchers.is((Object)"string"));
    }

    @Test
    public void testInstanceOfExpressionAnd() {
        String inputExpression = "\"foo\" instance of string and 10 instance of number";
        BaseNode andExpr = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)andExpr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)andExpr.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        MatcherAssert.assertThat((Object)andExpr.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        InfixOpNode and = (InfixOpNode)andExpr;
        MatcherAssert.assertThat((Object)and.getOperator(), (Matcher)CoreMatchers.is((Object)InfixOpNode.InfixOperator.AND));
        MatcherAssert.assertThat((Object)and.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InstanceOfNode.class)));
        MatcherAssert.assertThat((Object)and.getRight(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InstanceOfNode.class)));
        MatcherAssert.assertThat((Object)and.getLeft().getText(), (Matcher)CoreMatchers.is((Object)"\"foo\" instance of string"));
        MatcherAssert.assertThat((Object)and.getRight().getText(), (Matcher)CoreMatchers.is((Object)"10 instance of number"));
        MatcherAssert.assertThat((Object)and.getLeft().getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        MatcherAssert.assertThat((Object)and.getRight().getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        InstanceOfNode ioExpr = (InstanceOfNode)and.getLeft();
        MatcherAssert.assertThat((Object)ioExpr.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringNode.class)));
        MatcherAssert.assertThat((Object)ioExpr.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"\"foo\""));
        MatcherAssert.assertThat((Object)ioExpr.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TypeNode.class)));
        MatcherAssert.assertThat((Object)ioExpr.getType().getText(), (Matcher)CoreMatchers.is((Object)"string"));
        ioExpr = (InstanceOfNode)and.getRight();
        MatcherAssert.assertThat((Object)ioExpr.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NumberNode.class)));
        MatcherAssert.assertThat((Object)ioExpr.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"10"));
        MatcherAssert.assertThat((Object)ioExpr.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TypeNode.class)));
        MatcherAssert.assertThat((Object)ioExpr.getType().getText(), (Matcher)CoreMatchers.is((Object)"number"));
    }

    @Test
    public void testInstanceOfExpressionFunction() {
        String inputExpression = "duration instance of function";
        BaseNode instanceOfBase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)instanceOfBase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InstanceOfNode.class)));
        MatcherAssert.assertThat((Object)instanceOfBase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        MatcherAssert.assertThat((Object)instanceOfBase.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.BOOLEAN));
        InstanceOfNode ioExpr = (InstanceOfNode)instanceOfBase;
        MatcherAssert.assertThat((Object)ioExpr.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)ioExpr.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"duration"));
        MatcherAssert.assertThat((Object)ioExpr.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TypeNode.class)));
        MatcherAssert.assertThat((Object)ioExpr.getType().getText(), (Matcher)CoreMatchers.is((Object)"function"));
    }

    @Test
    public void testPathExpression() {
        String inputExpression = "[ 10, 15 ].size";
        BaseNode pathBase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)pathBase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(PathExpressionNode.class)));
        MatcherAssert.assertThat((Object)pathBase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        PathExpressionNode pathExpr = (PathExpressionNode)pathBase;
        MatcherAssert.assertThat((Object)pathExpr.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ListNode.class)));
        MatcherAssert.assertThat((Object)pathExpr.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"10, 15"));
        MatcherAssert.assertThat((Object)pathExpr.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)pathExpr.getName().getText(), (Matcher)CoreMatchers.is((Object)"size"));
    }

    @Test
    public void testFilterExpression() {
        String inputExpression = "[ {x:1, y:2}, {x:2, y:3} ][ x=1 ]";
        BaseNode filterBase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)filterBase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FilterExpressionNode.class)));
        MatcherAssert.assertThat((Object)filterBase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        FilterExpressionNode filter = (FilterExpressionNode)filterBase;
        MatcherAssert.assertThat((Object)filter.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ListNode.class)));
        MatcherAssert.assertThat((Object)filter.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"{x:1, y:2}, {x:2, y:3}"));
        MatcherAssert.assertThat((Object)filter.getFilter(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)filter.getFilter().getText(), (Matcher)CoreMatchers.is((Object)"x=1"));
    }

    @Test
    public void testFunctionInvocationNamedParams() {
        String inputExpression = "my.test.Function( named parameter 1 : x+10, named parameter 2 : \"foo\" )";
        BaseNode functionBase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)functionBase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FunctionInvocationNode.class)));
        MatcherAssert.assertThat((Object)functionBase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        FunctionInvocationNode function = (FunctionInvocationNode)functionBase;
        MatcherAssert.assertThat((Object)function.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(QualifiedNameNode.class)));
        MatcherAssert.assertThat((Object)function.getName().getText(), (Matcher)CoreMatchers.is((Object)"my.test.Function"));
        MatcherAssert.assertThat((Object)function.getParams(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ListNode.class)));
        MatcherAssert.assertThat((Object)function.getParams().getElements().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((BaseNode)function.getParams().getElements().get(0)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NamedParameterNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)function.getParams().getElements().get(1)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NamedParameterNode.class)));
        NamedParameterNode named = (NamedParameterNode)function.getParams().getElements().get(0);
        MatcherAssert.assertThat((Object)named.getText(), (Matcher)CoreMatchers.is((Object)"named parameter 1 : x+10"));
        MatcherAssert.assertThat((Object)named.getName().getText(), (Matcher)CoreMatchers.is((Object)"named parameter 1"));
        MatcherAssert.assertThat((Object)named.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)named.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"x+10"));
        named = (NamedParameterNode)function.getParams().getElements().get(1);
        MatcherAssert.assertThat((Object)named.getText(), (Matcher)CoreMatchers.is((Object)"named parameter 2 : \"foo\""));
        MatcherAssert.assertThat((Object)named.getName().getText(), (Matcher)CoreMatchers.is((Object)"named parameter 2"));
        MatcherAssert.assertThat((Object)named.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringNode.class)));
        MatcherAssert.assertThat((Object)named.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"\"foo\""));
    }

    @Test
    public void testFunctionInvocationPositionalParams() {
        String inputExpression = "my.test.Function( x+10, \"foo\" )";
        BaseNode functionBase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)functionBase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FunctionInvocationNode.class)));
        MatcherAssert.assertThat((Object)functionBase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        FunctionInvocationNode function = (FunctionInvocationNode)functionBase;
        MatcherAssert.assertThat((Object)function.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(QualifiedNameNode.class)));
        MatcherAssert.assertThat((Object)function.getName().getText(), (Matcher)CoreMatchers.is((Object)"my.test.Function"));
        MatcherAssert.assertThat((Object)function.getParams(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ListNode.class)));
        MatcherAssert.assertThat((Object)function.getParams().getElements().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((BaseNode)function.getParams().getElements().get(0)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InfixOpNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)function.getParams().getElements().get(1)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringNode.class)));
    }

    @Test
    public void testFunctionInvocationWithKeyword() {
        String inputExpression = "date and time( \"2016-07-29T19:47:53\" )";
        BaseNode functionBase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)functionBase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FunctionInvocationNode.class)));
        MatcherAssert.assertThat((Object)functionBase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        FunctionInvocationNode function = (FunctionInvocationNode)functionBase;
        MatcherAssert.assertThat((Object)function.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)function.getName().getText(), (Matcher)CoreMatchers.is((Object)"date and time"));
        MatcherAssert.assertThat((Object)function.getParams(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ListNode.class)));
        MatcherAssert.assertThat((Object)function.getParams().getElements().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((BaseNode)function.getParams().getElements().get(0)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringNode.class)));
    }

    @Test
    public void testFunctionInvocationWithExpressionParameters() {
        String inputExpression = "date and time( date(\"2016-07-29\"), time(\"19:47:53\") )";
        BaseNode functionBase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)functionBase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FunctionInvocationNode.class)));
        MatcherAssert.assertThat((Object)functionBase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        FunctionInvocationNode function = (FunctionInvocationNode)functionBase;
        MatcherAssert.assertThat((Object)function.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)function.getName().getText(), (Matcher)CoreMatchers.is((Object)"date and time"));
        MatcherAssert.assertThat((Object)function.getParams(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ListNode.class)));
        MatcherAssert.assertThat((Object)function.getParams().getElements().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((BaseNode)function.getParams().getElements().get(0)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FunctionInvocationNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)function.getParams().getElements().get(1)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FunctionInvocationNode.class)));
    }

    @Test
    public void testFunctionInvocationEmptyParams() {
        String inputExpression = "my.test.Function()";
        BaseNode functionBase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)functionBase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FunctionInvocationNode.class)));
        MatcherAssert.assertThat((Object)functionBase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        FunctionInvocationNode function = (FunctionInvocationNode)functionBase;
        MatcherAssert.assertThat((Object)function.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(QualifiedNameNode.class)));
        MatcherAssert.assertThat((Object)function.getName().getText(), (Matcher)CoreMatchers.is((Object)"my.test.Function"));
        MatcherAssert.assertThat((Object)function.getParams(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ListNode.class)));
        MatcherAssert.assertThat((Object)function.getParams().getElements(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Ignore(value="dropped since DMNv1.2")
    @Test
    public void testFunctionDecisionTableInvocation() {
        String inputExpression = "decision table(     outputs: \"Applicant Risk Rating\",    input expression list: [\"Applicant Age\", \"Medical History\"],    rule list: [        [ >60      , \"good\" , \"Medium\" ],        [ >60      , \"bad\"  , \"High\"   ],        [ [25..60] , -        , \"Medium\" ],        [ <25      , \"good\" , \"Low\"    ],        [ <25      , \"bad\"  , \"Medium\" ] ],    hit policy: \"Unique\" )";
        BaseNode functionBase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)functionBase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FunctionInvocationNode.class)));
        MatcherAssert.assertThat((Object)functionBase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        FunctionInvocationNode function = (FunctionInvocationNode)functionBase;
        MatcherAssert.assertThat((Object)function.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)function.getName().getText(), (Matcher)CoreMatchers.is((Object)"decision table"));
        MatcherAssert.assertThat((Object)function.getParams(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ListNode.class)));
        MatcherAssert.assertThat((Object)function.getParams().getElements().size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)((BaseNode)function.getParams().getElements().get(0)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NamedParameterNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)function.getParams().getElements().get(1)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NamedParameterNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)function.getParams().getElements().get(2)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NamedParameterNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)function.getParams().getElements().get(3)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NamedParameterNode.class)));
        NamedParameterNode named = (NamedParameterNode)function.getParams().getElements().get(0);
        MatcherAssert.assertThat((Object)named.getText(), (Matcher)CoreMatchers.is((Object)"outputs: \"Applicant Risk Rating\""));
        MatcherAssert.assertThat((Object)named.getName().getText(), (Matcher)CoreMatchers.is((Object)"outputs"));
        MatcherAssert.assertThat((Object)named.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringNode.class)));
        MatcherAssert.assertThat((Object)named.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"\"Applicant Risk Rating\""));
        named = (NamedParameterNode)function.getParams().getElements().get(1);
        MatcherAssert.assertThat((Object)named.getName().getText(), (Matcher)CoreMatchers.is((Object)"input expression list"));
        MatcherAssert.assertThat((Object)named.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ListNode.class)));
        ListNode list = (ListNode)named.getExpression();
        MatcherAssert.assertThat((Object)list.getElements().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(0)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(0)).getText(), (Matcher)CoreMatchers.is((Object)"\"Applicant Age\""));
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(1)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(1)).getText(), (Matcher)CoreMatchers.is((Object)"\"Medical History\""));
        named = (NamedParameterNode)function.getParams().getElements().get(2);
        MatcherAssert.assertThat((Object)named.getName().getText(), (Matcher)CoreMatchers.is((Object)"rule list"));
        MatcherAssert.assertThat((Object)named.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ListNode.class)));
        list = (ListNode)named.getExpression();
        MatcherAssert.assertThat((Object)list.getElements().size(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)((BaseNode)list.getElements().get(0)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ListNode.class)));
        ListNode rule = (ListNode)list.getElements().get(0);
        MatcherAssert.assertThat((Object)rule.getElements().size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((BaseNode)rule.getElements().get(0)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RangeNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)rule.getElements().get(0)).getText(), (Matcher)CoreMatchers.is((Object)">60"));
        MatcherAssert.assertThat((Object)((BaseNode)rule.getElements().get(1)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)rule.getElements().get(1)).getText(), (Matcher)CoreMatchers.is((Object)"\"good\""));
        MatcherAssert.assertThat((Object)((BaseNode)rule.getElements().get(2)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringNode.class)));
        MatcherAssert.assertThat((Object)((BaseNode)rule.getElements().get(2)).getText(), (Matcher)CoreMatchers.is((Object)"\"Medium\""));
        named = (NamedParameterNode)function.getParams().getElements().get(3);
        MatcherAssert.assertThat((Object)named.getName().getText(), (Matcher)CoreMatchers.is((Object)"hit policy"));
        MatcherAssert.assertThat((Object)named.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringNode.class)));
        MatcherAssert.assertThat((Object)named.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"\"Unique\""));
    }

    @Test
    public void testContextPathExpression() {
        String inputExpression = "{ x : \"foo\" }.x";
        BaseNode pathBase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)pathBase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(PathExpressionNode.class)));
        MatcherAssert.assertThat((Object)pathBase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        MatcherAssert.assertThat((Object)pathBase.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.STRING));
        PathExpressionNode pathExpr = (PathExpressionNode)pathBase;
        MatcherAssert.assertThat((Object)pathExpr.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ContextNode.class)));
        MatcherAssert.assertThat((Object)pathExpr.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"{ x : \"foo\" }"));
        MatcherAssert.assertThat((Object)pathExpr.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)pathExpr.getName().getText(), (Matcher)CoreMatchers.is((Object)"x"));
    }

    @Test
    public void testContextPathExpression2() {
        String inputExpression = "{ x : { y : \"foo\" } }.x.y";
        BaseNode pathBase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)pathBase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(PathExpressionNode.class)));
        MatcherAssert.assertThat((Object)pathBase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        MatcherAssert.assertThat((Object)pathBase.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.STRING));
        PathExpressionNode pathExpr = (PathExpressionNode)pathBase;
        MatcherAssert.assertThat((Object)pathExpr.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ContextNode.class)));
        MatcherAssert.assertThat((Object)pathExpr.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"{ x : { y : \"foo\" } }"));
        MatcherAssert.assertThat((Object)pathExpr.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(QualifiedNameNode.class)));
        MatcherAssert.assertThat((Object)pathExpr.getName().getText(), (Matcher)CoreMatchers.is((Object)"x.y"));
    }

    @Test
    public void testContextPathExpression3() {
        String inputExpression = "{ first name : \"bob\" }.first name";
        BaseNode pathBase = this.parse(inputExpression);
        MatcherAssert.assertThat((Object)pathBase, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(PathExpressionNode.class)));
        MatcherAssert.assertThat((Object)pathBase.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        MatcherAssert.assertThat((Object)pathBase.getResultType(), (Matcher)CoreMatchers.is((Object)BuiltInType.STRING));
        PathExpressionNode pathExpr = (PathExpressionNode)pathBase;
        MatcherAssert.assertThat((Object)pathExpr.getExpression(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ContextNode.class)));
        MatcherAssert.assertThat((Object)pathExpr.getExpression().getText(), (Matcher)CoreMatchers.is((Object)"{ first name : \"bob\" }"));
        MatcherAssert.assertThat((Object)pathExpr.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NameRefNode.class)));
        MatcherAssert.assertThat((Object)pathExpr.getName().getText(), (Matcher)CoreMatchers.is((Object)"first name"));
    }

    @Test
    public void testVariableName() {
        String var = "valid variable name";
        MatcherAssert.assertThat((Object)FEELParser.isVariableNameValid((String)var), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testVariableNameWithValidCharacters() {
        String var = "?_873./-'+*valid";
        MatcherAssert.assertThat((Object)FEELParser.isVariableNameValid((String)var), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testVariableNameWithValidCharactersHorseEmoji() {
        String var = "\ud83d\udc0e";
        MatcherAssert.assertThat((Object)FEELParser.isVariableNameValid((String)var), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testVariableNameWithInvalidCharacterPercentSimplified() {
        String var = "banana%mango";
        MatcherAssert.assertThat((Object)FEELParser.isVariableNameValid((String)var), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((FEELEvent)FEELParser.checkVariableName((String)var).get(0)).getMessage(), (Matcher)CoreMatchers.is((Object)Msg.createMessage((Msg.Message2)Msg.INVALID_VARIABLE_NAME, (Object)"character", (Object)"%")));
    }

    @Test
    public void testVariableNameWithInvalidCharacterPercent() {
        String var = "?_873./-'%+*valid";
        MatcherAssert.assertThat((Object)FEELParser.isVariableNameValid((String)var), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((FEELEvent)FEELParser.checkVariableName((String)var).get(0)).getMessage(), (Matcher)CoreMatchers.is((Object)Msg.createMessage((Msg.Message2)Msg.INVALID_VARIABLE_NAME, (Object)"character", (Object)"%")));
    }

    @Test
    public void testVariableNameWithInvalidCharacterAt() {
        String var = "?_873./-'@+*valid";
        MatcherAssert.assertThat((Object)FEELParser.isVariableNameValid((String)var), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((FEELEvent)FEELParser.checkVariableName((String)var).get(0)).getMessage(), (Matcher)CoreMatchers.is((Object)Msg.createMessage((Msg.Message2)Msg.INVALID_VARIABLE_NAME, (Object)"character", (Object)"@")));
    }

    @Test
    public void testVariableNameInvalidStartCharacter() {
        String var = "5variable can't start with a number";
        MatcherAssert.assertThat((Object)FEELParser.isVariableNameValid((String)var), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((FEELEvent)FEELParser.checkVariableName((String)var).get(0)).getMessage(), (Matcher)CoreMatchers.is((Object)Msg.createMessage((Msg.Message2)Msg.INVALID_VARIABLE_NAME_START, (Object)"character", (Object)"5")));
    }

    @Test
    public void testVariableNameCantStartWithKeyword() {
        String var = "for keyword is an invalid start for a variable name";
        MatcherAssert.assertThat((Object)FEELParser.isVariableNameValid((String)var), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((FEELEvent)FEELParser.checkVariableName((String)var).get(0)).getMessage(), (Matcher)CoreMatchers.is((Object)Msg.createMessage((Msg.Message2)Msg.INVALID_VARIABLE_NAME_START, (Object)"keyword", (Object)"for")));
    }

    public static void assertLocation(String inputExpression, ASTNode number) {
        MatcherAssert.assertThat((Object)number.getText(), (Matcher)CoreMatchers.is((Object)inputExpression));
        MatcherAssert.assertThat((Object)number.getStartChar(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)number.getStartLine(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)number.getStartColumn(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)number.getEndChar(), (Matcher)CoreMatchers.is((Object)(inputExpression.length() - 1)));
        MatcherAssert.assertThat((Object)number.getEndLine(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)number.getEndColumn(), (Matcher)CoreMatchers.is((Object)inputExpression.length()));
    }

    private BaseNode parse(String input) {
        return this.parse(input, Collections.emptyMap());
    }

    private BaseNode parse(String input, Map<String, Type> inputTypes) {
        FEEL_1_1Parser parser = FEELParser.parse(null, (String)input, inputTypes, Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), null);
        FEEL_1_1Parser.ExpressionContext tree = parser.expression();
        ASTBuilderVisitor v = new ASTBuilderVisitor(inputTypes, null);
        BaseNode expr = (BaseNode)v.visit((ParseTree)tree);
        return expr;
    }
}

