/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.DayOfWeekFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class DayOfWeekTest {
    private DayOfWeekFunction fut;

    @Before
    public void setUp() {
        this.fut = DayOfWeekFunction.INSTANCE;
    }

    @Test
    public void testDayOfWeekFunctionTemporalAccessor() {
        FunctionTestUtil.assertResult(this.fut.invoke((TemporalAccessor)LocalDate.of(2019, 9, 17)), "Tuesday");
        FunctionTestUtil.assertResult(this.fut.invoke((TemporalAccessor)LocalDateTime.of(2019, 9, 17, 0, 0, 0)), "Tuesday");
        FunctionTestUtil.assertResult(this.fut.invoke((TemporalAccessor)OffsetDateTime.of(2019, 9, 17, 0, 0, 0, 0, ZoneOffset.UTC)), "Tuesday");
        FunctionTestUtil.assertResult(this.fut.invoke((TemporalAccessor)ZonedDateTime.of(2019, 9, 17, 0, 0, 0, 0, ZoneOffset.UTC)), "Tuesday");
        FunctionTestUtil.assertResultError(this.fut.invoke(null), InvalidParametersEvent.class);
    }
}

