/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.examples;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.examples.ExamplesBaseTest;
import org.kie.dmn.feel.lang.examples.ExamplesTest;
import org.kie.dmn.feel.runtime.events.HitPolicyViolationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDecisionTablesTest
extends ExamplesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ExamplesTest.class);
    private static FEEL feel;

    @BeforeClass
    public static void setupTest() {
        feel = FEEL.newInstance();
        feel.addListener(evt -> {
            if (evt.getSeverity() == FEELEvent.Severity.ERROR) {
                logger.error("{}", (Object)evt);
                if (evt.getSourceException().getCause() != null) {
                    for (Throwable c = evt.getSourceException().getCause(); c != null; c = c.getCause()) {
                        logger.error(" caused by: {} {}", c.getClass(), (Object)(c.getMessage() != null ? c.getMessage() : ""));
                    }
                    logger.error(" [stacktraces omitted.]");
                }
            } else if (evt.getSeverity() == FEELEvent.Severity.WARN) {
                logger.warn("{}", (Object)evt);
            }
        });
    }

    @Test
    public void testMain() {
        ArrayList events = new ArrayList();
        FEELEventListener listener = evt -> events.add(evt);
        feel.addListener(listener);
        String expression = SimpleDecisionTablesTest.loadExpression("simple_decision_tables.feel");
        Map context = (Map)feel.evaluate(expression);
        System.out.println(this.printContext(context));
        Assert.assertThat(context.get("result1"), (Matcher)CoreMatchers.is((Object)"Adult"));
        Assert.assertThat(context.get("result2"), (Matcher)CoreMatchers.is((Object)"Medium"));
        Assert.assertThat((Object)((Map)context.get("result3")), SimpleDecisionTablesTest.hasSize(2));
        Assert.assertThat((Object)((Map)context.get("result3")), (Matcher)Matchers.hasEntry((Object)"Out1", (Object)"out1b"));
        Assert.assertThat((Object)((Map)context.get("result3")), (Matcher)Matchers.hasEntry((Object)"Out2", (Object)"out2b"));
        Assert.assertThat((Object)((Map)context.get("result4")), SimpleDecisionTablesTest.hasSize(2));
        Assert.assertThat((Object)((Map)context.get("result4")), (Matcher)Matchers.hasEntry((Object)"Out1", (Object)"io1a"));
        Assert.assertThat((Object)((Map)context.get("result4")), (Matcher)Matchers.hasEntry((Object)"Out2", (Object)"io2a"));
        Assert.assertThat(context.get("result5"), (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((boolean)events.stream().anyMatch(e -> e instanceof HitPolicyViolationEvent && e.getSeverity().equals((Object)FEELEvent.Severity.WARN)));
        feel.removeListener(listener);
    }

    @Test
    public void testDecisionTableFormulaOut() {
        String expression = SimpleDecisionTablesTest.loadExpression("dt_formula_out.feel");
        Map context = (Map)feel.evaluate(expression);
        System.out.println(this.printContext(context));
        Assert.assertThat(context.get("square area"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(25L)));
        Assert.assertThat(context.get("circle area"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(78.5).setScale(2)));
    }

    @Test
    public void testt0004simpletableU() {
        String expression = SimpleDecisionTablesTest.loadExpression("t0004simpletableU.feel");
        Map context = (Map)feel.evaluate(expression);
        System.out.println(this.printContext(context));
        Assert.assertThat(context.get("result1"), (Matcher)CoreMatchers.is((Object)"Approved"));
        Assert.assertThat(context.get("result2"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat(context.get("result3"), (Matcher)CoreMatchers.is((Object)"Declined"));
    }

    @Test
    public void testdthitpolicies() {
        String expression = SimpleDecisionTablesTest.loadExpression("dthitpolicies.feel");
        Map context = (Map)feel.evaluate(expression);
        System.out.println(this.printContext(context));
        Assert.assertThat(context.get("DTunique10"), (Matcher)CoreMatchers.is((Object)"row2"));
        Assert.assertThat(context.get("DTunique11"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat(context.get("DTfirst11"), (Matcher)CoreMatchers.is((Object)"row1"));
        Assert.assertThat(context.get("DTAny10"), (Matcher)CoreMatchers.is((Object)"B"));
        Assert.assertThat(context.get("DTAny11"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat(context.get("DTruleOrder10"), (Matcher)CoreMatchers.is(Arrays.asList("B", "B")));
        Assert.assertThat(context.get("DTruleOrder11"), (Matcher)CoreMatchers.is(Arrays.asList("A", "B", "B")));
        Assert.assertTrue((boolean)((List)context.get("DTcollect11")).contains("A"));
        Assert.assertTrue((boolean)((List)context.get("DTcollect11")).contains("B"));
        Assert.assertTrue((((List)context.get("DTcollect11")).size() == 2 ? 1 : 0) != 0);
        Assert.assertThat(context.get("DTpriority11"), (Matcher)CoreMatchers.is((Object)"B"));
        Assert.assertTrue((((List)context.get("DToutputOrder11")).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((List)context.get("DToutputOrder11")).get(0).equals("B"));
        Assert.assertTrue((boolean)((List)context.get("DToutputOrder11")).get(1).equals("A"));
        Assert.assertThat(context.get("DTcount10"), (Matcher)CoreMatchers.is((Object)new BigDecimal(1)));
        Assert.assertThat(context.get("DTcount11"), (Matcher)CoreMatchers.is((Object)new BigDecimal(2)));
        Assert.assertThat(context.get("DTsum10"), (Matcher)CoreMatchers.is((Object)new BigDecimal(5)));
        Assert.assertThat(context.get("DTsum11"), (Matcher)CoreMatchers.is((Object)new BigDecimal(6)));
        Assert.assertThat(context.get("DTmin10"), (Matcher)CoreMatchers.is((Object)new BigDecimal(2)));
        Assert.assertThat(context.get("DTmin11"), (Matcher)CoreMatchers.is((Object)new BigDecimal(1)));
        Assert.assertThat(context.get("DTmax10"), (Matcher)CoreMatchers.is((Object)new BigDecimal(3)));
        Assert.assertThat(context.get("DTmax11"), (Matcher)CoreMatchers.is((Object)new BigDecimal(3)));
    }

    @Test
    public void testdthitpoliciesMultipleOutput() {
        String expression = SimpleDecisionTablesTest.loadExpression("dthitpolicies_multipleoutput.feel");
        Map context = (Map)feel.evaluate(expression);
        System.out.println(this.printContext(context));
        Assert.assertThat((Object)((Map)context.get("DTunique10")), SimpleDecisionTablesTest.hasSize(2));
        Assert.assertThat((Object)((Map)context.get("DTunique10")), (Matcher)Matchers.hasEntry((Object)"Out1", (Object)"row2"));
        Assert.assertThat((Object)((Map)context.get("DTunique10")), (Matcher)Matchers.hasEntry((Object)"Out2", (Object)new BigDecimal(2)));
        Assert.assertThat(context.get("DTunique11"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)((Map)context.get("DTfirst11")), SimpleDecisionTablesTest.hasSize(2));
        Assert.assertThat((Object)((Map)context.get("DTfirst11")), (Matcher)Matchers.hasEntry((Object)"Out1", (Object)"row1"));
        Assert.assertThat((Object)((Map)context.get("DTfirst11")), (Matcher)Matchers.hasEntry((Object)"Out2", (Object)new BigDecimal(1)));
        Assert.assertThat((Object)((Map)context.get("DTAny10")), SimpleDecisionTablesTest.hasSize(2));
        Assert.assertThat((Object)((Map)context.get("DTAny10")), (Matcher)Matchers.hasEntry((Object)"Out1", (Object)"B"));
        Assert.assertThat((Object)((Map)context.get("DTAny10")), (Matcher)Matchers.hasEntry((Object)"Out2", (Object)new BigDecimal(7)));
        Assert.assertThat(context.get("DTAny11"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)((List)context.get("DTruleOrder10")), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat(((List)context.get("DTruleOrder10")).get(0), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out1"), (Matcher)CoreMatchers.is((Object)"B")));
        Assert.assertThat(((List)context.get("DTruleOrder10")).get(0), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out2"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(2L))));
        Assert.assertThat(((List)context.get("DTruleOrder10")).get(1), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out1"), (Matcher)CoreMatchers.is((Object)"B")));
        Assert.assertThat(((List)context.get("DTruleOrder10")).get(1), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out2"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(3L))));
        Assert.assertThat((Object)((List)context.get("DTruleOrder11")), (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat(((List)context.get("DTruleOrder11")).get(0), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out1"), (Matcher)CoreMatchers.is((Object)"A")));
        Assert.assertThat(((List)context.get("DTruleOrder11")).get(0), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out2"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(1L))));
        Assert.assertThat(((List)context.get("DTruleOrder11")).get(1), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out1"), (Matcher)CoreMatchers.is((Object)"B")));
        Assert.assertThat(((List)context.get("DTruleOrder11")).get(1), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out2"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(2L))));
        Assert.assertThat(((List)context.get("DTruleOrder11")).get(2), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out1"), (Matcher)CoreMatchers.is((Object)"B")));
        Assert.assertThat(((List)context.get("DTruleOrder11")).get(2), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out2"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(3L))));
        Assert.assertThat((Object)((List)context.get("DTcollect11")), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat(((List)context.get("DTcollect11")).get(0), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out1"), (Matcher)CoreMatchers.is((Object)"A")));
        Assert.assertThat(((List)context.get("DTcollect11")).get(0), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out2"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(1L))));
        Assert.assertThat(((List)context.get("DTcollect11")).get(1), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out1"), (Matcher)CoreMatchers.is((Object)"B")));
        Assert.assertThat(((List)context.get("DTcollect11")).get(1), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out2"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(2L))));
        Assert.assertThat((Object)((Map)context.get("DTpriority11")), SimpleDecisionTablesTest.hasSize(2));
        Assert.assertThat((Object)((Map)context.get("DTpriority11")), (Matcher)Matchers.hasEntry((Object)"Out1", (Object)"B"));
        Assert.assertThat((Object)((Map)context.get("DTpriority11")), (Matcher)Matchers.hasEntry((Object)"Out2", (Object)new BigDecimal(2)));
        Assert.assertThat((Object)((List)context.get("DToutputOrder11")), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat(((List)context.get("DToutputOrder11")).get(0), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out1"), (Matcher)CoreMatchers.is((Object)"B")));
        Assert.assertThat(((List)context.get("DToutputOrder11")).get(0), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out2"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(2L))));
        Assert.assertThat(((List)context.get("DToutputOrder11")).get(1), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out1"), (Matcher)CoreMatchers.is((Object)"A")));
        Assert.assertThat(((List)context.get("DToutputOrder11")).get(1), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out2"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(1L))));
        Assert.assertThat((Object)((Map)context.get("DTcount10")), SimpleDecisionTablesTest.hasSize(2));
        Assert.assertThat((Object)((Map)context.get("DTcount10")), (Matcher)Matchers.hasEntry((Object)"Out1", (Object)new BigDecimal(1)));
        Assert.assertThat((Object)((Map)context.get("DTcount10")), (Matcher)Matchers.hasEntry((Object)"Out2", (Object)new BigDecimal(2)));
        Assert.assertThat((Object)((Map)context.get("DTcount11")), SimpleDecisionTablesTest.hasSize(2));
        Assert.assertThat((Object)((Map)context.get("DTcount11")), (Matcher)Matchers.hasEntry((Object)"Out1", (Object)new BigDecimal(2)));
        Assert.assertThat((Object)((Map)context.get("DTcount11")), (Matcher)Matchers.hasEntry((Object)"Out2", (Object)new BigDecimal(3)));
        Assert.assertThat((Object)((Map)context.get("DTsum10")), SimpleDecisionTablesTest.hasSize(2));
        Assert.assertThat((Object)((Map)context.get("DTsum10")), (Matcher)Matchers.hasEntry((Object)"Out1", (Object)new BigDecimal(5)));
        Assert.assertThat((Object)((Map)context.get("DTsum10")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out2"), (Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)((Map)context.get("DTsum11")), SimpleDecisionTablesTest.hasSize(2));
        Assert.assertThat((Object)((Map)context.get("DTsum11")), (Matcher)Matchers.hasEntry((Object)"Out1", (Object)new BigDecimal(6)));
        Assert.assertThat((Object)((Map)context.get("DTsum11")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Out2"), (Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)((Map)context.get("DTmin10")), SimpleDecisionTablesTest.hasSize(2));
        Assert.assertThat((Object)((Map)context.get("DTmin10")), (Matcher)Matchers.hasEntry((Object)"Out1", (Object)new BigDecimal(2)));
        Assert.assertThat((Object)((Map)context.get("DTmin10")), (Matcher)Matchers.hasEntry((Object)"Out2", (Object)"B"));
        Assert.assertThat((Object)((Map)context.get("DTmin11")), SimpleDecisionTablesTest.hasSize(2));
        Assert.assertThat((Object)((Map)context.get("DTmin11")), (Matcher)Matchers.hasEntry((Object)"Out1", (Object)new BigDecimal(1)));
        Assert.assertThat((Object)((Map)context.get("DTmin11")), (Matcher)Matchers.hasEntry((Object)"Out2", (Object)"A"));
        Assert.assertThat((Object)((Map)context.get("DTmax10")), SimpleDecisionTablesTest.hasSize(2));
        Assert.assertThat((Object)((Map)context.get("DTmax10")), (Matcher)Matchers.hasEntry((Object)"Out1", (Object)new BigDecimal(3)));
        Assert.assertThat((Object)((Map)context.get("DTmax10")), (Matcher)Matchers.hasEntry((Object)"Out2", (Object)"C"));
        Assert.assertThat((Object)((Map)context.get("DTmax11")), SimpleDecisionTablesTest.hasSize(2));
        Assert.assertThat((Object)((Map)context.get("DTmax11")), (Matcher)Matchers.hasEntry((Object)"Out1", (Object)new BigDecimal(3)));
        Assert.assertThat((Object)((Map)context.get("DTmax11")), (Matcher)Matchers.hasEntry((Object)"Out2", (Object)"C"));
    }

    public static <K, V> Matcher<Map<K, V>> hasSize(final int z) {
        return new TypeSafeMatcher<Map<K, V>>(){

            public boolean matchesSafely(Map<K, V> arg0) {
                return arg0.size() == z;
            }

            public void describeTo(Description arg0) {
                arg0.appendText("not matching size " + z);
            }
        };
    }
}

