/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.marshaller;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.marshaller.FEELCodeMarshaller;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

@RunWith(value=Parameterized.class)
public class FEELCodeMarshallerUnmarshallTest {
    @Parameterized.Parameter(value=0)
    public Type feelType;
    @Parameterized.Parameter(value=1)
    public String value;
    @Parameterized.Parameter(value=2)
    public Object result;

    @Parameterized.Parameters(name="{index}: {0} ({1}) = {2}")
    public static Collection<Object[]> data() {
        Object[][] cases = new Object[][]{{BuiltInType.UNKNOWN, "2", BigDecimal.valueOf(2L)}, {BuiltInType.UNKNOWN, "2.0", BigDecimal.valueOf(2.0)}, {BuiltInType.UNKNOWN, "0.2", BigDecimal.valueOf(0.2)}, {BuiltInType.UNKNOWN, "0.2", BigDecimal.valueOf(0.2)}, {BuiltInType.UNKNOWN, "-0.2", BigDecimal.valueOf(-0.2)}, {BuiltInType.UNKNOWN, "\"foo\"", "foo"}, {BuiltInType.UNKNOWN, "\"\"", ""}, {BuiltInType.UNKNOWN, "true", true}, {BuiltInType.UNKNOWN, "false", false}, {BuiltInType.UNKNOWN, "date( \"2017-07-01\" )", LocalDate.of(2017, 7, 1)}, {BuiltInType.UNKNOWN, "time( \"14:32:55\" )", LocalTime.of(14, 32, 55)}, {BuiltInType.UNKNOWN, "time( \"14:32:55.125-05:00\" )", OffsetTime.of(14, 32, 55, 125000000, ZoneOffset.ofHours(-5))}, {BuiltInType.UNKNOWN, "time( \"14:32:55.125Z\" )", OffsetTime.of(14, 32, 55, 125000000, ZoneOffset.UTC)}, {BuiltInType.UNKNOWN, "date and time( \"2017-06-30T10:49:11\" )", LocalDateTime.of(2017, 6, 30, 10, 49, 11)}, {BuiltInType.UNKNOWN, "date and time( \"2017-06-30T10:49:11.650\" )", LocalDateTime.of(2017, 6, 30, 10, 49, 11, 650000000)}, {BuiltInType.UNKNOWN, "date and time( \"2017-06-30T10:49:11.650+03:00\" )", ZonedDateTime.of(2017, 6, 30, 10, 49, 11, 650000000, ZoneOffset.ofHours(3))}, {BuiltInType.UNKNOWN, "duration( \"P5DT4H23M55S\" )", Duration.ofDays(5L).plusHours(4L).plusMinutes(23L).plusSeconds(55L)}, {BuiltInType.UNKNOWN, "duration( \"-P5DT4H23M55S\" )", Duration.ofDays(-5L).minusHours(4L).minusMinutes(23L).minusSeconds(55L)}, {BuiltInType.UNKNOWN, "duration( \"P23D\" )", Duration.ofDays(23L)}, {BuiltInType.UNKNOWN, "duration( \"-P23D\" )", Duration.ofDays(-23L)}, {BuiltInType.UNKNOWN, "duration( \"PT23H\" )", Duration.ofHours(23L)}, {BuiltInType.UNKNOWN, "duration( \"-PT23H\" )", Duration.ofHours(-23L)}, {BuiltInType.UNKNOWN, "duration( \"PT23M\" )", Duration.ofMinutes(23L)}, {BuiltInType.UNKNOWN, "duration( \"-PT23M\" )", Duration.ofMinutes(-23L)}, {BuiltInType.UNKNOWN, "duration( \"PT23S\" )", Duration.ofSeconds(23L)}, {BuiltInType.UNKNOWN, "duration( \"-PT23S\" )", Duration.ofSeconds(-23L)}, {BuiltInType.UNKNOWN, "duration( \"PT0S\" )", Duration.ofDays(0L)}, {BuiltInType.UNKNOWN, "duration( \"P5DT4H\" )", Duration.ofHours(124L)}, {BuiltInType.UNKNOWN, "duration( \"P737DT20H8M3S\" )", Duration.ofSeconds(63749283L)}, {BuiltInType.UNKNOWN, "duration( \"P4Y5M\" )", Period.of(4, 5, 0)}, {BuiltInType.UNKNOWN, "duration( \"P6Y1M\" )", Period.of(6, 1, 0)}, {BuiltInType.UNKNOWN, "duration( \"-P6Y1M\" )", Period.of(-6, -1, 0)}, {BuiltInType.UNKNOWN, "duration( \"P0M\" )", Period.of(0, 0, 0)}, {BuiltInType.UNKNOWN, "[ 1, 2, 3, 4 ]", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L))}, {BuiltInType.UNKNOWN, "[ \"foo\", \"bar\", \"baz\" ]", Arrays.asList("foo", "bar", "baz")}, {BuiltInType.UNKNOWN, "[ duration( \"P4D\" ), duration( \"P2D\" ), duration( \"P1DT1H\" ) ]", Arrays.asList(Duration.ofDays(4L), Duration.ofDays(2L), Duration.ofHours(25L))}, {BuiltInType.UNKNOWN, "[ [ 1, 2 ], [ 3, 4 ] ]", Arrays.asList(Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L)), Arrays.asList(BigDecimal.valueOf(3L), BigDecimal.valueOf(4L)))}, {BuiltInType.UNKNOWN, "[ \"a\" .. \"z\" )", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"z"), Range.RangeBoundary.OPEN)}, {BuiltInType.UNKNOWN, "[ duration( \"P1DT6H\" ) .. duration( \"P2DT2H\" ) )", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Duration.ofHours(30L), (Comparable)Duration.ofHours(50L), Range.RangeBoundary.OPEN)}, {BuiltInType.UNKNOWN, "{ Full Name : \"John Doe\", Age : 35, Date of Birth : date( \"1982-06-09\" ) }", new LinkedHashMap(){
            {
                this.put("Full Name", "John Doe");
                this.put("Age", BigDecimal.valueOf(35L));
                this.put("Date of Birth", LocalDate.of(1982, 6, 9));
            }
        }}, {BuiltInType.UNKNOWN, "null", null}};
        return Arrays.asList(cases);
    }

    @Test
    public void testExpression() {
        this.assertResult(this.feelType, this.value, this.result);
    }

    protected void assertResult(Type feelType, String value, Object result) {
        if (result == null) {
            Assert.assertThat((String)("Unmarshalling: '" + value + "'"), (Object)FEELCodeMarshaller.INSTANCE.unmarshall(feelType, value), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        } else {
            Assert.assertThat((String)("Unmarshalling: '" + value + "'"), (Object)FEELCodeMarshaller.INSTANCE.unmarshall(feelType, value), (Matcher)Matchers.is((Object)result));
        }
    }
}

