/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime;

import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.ast.InfixOpNode;
import org.kie.dmn.feel.util.EvalHelper;

public class FEELNumberCoercionTest {
    private final FEEL feel = FEEL.newInstance();

    private Object evaluateInfix(Object x, InfixOpNode.InfixOperator op, Object y) {
        HashMap<String, Object> inputVariables = new HashMap<String, Object>();
        inputVariables.put("x", x);
        inputVariables.put("y", y);
        String expression = "x " + op.symbol + " y";
        System.out.println(expression);
        return this.feel.evaluate(expression, inputVariables);
    }

    @Test
    public void test() {
        Assert.assertThat((Object)this.evaluateInfix(1, InfixOpNode.InfixOperator.LT, 2.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.evaluateInfix(2.0, InfixOpNode.InfixOperator.LT, 1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.evaluateInfix(1, InfixOpNode.InfixOperator.LTE, 2.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.evaluateInfix(2.0, InfixOpNode.InfixOperator.LTE, 1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.evaluateInfix(1, InfixOpNode.InfixOperator.GT, 2.0), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.evaluateInfix(2.0, InfixOpNode.InfixOperator.GT, 1), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.evaluateInfix(1, InfixOpNode.InfixOperator.GTE, 2.0), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.evaluateInfix(2.0, InfixOpNode.InfixOperator.GTE, 1), (Matcher)CoreMatchers.is((Object)true));
    }

    @SafeVarargs
    private final Object evaluate(String expression, Map.Entry<String, ?> ... vars) {
        HashMap inputVariables = new HashMap();
        for (Map.Entry<String, ?> v : vars) {
            inputVariables.put(v.getKey(), v.getValue());
        }
        return this.feel.evaluate(expression, inputVariables);
    }

    private static Map.Entry<String, Object> var(String name, Object value) {
        return new AbstractMap.SimpleEntry<String, Object>(name, value);
    }

    @Test
    public void testOthers() {
        Assert.assertThat((Object)this.evaluate("ceiling( 1.01 )", new Map.Entry[0]), (Matcher)CoreMatchers.is((Object)EvalHelper.getBigDecimalOrNull((Object)2.0)));
        Assert.assertThat((Object)this.evaluate("ceiling( x )", FEELNumberCoercionTest.var("x", 1.01)), (Matcher)CoreMatchers.is((Object)EvalHelper.getBigDecimalOrNull((Object)2.0)));
        Assert.assertThat(((Map)this.evaluate("{ myf : function( v1, v2 ) ceiling(v1), invoked: myf(v2: false, v1: x) }", FEELNumberCoercionTest.var("x", 1.01))).get("invoked"), (Matcher)CoreMatchers.is((Object)EvalHelper.getBigDecimalOrNull((Object)2.0)));
        Assert.assertThat(((Map)this.evaluate("{ myf : function( v1, v2 ) v1, invoked: myf(v2: false, v1: x) }", FEELNumberCoercionTest.var("x", 1.01))).get("invoked"), (Matcher)CoreMatchers.is((Object)EvalHelper.getBigDecimalOrNull((Object)1.01)));
        Assert.assertThat((Object)this.evaluate(" x.y ", FEELNumberCoercionTest.var("x", new HashMap(){
            {
                this.put("y", 1.01);
            }
        })), (Matcher)CoreMatchers.is((Object)EvalHelper.getBigDecimalOrNull((Object)1.01)));
        Assert.assertThat((Object)this.evaluate("ceiling( x.y )", FEELNumberCoercionTest.var("x", new HashMap(){
            {
                this.put("y", 1.01);
            }
        })), (Matcher)CoreMatchers.is((Object)EvalHelper.getBigDecimalOrNull((Object)2.0)));
    }

    @Test
    public void testMethodGetBigDecimalOrNull() {
        Assert.assertThat((Object)EvalHelper.getBigDecimalOrNull((Object)1), (Matcher)CoreMatchers.is((Object)BigDecimal.ONE));
        Assert.assertThat((Object)EvalHelper.getBigDecimalOrNull((Object)1), (Matcher)CoreMatchers.is((Object)BigDecimal.ONE));
        Assert.assertThat((Object)EvalHelper.getBigDecimalOrNull((Object)1), (Matcher)CoreMatchers.is((Object)BigDecimal.ONE));
        Assert.assertThat((Object)EvalHelper.getBigDecimalOrNull((Object)1L), (Matcher)CoreMatchers.is((Object)BigDecimal.ONE));
        Assert.assertThat((Object)EvalHelper.getBigDecimalOrNull((Object)Float.valueOf(1.0f)), (Matcher)CoreMatchers.is((Object)BigDecimal.ONE));
        Assert.assertThat((Object)EvalHelper.getBigDecimalOrNull((Object)Float.valueOf(1.1f)), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(1.1)));
        Assert.assertThat((Object)EvalHelper.getBigDecimalOrNull((Object)1.0), (Matcher)CoreMatchers.is((Object)BigDecimal.ONE));
        Assert.assertThat((Object)EvalHelper.getBigDecimalOrNull((Object)1.1), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(1.1)));
        Assert.assertThat((Object)EvalHelper.getBigDecimalOrNull((Object)"1"), (Matcher)CoreMatchers.is((Object)BigDecimal.ONE));
        Assert.assertThat((Object)EvalHelper.getBigDecimalOrNull((Object)"1.1"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(1.1)));
        Assert.assertThat((Object)EvalHelper.getBigDecimalOrNull((Object)"1.1000000"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(1.1).setScale(7, 6)));
        Assert.assertThat((Object)EvalHelper.getBigDecimalOrNull((Object)Double.POSITIVE_INFINITY), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)EvalHelper.getBigDecimalOrNull((Object)Double.NEGATIVE_INFINITY), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)EvalHelper.getBigDecimalOrNull((Object)Double.NaN), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

