/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.CompositeType;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.NameRefNode;
import org.kie.dmn.feel.lang.ast.QualifiedNameNode;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.util.EvalHelper;
import org.kie.dmn.feel.util.Msg;

public class PathExpressionNode
extends BaseNode {
    private BaseNode expression;
    private BaseNode name;

    public PathExpressionNode(ParserRuleContext ctx, BaseNode expression, BaseNode name) {
        super(ctx);
        this.expression = expression;
        this.name = name;
    }

    public BaseNode getExpression() {
        return this.expression;
    }

    public void setExpression(BaseNode expression) {
        this.expression = expression;
    }

    public BaseNode getName() {
        return this.name;
    }

    public void setName(BaseNode name) {
        this.name = name;
    }

    @Override
    public Object evaluate(EvaluationContext ctx) {
        try {
            Object o = this.expression.evaluate(ctx);
            if (o instanceof List) {
                List list = (List)o;
                ArrayList<Object> results = new ArrayList<Object>();
                for (Object element : list) {
                    Object r = this.fetchValue(element);
                    if (r == null) continue;
                    results.add(r);
                }
                return results;
            }
            return this.fetchValue(o);
        }
        catch (Exception e) {
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.ERROR_EVALUATING_PATH_EXPRESSION, this.expression.getText(), this.name.getText()), e));
            return null;
        }
    }

    private Object fetchValue(Object o) throws IllegalAccessException, InvocationTargetException {
        if (this.name instanceof NameRefNode) {
            o = EvalHelper.getValue(o, this.name.getText());
        } else if (this.name instanceof QualifiedNameNode) {
            for (NameRefNode nr : ((QualifiedNameNode)this.name).getParts()) {
                o = EvalHelper.getValue(o, nr.getText());
            }
        }
        return o;
    }

    @Override
    public Type getResultType() {
        return PathExpressionNode.findType(this.expression.getResultType(), this.name);
    }

    private static Type findType(Type startType, BaseNode accessor) {
        if (!(startType instanceof CompositeType)) {
            return BuiltInType.UNKNOWN;
        }
        CompositeType compositeType = (CompositeType)startType;
        if (accessor instanceof NameRefNode) {
            NameRefNode nameRefNode = (NameRefNode)accessor;
            return compositeType.getFields().getOrDefault(nameRefNode.getText(), BuiltInType.UNKNOWN);
        }
        if (accessor instanceof QualifiedNameNode) {
            QualifiedNameNode qualifiedNameNode = (QualifiedNameNode)accessor;
            Type typeCursor = startType;
            for (NameRefNode part : qualifiedNameNode.getParts()) {
                typeCursor = PathExpressionNode.findType(typeCursor, part);
            }
            return typeCursor;
        }
        return BuiltInType.UNKNOWN;
    }
}

