/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.DateFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;
import org.kie.dmn.feel.runtime.functions.TimeFunction;

public class DateAndTimeFunction
extends BaseFEELFunction {
    public static final DateTimeFormatter FEEL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateFunction.FEEL_DATE).appendLiteral('T').append(TimeFunction.FEEL_TIME).toFormatter();
    public static final DateTimeFormatter REGION_DATETIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateFunction.FEEL_DATE).appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).appendLiteral("@").appendZoneRegionId().toFormatter();

    public DateAndTimeFunction() {
        super("date and time");
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="from") String val) {
        if (val == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "cannot be null"));
        }
        if (!DateFunction.BEGIN_YEAR.matcher(val).find()) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "year not compliant with XML Schema Part 2 Datatypes"));
        }
        try {
            if (val.contains("T")) {
                return FEELFnResult.ofResult(FEEL_DATE_TIME.parseBest(val, ZonedDateTime::from, OffsetDateTime::from, LocalDateTime::from));
            }
            TemporalAccessor value = DateTimeFormatter.ISO_DATE.parse((CharSequence)val, LocalDate::from);
            return FEELFnResult.ofResult(LocalDateTime.of((LocalDate)value, LocalTime.of(0, 0)));
        }
        catch (Exception e) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "date-parsing exception", e));
        }
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="date") TemporalAccessor date, @ParameterName(value="time") TemporalAccessor time) {
        if (date == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "date", "cannot be null"));
        }
        if (!(date instanceof LocalDate) && (date = (TemporalAccessor)date.query(TemporalQueries.localDate())) == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "date", "must be an instance of LocalDate (or must be possible to convert to a FEEL date using built-in date(date) )"));
        }
        if (time == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "time", "cannot be null"));
        }
        if (!(time instanceof LocalTime || time.query(TemporalQueries.localTime()) != null && time.query(TemporalQueries.zone()) != null)) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "time", "must be an instance of LocalTime or (it must contain localTime AND zone)"));
        }
        try {
            if (date instanceof LocalDate && time instanceof LocalTime) {
                return FEELFnResult.ofResult(LocalDateTime.of((LocalDate)date, (LocalTime)time));
            }
            if (date instanceof LocalDate && time.query(TemporalQueries.localTime()) != null && time.query(TemporalQueries.zone()) != null) {
                return FEELFnResult.ofResult(ZonedDateTime.of((LocalDate)date, LocalTime.from(time), ZoneId.from(time)));
            }
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "cannot invoke function for the input parameters"));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "input parameters date-parsing exception", e));
        }
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="year") Number year, @ParameterName(value="month") Number month, @ParameterName(value="day") Number day, @ParameterName(value="hour") Number hour, @ParameterName(value="minute") Number minute, @ParameterName(value="second") Number second) {
        return this.invoke(year, month, day, hour, minute, second, null);
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="year") Number year, @ParameterName(value="month") Number month, @ParameterName(value="day") Number day, @ParameterName(value="hour") Number hour, @ParameterName(value="minute") Number minute, @ParameterName(value="second") Number second, @ParameterName(value="hour offset") Number hourOffset) {
        if (year == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "year", "cannot be null"));
        }
        if (month == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "month", "cannot be null"));
        }
        if (day == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "day", "cannot be null"));
        }
        if (hour == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "hour", "cannot be null"));
        }
        if (minute == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "minute", "cannot be null"));
        }
        if (second == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "second", "cannot be null"));
        }
        try {
            if (hourOffset != null) {
                return FEELFnResult.ofResult(ZonedDateTime.of(year.intValue(), month.intValue(), day.intValue(), hour.intValue(), minute.intValue(), second.intValue(), 0, ZoneOffset.ofHours(hourOffset.intValue())));
            }
            return FEELFnResult.ofResult(LocalDateTime.of(year.intValue(), month.intValue(), day.intValue(), hour.intValue(), minute.intValue(), second.intValue()));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "input parameters date-parsing exception", e));
        }
    }
}

