/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class MaxFunction
extends BaseFEELFunction {
    public MaxFunction() {
        super("max");
    }

    public FEELFnResult<Object> invoke(@ParameterName(value="list") List list) {
        if (list == null || list.isEmpty()) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "cannot be null or empty"));
        }
        try {
            return FEELFnResult.ofResult(Collections.max(list));
        }
        catch (ClassCastException e) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "contains items that are not comparable"));
        }
    }

    public FEELFnResult<Object> invoke(@ParameterName(value="c") Object[] list) {
        if (list == null || list.length == 0) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "c", "cannot be null or empty"));
        }
        return this.invoke(Arrays.asList(list));
    }
}

