/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.FEELProperty;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.util.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalHelper {
    public static final Logger LOG = LoggerFactory.getLogger(EvalHelper.class);
    private static final Pattern SPACES_PATTERN = Pattern.compile("[\\s\u00a0]+");

    public static String normalizeVariableName(String name) {
        return SPACES_PATTERN.matcher(name.trim()).replaceAll(" ");
    }

    public static BigDecimal getBigDecimalOrNull(Object value) {
        if (!(value instanceof Number) && !(value instanceof String) || value instanceof Double && (value.toString().equals("NaN") || value.toString().equals("Infinity") || value.toString().equals("-Infinity"))) {
            return null;
        }
        if (!BigDecimal.class.isAssignableFrom(value.getClass())) {
            value = value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof AtomicLong || value instanceof AtomicInteger ? new BigDecimal(((Number)value).longValue(), MathContext.DECIMAL128) : (value instanceof BigInteger ? new BigDecimal((BigInteger)value, MathContext.DECIMAL128) : (value instanceof String ? new BigDecimal(((String)value).replaceFirst("^0+(?!$)", ""), MathContext.DECIMAL128) : new BigDecimal(EvalHelper.removeTrailingZeros(value.toString()), MathContext.DECIMAL128)));
        }
        return (BigDecimal)value;
    }

    public static Object coerceNumber(Object value) {
        if (value instanceof Number && !(value instanceof BigDecimal)) {
            return EvalHelper.getBigDecimalOrNull(value);
        }
        return value;
    }

    public static Boolean getBooleanOrNull(Object value) {
        if (value == null || !(value instanceof Boolean)) {
            return null;
        }
        return (Boolean)value;
    }

    public static String unescapeString(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() >= 2 && text.startsWith("\"") && text.endsWith("\"")) {
            text = text.substring(1, text.length() - 1);
        }
        if (text.indexOf(92) >= 0) {
            StringBuilder r = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\\') {
                    if (text.length() > i + 1) {
                        char cn = text.charAt(++i);
                        switch (cn) {
                            case 'b': {
                                r.append('\b');
                                break;
                            }
                            case 't': {
                                r.append('\t');
                                break;
                            }
                            case 'n': {
                                r.append('\n');
                                break;
                            }
                            case 'f': {
                                r.append('\f');
                                break;
                            }
                            case 'r': {
                                r.append('\r');
                                break;
                            }
                            case '\"': {
                                r.append('\"');
                                break;
                            }
                            case '\'': {
                                r.append('\'');
                                break;
                            }
                            case '\\': {
                                r.append('\\');
                                break;
                            }
                            case 'u': {
                                if (text.length() >= i + 5) {
                                    String hex = text.substring(i + 1, i + 5);
                                    char[] chars = Character.toChars(Integer.parseInt(hex, 16));
                                    r.append(chars);
                                    i += 4;
                                    break;
                                }
                                r.append("\\").append(cn);
                                break;
                            }
                            default: {
                                r.append("\\").append(cn);
                                break;
                            }
                        }
                        continue;
                    }
                    r.append(c);
                    continue;
                }
                r.append(c);
            }
            text = r.toString();
        }
        return text;
    }

    public static PropertyValueResult getDefinedValue(Object current, String property) {
        Object result;
        if (current == null) {
            return PropertyValueResult.notDefined();
        }
        if (current instanceof Map) {
            result = ((Map)current).get(property);
            if (result == null && !((Map)current).containsKey(property)) {
                return PropertyValueResult.notDefined();
            }
        } else if (current instanceof Period) {
            switch (property) {
                case "years": {
                    result = ((Period)current).getYears();
                    break;
                }
                case "months": {
                    result = ((Period)current).getMonths() % 12;
                    break;
                }
                case "days": {
                    result = ((Period)current).getDays() % 30;
                    break;
                }
                default: {
                    return PropertyValueResult.notDefined();
                }
            }
        } else if (current instanceof Duration) {
            switch (property) {
                case "days": {
                    result = ((Duration)current).toDays();
                    break;
                }
                case "hours": {
                    result = ((Duration)current).toHours() % 24L;
                    break;
                }
                case "minutes": {
                    result = ((Duration)current).toMinutes() % 60L;
                    break;
                }
                case "seconds": {
                    result = ((Duration)current).getSeconds() % 60L;
                    break;
                }
                default: {
                    return PropertyValueResult.notDefined();
                }
            }
        } else if (current instanceof Temporal) {
            switch (property) {
                case "year": {
                    result = ((Temporal)current).get(ChronoField.YEAR);
                    break;
                }
                case "month": {
                    result = ((Temporal)current).get(ChronoField.MONTH_OF_YEAR);
                    break;
                }
                case "day": {
                    result = ((Temporal)current).get(ChronoField.DAY_OF_MONTH);
                    break;
                }
                case "hour": {
                    result = ((Temporal)current).get(ChronoField.HOUR_OF_DAY);
                    break;
                }
                case "minute": {
                    result = ((Temporal)current).get(ChronoField.MINUTE_OF_HOUR);
                    break;
                }
                case "second": {
                    result = ((Temporal)current).get(ChronoField.SECOND_OF_MINUTE);
                    break;
                }
                case "time offset": 
                case "timezone": {
                    result = Duration.ofSeconds(((Temporal)current).get(ChronoField.OFFSET_SECONDS));
                    break;
                }
                case "weekday": {
                    result = ((Temporal)current).get(ChronoField.DAY_OF_WEEK);
                    break;
                }
                default: {
                    return PropertyValueResult.notDefined();
                }
            }
        } else {
            Method getter = EvalHelper.getGenericAccessor(current.getClass(), property);
            if (getter != null) {
                try {
                    result = getter.invoke(current, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                    return PropertyValueResult.of(Either.ofLeft(e));
                }
            } else {
                return PropertyValueResult.notDefined();
            }
        }
        result = EvalHelper.coerceNumber(result);
        return PropertyValueResult.ofValue(result);
    }

    public static Object getValue(Object current, String property) {
        return EvalHelper.getDefinedValue(current, property).getValueResult().getOrElse(null);
    }

    public static Method getGenericAccessor(Class<?> clazz, String field) {
        LOG.trace("getGenericAccessor({}, {})", clazz, (Object)field);
        return Stream.of(clazz.getMethods()).filter(m -> Optional.ofNullable(m.getAnnotation(FEELProperty.class)).map(ann -> ann.value().equals(field)).orElse(false)).findFirst().orElse(EvalHelper.getAccessor(clazz, field));
    }

    public static Method getAccessor(Class<?> clazz, String field) {
        LOG.trace("getAccessor({}, {})", clazz, (Object)field);
        try {
            return clazz.getMethod("get" + EvalHelper.ucFirst(field), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getMethod(field, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                try {
                    return clazz.getMethod("is" + EvalHelper.ucFirst(field), new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    return null;
                }
            }
        }
    }

    public static Optional<String> propertyFromAccessor(Method accessor) {
        if (accessor.getParameterCount() != 0 || accessor.getReturnType().equals(Void.class)) {
            return Optional.empty();
        }
        String methodName = accessor.getName();
        if (methodName.startsWith("get")) {
            return Optional.of(EvalHelper.lcFirst(methodName.substring(3, methodName.length())));
        }
        if (methodName.startsWith("is")) {
            return Optional.of(EvalHelper.lcFirst(methodName.substring(2, methodName.length())));
        }
        return Optional.of(EvalHelper.lcFirst(methodName));
    }

    public static String ucFirst(String name) {
        return name.toUpperCase().charAt(0) + name.substring(1);
    }

    public static String lcFirst(String name) {
        return name.toLowerCase().charAt(0) + name.substring(1);
    }

    public static Boolean compare(Object left, Object right, EvaluationContext ctx, BiPredicate<Comparable, Comparable> op) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Period && right instanceof Period) {
            Period lp = (Period)left;
            Period rp = (Period)right;
            Integer l = lp.getYears() * 12 + lp.getMonths();
            Integer r = rp.getYears() * 12 + rp.getMonths();
            return op.test(l, r);
        }
        if (left instanceof String && right instanceof String || left instanceof Number && right instanceof Number || left instanceof Boolean && right instanceof Boolean || left instanceof Comparable && left.getClass().isAssignableFrom(right.getClass())) {
            Comparable l = (Comparable)left;
            Comparable r = (Comparable)right;
            return op.test(l, r);
        }
        return null;
    }

    public static Boolean isEqual(Object left, Object right, EvaluationContext ctx) {
        if (left == null || right == null) {
            return left == right;
        }
        if (left instanceof Collection && !(right instanceof Collection) && ((Collection)left).size() == 1) {
            left = ((Collection)left).toArray()[0];
        } else if (right instanceof Collection && !(left instanceof Collection) && ((Collection)right).size() == 1) {
            right = ((Collection)right).toArray()[0];
        }
        if (left instanceof Range && right instanceof Range) {
            return EvalHelper.isEqual((Range)left, (Range)right);
        }
        if (left instanceof Iterable && right instanceof Iterable) {
            return EvalHelper.isEqual((Iterable)left, (Iterable)right);
        }
        if (left instanceof Map && right instanceof Map) {
            return EvalHelper.isEqual((Map)left, (Map)right);
        }
        return EvalHelper.compare(left, right, ctx, (l, r) -> l.compareTo(r) == 0);
    }

    private static Boolean isEqual(Range left, Range right) {
        return left.equals(right);
    }

    private static Boolean isEqual(Iterable left, Iterable right) {
        Iterator li = left.iterator();
        Iterator ri = right.iterator();
        while (li.hasNext() && ri.hasNext()) {
            Object r;
            Object l = li.next();
            if (EvalHelper.isEqual(l, r = ri.next()).booleanValue()) continue;
            return false;
        }
        return li.hasNext() == ri.hasNext();
    }

    private static Boolean isEqual(Map<?, ?> left, Map<?, ?> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (Map.Entry<?, ?> le : left.entrySet()) {
            Object r;
            Object l = le.getValue();
            if (EvalHelper.isEqual(l, r = right.get(le.getKey())).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static Boolean isEqual(Object l, Object r) {
        if (l instanceof Iterable && r instanceof Iterable && !EvalHelper.isEqual((Iterable)l, (Iterable)r).booleanValue()) {
            return false;
        }
        if (l instanceof Map && r instanceof Map && !EvalHelper.isEqual((Map)l, (Map)r).booleanValue()) {
            return false;
        }
        if (l != null && r != null && !l.equals(r)) {
            return false;
        }
        if ((l == null || r == null) && l != r) {
            return false;
        }
        return true;
    }

    private static String removeTrailingZeros(String stringNumber) {
        String stringWithoutZeros = stringNumber.replaceAll("0*$", "");
        if (Character.isDigit(stringWithoutZeros.charAt(stringWithoutZeros.length() - 1))) {
            return stringWithoutZeros;
        }
        return stringWithoutZeros.substring(0, stringWithoutZeros.length() - 1);
    }

    public static class PropertyValueResult {
        private final boolean defined;
        private final Either<Exception, Object> valueResult;

        private PropertyValueResult(boolean isDefined, Either<Exception, Object> value) {
            this.defined = isDefined;
            this.valueResult = value;
        }

        public static PropertyValueResult notDefined() {
            return new PropertyValueResult(false, Either.ofLeft(new UnsupportedOperationException("Property was not defined.")));
        }

        public static PropertyValueResult of(Either<Exception, Object> valueResult) {
            return new PropertyValueResult(true, valueResult);
        }

        public static PropertyValueResult ofValue(Object value) {
            return new PropertyValueResult(true, Either.ofRight(value));
        }

        public boolean isDefined() {
            return this.defined;
        }

        public Either<Exception, Object> getValueResult() {
            return this.valueResult;
        }
    }
}

