/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.time.Period;
import java.time.chrono.ChronoPeriod;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.MaxFunction;

public class MaxFunctionTest {
    private MaxFunction maxFunction;

    @Before
    public void setUp() {
        this.maxFunction = new MaxFunction();
    }

    @Test
    public void invokeNullList() {
        FunctionTestUtil.assertResultError(this.maxFunction.invoke((List)null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeEmptyList() {
        FunctionTestUtil.assertResultError(this.maxFunction.invoke(Collections.emptyList()), InvalidParametersEvent.class);
    }

    @Test
    public void invokeListWithHeterogenousTypes() {
        FunctionTestUtil.assertResultError(this.maxFunction.invoke(Arrays.asList(1, "test", BigDecimal.valueOf(10.2))), InvalidParametersEvent.class);
    }

    @Test
    public void invokeListOfIntegers() {
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Collections.singletonList(1)), 1);
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Arrays.asList(1, 2, 3)), 3);
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Arrays.asList(1, 3, 2)), 3);
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Arrays.asList(3, 1, 2)), 3);
    }

    @Test
    public void invokeListOfStrings() {
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Collections.singletonList("a")), "a");
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Arrays.asList("a", "b", "c")), "c");
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Arrays.asList("a", "c", "b")), "c");
        FunctionTestUtil.assertResult(this.maxFunction.invoke(Arrays.asList("c", "a", "b")), "c");
    }

    @Test
    public void invokeListOfChronoPeriods() {
        Period p1Period = Period.parse("P1Y");
        ComparablePeriod p1Comparable = ComparablePeriod.parse((CharSequence)"P1Y");
        Period p2Period = Period.parse("P1M");
        ComparablePeriod p2Comparable = ComparablePeriod.parse((CharSequence)"P1M");
        Predicate<ChronoPeriod> assertion = i -> i.get(ChronoUnit.YEARS) == 1L && i.get(ChronoUnit.MONTHS) == 0L;
        FunctionTestUtil.assertPredicateOnResult(this.maxFunction.invoke(Collections.singletonList(p1Period)), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.maxFunction.invoke(Collections.singletonList(p1Comparable)), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.maxFunction.invoke(Arrays.asList(p1Period, p2Period)), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.maxFunction.invoke(Arrays.asList(p1Comparable, p2Period)), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.maxFunction.invoke(Arrays.asList(p1Period, p2Comparable)), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.maxFunction.invoke(Arrays.asList(p1Comparable, p2Comparable)), ChronoPeriod.class, assertion);
    }

    @Test
    public void invokeNullArray() {
        FunctionTestUtil.assertResultError(this.maxFunction.invoke((Object[])null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeEmptyArray() {
        FunctionTestUtil.assertResultError(this.maxFunction.invoke(new Object[0]), InvalidParametersEvent.class);
    }

    @Test
    public void invokeArrayWithHeterogenousTypes() {
        FunctionTestUtil.assertResultError(this.maxFunction.invoke(new Object[]{1, "test", BigDecimal.valueOf(10.2)}), InvalidParametersEvent.class);
    }

    @Test
    public void invokeArrayOfIntegers() {
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[]{1}), 1);
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[]{1, 2, 3}), 3);
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[]{1, 3, 2}), 3);
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[]{3, 1, 2}), 3);
    }

    @Test
    public void invokeArrayOfStrings() {
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[]{"a"}), "a");
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[]{"a", "b", "c"}), "c");
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[]{"a", "c", "b"}), "c");
        FunctionTestUtil.assertResult(this.maxFunction.invoke(new Object[]{"c", "a", "b"}), "c");
    }

    @Test
    public void invokeArrayOfChronoPeriods() {
        Period p1Period = Period.parse("P1Y");
        ComparablePeriod p1Comparable = ComparablePeriod.parse((CharSequence)"P1Y");
        Period p2Period = Period.parse("P1M");
        ComparablePeriod p2Comparable = ComparablePeriod.parse((CharSequence)"P1M");
        Predicate<ChronoPeriod> assertion = i -> i.get(ChronoUnit.YEARS) == 1L && i.get(ChronoUnit.MONTHS) == 0L;
        FunctionTestUtil.assertPredicateOnResult(this.maxFunction.invoke(new Object[]{p1Period}), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.maxFunction.invoke(new Object[]{p1Comparable}), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.maxFunction.invoke(new Object[]{p1Period, p2Period}), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.maxFunction.invoke(new Object[]{p1Comparable, p2Period}), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.maxFunction.invoke(new Object[]{p1Period, p2Comparable}), ChronoPeriod.class, assertion);
        FunctionTestUtil.assertPredicateOnResult(this.maxFunction.invoke(new Object[]{p1Comparable, p2Comparable}), ChronoPeriod.class, assertion);
    }
}

