/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.impl;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

public class RangeImplTest {
    @Test
    public void getLowBoundary() {
        Range.RangeBoundary lowBoundary = Range.RangeBoundary.CLOSED;
        RangeImpl rangeImpl = new RangeImpl(lowBoundary, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assertions.assertThat((Comparable)rangeImpl.getLowBoundary()).isEqualTo((Object)lowBoundary);
    }

    @Test
    public void getLowEndPoint() {
        Integer lowEndPoint = 1;
        RangeImpl rangeImpl = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)lowEndPoint, (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assertions.assertThat((Comparable)rangeImpl.getLowEndPoint()).isEqualTo((Object)lowEndPoint);
    }

    @Test
    public void getHighEndPoint() {
        Integer highEndPoint = 15;
        RangeImpl rangeImpl = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(1), (Comparable)highEndPoint, Range.RangeBoundary.CLOSED);
        Assertions.assertThat((Comparable)rangeImpl.getHighEndPoint()).isEqualTo((Object)highEndPoint);
    }

    @Test
    public void getHighBoundary() {
        Range.RangeBoundary highBoundary = Range.RangeBoundary.CLOSED;
        RangeImpl rangeImpl = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), highBoundary);
        Assertions.assertThat((Comparable)rangeImpl.getHighBoundary()).isEqualTo((Object)highBoundary);
    }

    @Test
    public void includes() {
        RangeImpl rangeImpl = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assertions.assertThat((Boolean)rangeImpl.includes((Object)-15)).isFalse();
        Assertions.assertThat((Boolean)rangeImpl.includes((Object)5)).isFalse();
        Assertions.assertThat((Boolean)rangeImpl.includes((Object)10)).isFalse();
        Assertions.assertThat((Boolean)rangeImpl.includes((Object)12)).isTrue();
        Assertions.assertThat((Boolean)rangeImpl.includes((Object)15)).isFalse();
        Assertions.assertThat((Boolean)rangeImpl.includes((Object)156)).isFalse();
        rangeImpl = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assertions.assertThat((Boolean)rangeImpl.includes((Object)10)).isTrue();
        Assertions.assertThat((Boolean)rangeImpl.includes((Object)12)).isTrue();
        Assertions.assertThat((Boolean)rangeImpl.includes((Object)15)).isFalse();
        rangeImpl = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assertions.assertThat((Boolean)rangeImpl.includes((Object)10)).isFalse();
        Assertions.assertThat((Boolean)rangeImpl.includes((Object)12)).isTrue();
        Assertions.assertThat((Boolean)rangeImpl.includes((Object)15)).isTrue();
        rangeImpl = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assertions.assertThat((Boolean)rangeImpl.includes((Object)10)).isTrue();
        Assertions.assertThat((Boolean)rangeImpl.includes((Object)12)).isTrue();
        Assertions.assertThat((Boolean)rangeImpl.includes((Object)15)).isTrue();
    }

    @Test
    public void equals() {
        RangeImpl rangeImpl = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assertions.assertThat((Object)rangeImpl).isEqualTo((Object)rangeImpl);
        RangeImpl rangeImpl2 = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assertions.assertThat((Object)rangeImpl2).isEqualTo((Object)rangeImpl);
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assertions.assertThat((Object)rangeImpl2).isNotEqualTo((Object)rangeImpl);
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assertions.assertThat((Object)rangeImpl2).isNotEqualTo((Object)rangeImpl);
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assertions.assertThat((Object)rangeImpl2).isNotEqualTo((Object)rangeImpl);
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assertions.assertThat((Object)rangeImpl2).isNotEqualTo((Object)rangeImpl);
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(17), Range.RangeBoundary.CLOSED);
        Assertions.assertThat((Object)rangeImpl2).isNotEqualTo((Object)rangeImpl);
        rangeImpl = new RangeImpl();
        Assertions.assertThat((Object)rangeImpl).isEqualTo((Object)rangeImpl);
    }

    @Test
    public void hashCodeTest() {
        RangeImpl rangeImpl = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assertions.assertThat((int)rangeImpl.hashCode()).isEqualTo(rangeImpl.hashCode());
        RangeImpl rangeImpl2 = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assertions.assertThat((int)rangeImpl2.hashCode()).isEqualTo(rangeImpl.hashCode());
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assertions.assertThat((int)rangeImpl2.hashCode()).isNotEqualTo(rangeImpl.hashCode());
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assertions.assertThat((int)rangeImpl2.hashCode()).isNotEqualTo(rangeImpl.hashCode());
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assertions.assertThat((int)rangeImpl2.hashCode()).isNotEqualTo(rangeImpl.hashCode());
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assertions.assertThat((int)rangeImpl2.hashCode()).isNotEqualTo(rangeImpl.hashCode());
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(17), Range.RangeBoundary.CLOSED);
        Assertions.assertThat((int)rangeImpl2.hashCode()).isNotEqualTo(rangeImpl.hashCode());
    }
}

