/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.examples;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.examples.SomeTestUtilClass;
import org.kie.dmn.feel.lang.impl.MapBackedType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.lang.types.GenListType;
import org.kie.dmn.feel.util.DynamicTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileEvaluateTest {
    private static final Logger LOG = LoggerFactory.getLogger(CompileEvaluateTest.class);
    private static final FEEL feel = FEEL.newInstance();
    private List<FEELEvent> errors;
    private FEELEventListener errorsCountingListener;

    @Before
    public void before() {
        this.errors = new ArrayList<FEELEvent>();
        this.errorsCountingListener = evt -> {
            if (evt.getSeverity() == FEELEvent.Severity.ERROR) {
                this.errors.add(evt);
            }
        };
        feel.addListener(this.errorsCountingListener);
    }

    @After
    public void after() {
        feel.removeListener(this.errorsCountingListener);
    }

    @Test
    public void test_isDynamicResolution() {
        CompilerContext ctx = feel.newCompilerContext();
        ctx.addInputVariableType("Person List", (Type)BuiltInType.LIST);
        CompiledExpression compiledExpression = feel.compile("Person List[My Variable 1 = \"A\"]", ctx);
        ((ListAssert)Assertions.assertThat(this.errors).as(this.errors.toString(), new Object[0])).hasSize(0);
        HashMap inputs = new HashMap();
        ArrayList pList = new ArrayList();
        inputs.put("Person List", pList);
        pList.add(DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Full Name", "Edson Tirelli"), DynamicTypeUtils.entry("My Variable 1", "A")));
        pList.add(DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Full Name", "Matteo Mortari"), DynamicTypeUtils.entry("My Variable 1", "B")));
        Object result = feel.evaluate(compiledExpression, inputs);
        Assertions.assertThat((Object)result).isInstanceOf(List.class);
        Assertions.assertThat((List)((List)result)).hasSize(1);
        Assertions.assertThat(((Map)((List)result).get(0)).get("Full Name")).isEqualTo((Object)"Edson Tirelli");
    }

    @Test
    public void test2() {
        CompilerContext ctx = feel.newCompilerContext();
        ctx.addInputVariableType("MyPerson", (Type)new MapBackedType().addField("FullName", (Type)BuiltInType.STRING));
        CompiledExpression compiledExpression = feel.compile("MyPerson.fullName", ctx);
        ((ListAssert)Assertions.assertThat(this.errors).as(this.errors.toString(), new Object[0])).hasSize(1);
        HashMap inputs = new HashMap();
        inputs.put("MyPerson", DynamicTypeUtils.prototype(DynamicTypeUtils.entry("FullName", "John Doe")));
        Object result = feel.evaluate(compiledExpression, inputs);
        Assertions.assertThat((Object)result).isNull();
    }

    @Test
    public void test2OK() {
        CompilerContext ctx = feel.newCompilerContext();
        ctx.addInputVariableType("MyPerson", (Type)new MapBackedType().addField("FullName", (Type)BuiltInType.STRING));
        CompiledExpression compiledExpression = feel.compile("MyPerson.FullName", ctx);
        HashMap inputs = new HashMap();
        inputs.put("MyPerson", DynamicTypeUtils.prototype(DynamicTypeUtils.entry("FullName", "John Doe")));
        Object result = feel.evaluate(compiledExpression, inputs);
        Assertions.assertThat((Object)result).isEqualTo((Object)"John Doe");
    }

    @Test
    public void testHyphenInProperty() {
        CompilerContext ctx = feel.newCompilerContext();
        ctx.addInputVariableType("input", (Type)new MapBackedType().addField("Primary-Key", (Type)BuiltInType.STRING).addField("Value", (Type)BuiltInType.STRING));
        CompiledExpression compiledExpression = feel.compile("input.Primary-Key", ctx);
        Assertions.assertThat(this.errors).isEmpty();
        HashMap inputs = new HashMap();
        inputs.put("input", DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Primary-Key", "k987")));
        Object result = feel.evaluate(compiledExpression, inputs);
        Assertions.assertThat((Object)result).isEqualTo((Object)"k987");
        Assertions.assertThat(this.errors).isEmpty();
    }

    @Test
    public void testHyphenInPropertyOfCollectionForProjection() {
        MapBackedType compositeType = new MapBackedType().addField("Primary-Key", (Type)BuiltInType.STRING).addField("Value", (Type)BuiltInType.STRING);
        CompilerContext ctx = feel.newCompilerContext();
        ctx.addInputVariableType("input", (Type)new GenListType((Type)compositeType));
        CompiledExpression compiledExpression = feel.compile("input.Primary-Key", ctx);
        Assertions.assertThat(this.errors).isEmpty();
        HashMap<String, List<Map>> inputs = new HashMap<String, List<Map>>();
        inputs.put("input", Arrays.asList(DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Primary-Key", "k987"))));
        Object result = feel.evaluate(compiledExpression, inputs);
        Assertions.assertThat((Object)result).asList().containsExactly(new Object[]{"k987"});
        Assertions.assertThat(this.errors).isEmpty();
    }

    @Test
    public void testHyphenInPropertyOfCollectionForAccessor() {
        MapBackedType compositeType = new MapBackedType().addField("Primary-Key", (Type)BuiltInType.STRING).addField("Value", (Type)BuiltInType.STRING);
        CompilerContext ctx = feel.newCompilerContext();
        ctx.addInputVariableType("my input", (Type)new GenListType((Type)compositeType));
        CompiledExpression compiledExpression = feel.compile("my input[1].Primary-Key", ctx);
        Assertions.assertThat(this.errors).isEmpty();
        HashMap<String, List<Map>> inputs = new HashMap<String, List<Map>>();
        inputs.put("my input", Arrays.asList(DynamicTypeUtils.prototype(DynamicTypeUtils.entry("Primary-Key", "k987"))));
        Object result = feel.evaluate(compiledExpression, inputs);
        Assertions.assertThat((Object)result).isEqualTo((Object)"k987");
        Assertions.assertThat(this.errors).isEmpty();
    }

    @Test
    public void testExternalFnMissingClass() {
        CompiledExpression compiledExpression = feel.compile("{ maximum : function( v1, v2 ) external { java : { class : \"java.lang.Meth\", method signature: \"max(long,long)\" } }, the max : maximum( 10, 20 ) }.the max", feel.newCompilerContext());
        Object result = feel.evaluate(compiledExpression, new HashMap());
        Assertions.assertThat(this.errors).anyMatch(fe -> fe.getMessage().contains("java.lang.Meth"));
    }

    @Test
    public void testExternalFnMissingMethod() {
        CompiledExpression compiledExpression = feel.compile("{ maximum : function( v1, v2 ) external { java : { class : \"" + Math.class.getCanonicalName() + "\", method signature: \"max(int,long)\" } }, the max : maximum( 10, 20 ) }.the max", feel.newCompilerContext());
        Object result = feel.evaluate(compiledExpression, new HashMap());
        Assertions.assertThat(this.errors).anyMatch(fe -> fe.getMessage().contains("max(int,int)") && fe.getMessage().contains("max(long,long)"));
    }

    @Test
    public void testExternalFnMissingMethodString() {
        CompiledExpression compiledExpression = feel.compile("{ fn : function( p1 ) external { java : { class : \"" + SomeTestUtilClass.class.getCanonicalName() + "\", method signature: \"greet(String)\" } }, r : fn( \"John Doe\" ) }.r", feel.newCompilerContext());
        Object result = feel.evaluate(compiledExpression, new HashMap());
        Assertions.assertThat(this.errors).anyMatch(fe -> fe.getMessage().contains("greet(java.lang.String)"));
    }

    static {
        feel.addListener(evt -> {
            if (evt.getSeverity() == FEELEvent.Severity.ERROR) {
                LOG.error("{}", (Object)evt);
                if (evt.getSourceException().getCause() != null) {
                    for (Throwable c = evt.getSourceException().getCause(); c != null; c = c.getCause()) {
                        LOG.error(" caused by: {} {}", c.getClass(), (Object)(c.getMessage() != null ? c.getMessage() : ""));
                    }
                    LOG.error(" [stacktraces omitted.]");
                }
            } else if (evt.getSeverity() == FEELEvent.Severity.WARN) {
                LOG.warn("{}", (Object)evt);
            }
        });
    }
}

