/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.codegen.feel11;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.drools.javaparser.ast.expr.Expression;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.feel.codegen.feel11.CodegenTestUtil;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELUnaryTests;
import org.kie.dmn.feel.codegen.feel11.CompilerBytecodeLoader;
import org.kie.dmn.feel.codegen.feel11.DirectCompilerResult;
import org.kie.dmn.feel.codegen.feel11.DirectCompilerVisitor;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.parser.feel11.FEELParser;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Parser;
import org.kie.dmn.feel.util.EvalHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectCompilerUnaryTestsTest {
    public static final Logger LOG = LoggerFactory.getLogger(DirectCompilerUnaryTestsTest.class);

    private List<Boolean> parseCompileEvaluate(String feelLiteralExpression, Object l) {
        Object left = EvalHelper.coerceNumber((Object)l);
        CompiledFEELUnaryTests compiledUnaryTests = this.parse(feelLiteralExpression);
        LOG.debug("{}", (Object)compiledUnaryTests);
        EvaluationContext emptyContext = CodegenTestUtil.newEmptyEvaluationContext();
        List<Boolean> result = compiledUnaryTests.getUnaryTests().stream().map(ut -> (Boolean)ut.apply((Object)emptyContext, left)).collect(Collectors.toList());
        LOG.debug("{}", result);
        return result;
    }

    @Test
    public void test_Dash() {
        Assert.assertThat(this.parseCompileEvaluate("-", 1), (Matcher)CoreMatchers.is(Arrays.asList(true)));
        Assert.assertThat(this.parseCompileEvaluate("-, -", 1), (Matcher)CoreMatchers.is(Arrays.asList(true, true)));
    }

    @Test
    public void test_positiveUnaryTestIneq() {
        Assert.assertThat(this.parseCompileEvaluate("<47", 1), (Matcher)CoreMatchers.is(Arrays.asList(true)));
        Assert.assertThat(this.parseCompileEvaluate("<47, <100", 1), (Matcher)CoreMatchers.is(Arrays.asList(true, true)));
        Assert.assertThat(this.parseCompileEvaluate("<47, <100, <-47", 1), (Matcher)CoreMatchers.is(Arrays.asList(true, true, false)));
        Assert.assertThat(this.parseCompileEvaluate(">=1, >2, <3, <=4", 0), (Matcher)CoreMatchers.is(Arrays.asList(false, false, true, true)));
        Assert.assertThat(this.parseCompileEvaluate(">=1, >2, <3, <=4", 1), (Matcher)CoreMatchers.is(Arrays.asList(true, false, true, true)));
        Assert.assertThat(this.parseCompileEvaluate(">=1, >2, <3, <=4", 2), (Matcher)CoreMatchers.is(Arrays.asList(true, false, true, true)));
        Assert.assertThat(this.parseCompileEvaluate(">=1, >2, <3, <=4", 3), (Matcher)CoreMatchers.is(Arrays.asList(true, true, false, true)));
        Assert.assertThat(this.parseCompileEvaluate(">=1, >2, <3, <=4", 4), (Matcher)CoreMatchers.is(Arrays.asList(true, true, false, true)));
        Assert.assertThat(this.parseCompileEvaluate(">=1, >2, <3, <=4", 5), (Matcher)CoreMatchers.is(Arrays.asList(true, true, false, false)));
        Assert.assertThat(this.parseCompileEvaluate("!=1, !=42", 1), (Matcher)CoreMatchers.is(Arrays.asList(false, true)));
    }

    @Test
    public void test_positiveUnaryTestIneq_forEQ() {
        Assert.assertThat(this.parseCompileEvaluate("<47, =1", 1), (Matcher)CoreMatchers.is(Arrays.asList(true, true)));
        Assert.assertThat(this.parseCompileEvaluate("<47, =47", 1), (Matcher)CoreMatchers.is(Arrays.asList(true, false)));
        Assert.assertThat(this.parseCompileEvaluate("<47, 1", 1), (Matcher)CoreMatchers.is(Arrays.asList(true, true)));
        Assert.assertThat(this.parseCompileEvaluate("<47, 47", 1), (Matcher)CoreMatchers.is(Arrays.asList(true, false)));
    }

    @Test
    public void test_not() {
        Assert.assertThat(this.parseCompileEvaluate("not(=47), not(<1), not(!=1)", 1), (Matcher)CoreMatchers.is(Arrays.asList(true, true, true)));
    }

    @Test
    public void test_simpleUnaryTest_forRANGE() {
        Assert.assertThat(this.parseCompileEvaluate("[1..2]", 1), (Matcher)CoreMatchers.is(Arrays.asList(true)));
        Assert.assertThat(this.parseCompileEvaluate("[1..2], [2..3]", 1), (Matcher)CoreMatchers.is(Arrays.asList(true, false)));
        Assert.assertThat(this.parseCompileEvaluate("(1..2], [2..3]", 1), (Matcher)CoreMatchers.is(Arrays.asList(false, false)));
        Assert.assertThat(this.parseCompileEvaluate("(1..2], [2..3]", 2), (Matcher)CoreMatchers.is(Arrays.asList(true, true)));
    }

    private CompiledFEELUnaryTests parse(String input) {
        return this.parse(input, Collections.emptyMap());
    }

    private CompiledFEELUnaryTests parse(String input, Map<String, Type> inputTypes) {
        FEEL_1_1Parser parser = FEELParser.parse(null, (String)input, inputTypes, Collections.emptyMap(), Collections.emptyList(), Collections.emptyList());
        FEEL_1_1Parser.ExpressionListContext tree = parser.expressionList();
        DirectCompilerVisitor v = new DirectCompilerVisitor(inputTypes, true);
        DirectCompilerResult directResult = (DirectCompilerResult)v.visit((ParseTree)tree);
        Expression expr = directResult.getExpression();
        CompiledFEELUnaryTests cu = new CompilerBytecodeLoader().makeFromJPUnaryTestsExpression(input, expr, directResult.getFieldDeclarations());
        return cu;
    }
}

