/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime;

import java.util.Arrays;
import java.util.Collection;
import org.junit.runners.Parameterized;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.BaseFEELTest;

public class FEELExpressionsTest
extends BaseFEELTest {
    @Parameterized.Parameters(name="{index}: {0} ({1}) = {2}")
    public static Collection<Object[]> data() {
        Object[][] cases = new Object[][]{{"some price in [ 80, 11, 110 ] satisfies price > 100", Boolean.TRUE, null}, {"some price in [ 80, 11, 90 ] satisfies price > 100", Boolean.FALSE, null}, {"some x in [ 5, 6, 7 ], y in [ 10, 11, 6 ] satisfies x > y", Boolean.TRUE, null}, {"every price in [ 80, 11, 90 ] satisfies price > 10", Boolean.TRUE, null}, {"every price in [ 80, 11, 90 ] satisfies price > 70", Boolean.FALSE, null}, {"some x in [ 5, 6, 7 ], y in [ 10, 11, 12 ] satisfies x < y", Boolean.TRUE, null}, {"some price in [ 80, 11, 110 ] satisfies price > max(100, 50, 10)", Boolean.TRUE, null}, {"{ full name: { first name: \"John\", last name: \"Doe\" } }.full name.last name", "Doe", null}, {"{ EmployeeTable : [ \n    { id : \"333\", dept : 1, name : \"Aaron\" },\n    { id : \"444\", dept : 1, name : \"Bob\" }, \n    { id : \"555\", dept : 2, name : \"Clark\" } ],\n  DeptTable : [ \n    { number : 1, name : \"Sales\", manager : \"Jack\" },\n    { number : 2, name : \"Engineering\", manager : \"Susie\" } ],\n  Dept : EmployeeTable[ name = \"Clark\" ].dept[1],\n  Manager : DeptTable[ number = Dept ].manager[1],\n  ManagerInline : DeptTable[ number = EmployeeTable[ name = \"Clark\" ].dept[1] ].manager[1]\n}.ManagerInline", "Susie", null}, {"{ is minor : function( foo, person's age ) foo = null and person's age < 18, bob is minor : is minor( person's age : 16 ) }.bob is minor", Boolean.TRUE, null}, {"{ is minor : < 18, bob is minor : is minor(16) }.bob is minor", Boolean.TRUE, null}, {"10 in ( not( <5, >=20, =15, !=10 ) )", Boolean.TRUE, null}, {"10 in ( not( <5, >=20, =10 ) )", Boolean.FALSE, null}, {"10 in ( not( <5 ) )", Boolean.TRUE, null}, {"10 in ( not( (10..20] ) )", Boolean.TRUE, null}, {"10 in ( not( 10 ) )", Boolean.FALSE, null}, {"10 in ( not( 5 ) )", Boolean.TRUE, null}, {"10 in ( not( 5, (5+5), (20+10) ) )", Boolean.FALSE, null}, {"10 in ( not( 5, (20+10) ) )", Boolean.TRUE, null}, {"10 in ( not( >5*20 ) )", Boolean.TRUE, null}, {"10 in ( not( 10 ), not( 20 ) )", Boolean.TRUE, null}, {"10 in ( not( null, 10 ) )", Boolean.FALSE, null}, {"10 in ( not( 5, 10 ) )", Boolean.FALSE, null}, {"null in ( not( 10, null ) )", Boolean.FALSE, null}, {"\"Boston\" in ( not( \"Toronto\", \"Montreal\" ) )", Boolean.TRUE, null}, {"\"Boston\" in ( not( \"Toronto\", \"Boston\" ) )", Boolean.FALSE, null}, {"{ ? foo : 5, result : ? foo < 10 }.result", Boolean.TRUE, null}, {"{ ? foo : 5, ? bar : 10, result : ? foo < ? bar}.result", Boolean.TRUE, null}, {"{ ?foo : 5, result : ?foo < 10 }.result", Boolean.TRUE, null}, {"{ foo ? : 5, result : foo ? < 10 }.result", Boolean.TRUE, null}, {"{ foo?bar : 5, result : foo?bar < 10 }.result", Boolean.TRUE, null}, {"{ test : > x, y : 20, x : 10, result : y in ( test ) }.result", Boolean.TRUE, null}, {"{ test : > x, y : 20, x : 10, result : test( y ) }.result", Boolean.TRUE, null}, {"{ test : in x, y : 20, x : [10, 20, 30], result : test( y ) }.result", null, FEELEvent.Severity.ERROR}, {"2 in 2", Boolean.TRUE, null}, {"{ x : 2, result : x in 2 }.result", Boolean.TRUE, null}, {"{ someList : [1, 2, 3], result : 2 in someList }.result", Boolean.TRUE, null}, {"{ someList : [1, 2, 3], x : 2, result : x in someList }.result", Boolean.TRUE, null}, {"{ someNestedList : { theList : [1, 2, 3] } , x : 2, result : x in someNestedList.theList }.result", Boolean.TRUE, null}, {"47 in 2", Boolean.FALSE, null}, {"{ x : 47, result : x in 2 }.result", Boolean.FALSE, null}, {"{ someList : [1, 2, 3], result : 47 in someList }.result", Boolean.FALSE, null}, {"{ someList : [1, 2, 3], x : 47, result : x in someList }.result", Boolean.FALSE, null}, {"{ someNestedList : { theList : [1, 2, 3] } , x : 47, result : x in someNestedList.theList }.result", Boolean.FALSE, null}};
        return Arrays.asList(cases);
    }
}

