/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime;

import java.util.Arrays;
import java.util.Collection;
import org.junit.runners.Parameterized;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.BaseFEELTest;
import org.kie.dmn.feel.runtime.UnaryTest;

public class FEELOperatorsTest
extends BaseFEELTest {
    @Parameterized.Parameters(name="{index}: {0} ({1}) = {2}")
    public static Collection<Object[]> data() {
        Object[][] cases = new Object[][]{{"not( true )", Boolean.FALSE, null}, {"not( false )", Boolean.TRUE, null}, {"not( 10 = 3 )", Boolean.TRUE, null}, {"not( \"foo\" )", UnaryTest.class, null}, {"{x : 10, r : not( x = 3 )}.r", Boolean.TRUE, null}, {"{x : 3, r : not( x = 3 )}.r", Boolean.FALSE, null}, {"10 between 5 and 12", Boolean.TRUE, null}, {"10 between 20 and 30", Boolean.FALSE, null}, {"10 between 20 and \"foo\"", null, FEELEvent.Severity.ERROR}, {"\"foo\" between 5 and 12", null, FEELEvent.Severity.ERROR}, {"\"foo\" between \"bar\" and \"zap\"", Boolean.TRUE, null}, {"\"foo\" between null and \"zap\"", null, FEELEvent.Severity.ERROR}, {"date(\"2016-08-02\") between date(\"2016-01-01\") and date(\"2016-12-31\")", Boolean.TRUE, null}, {"10 in ( 3, 5*2, 20 )", Boolean.TRUE, null}, {"null in ( 10, \"foo\", null )", Boolean.TRUE, null}, {"\"foo\" in ( \"bar\", \"baz\" )", Boolean.FALSE, null}, {"\"foo\" in null", null, FEELEvent.Severity.ERROR}, {"\"foo\" in ( 10, false, \"foo\" )", Boolean.TRUE, null}, {"10 in < 20", Boolean.TRUE, null}, {"10 in ( > 50, < 5 )", Boolean.FALSE, null}, {"10 in ( > 5, < -40 )", Boolean.TRUE, null}, {"null in ( > 20, null )", Boolean.TRUE, null}, {"null in -", Boolean.TRUE, null}, {"10 in [5..20]", Boolean.TRUE, null}, {"10 in [10..20)", Boolean.TRUE, null}, {"10 in (10..20)", Boolean.FALSE, null}, {"10 in (5..10)", Boolean.FALSE, null}, {"10 in ]5..10[", Boolean.FALSE, null}, {"10 in (5..10]", Boolean.TRUE, null}, {"\"b\" in (\"a\"..\"z\"]", Boolean.TRUE, null}, {" duration(\"P1Y2M\") in [ duration(\"P1Y2M\") .. duration(\"P1Y3M\")] ", Boolean.TRUE, null}, {" duration(\"P1Y4M\") in [ duration(\"P1Y2M\") .. duration(\"P1Y3M\")] ", Boolean.FALSE, null}, {" duration(\"PT24H\") in [ duration(\"P1Y2M\") .. duration(\"P1Y3M\")] ", null, FEELEvent.Severity.ERROR}, {"10 instance of number", Boolean.TRUE, null}, {"\"foo\" instance of string", Boolean.TRUE, null}, {"date(\"2016-08-11\") instance of date", Boolean.TRUE, null}, {"time(\"23:59:00\") instance of time", Boolean.TRUE, null}, {"date and time(\"2016-07-29T05:48:23.765-05:00\") instance of date and time", Boolean.TRUE, null}, {"duration( \"P2Y2M\" ) instance of duration", Boolean.TRUE, null}, {"true instance of boolean", Boolean.TRUE, null}, {"< 10 instance of unary test", Boolean.TRUE, null}, {"[10..20) instance of range", Boolean.TRUE, null}, {"[10, 20, 30] instance of list", Boolean.TRUE, null}, {"{ foo : \"foo\" } instance of context", Boolean.TRUE, null}, {"null instance of any", Boolean.FALSE, null}, {"null instance of string", Boolean.FALSE, null}, {"\"foo\" instance of any", Boolean.TRUE, null}, {"10 instance of any", Boolean.TRUE, null}, {"duration instance of function", Boolean.TRUE, null}};
        return Arrays.asList(cases);
    }
}

