/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.parser.feel11.profiles.DoCompileFEELProfile;
import org.kie.dmn.feel.runtime.BaseFEELTest;

@RunWith(value=Parameterized.class)
public abstract class BaseFEELCompilerTest {
    @Parameterized.Parameter(value=4)
    public BaseFEELTest.FEEL_TARGET testFEELTarget;
    private FEEL feel = null;
    @Parameterized.Parameter(value=0)
    public String expression;
    @Parameterized.Parameter(value=1)
    public Map<String, Type> inputTypes;
    @Parameterized.Parameter(value=2)
    public Map<String, Object> inputValues;
    @Parameterized.Parameter(value=3)
    public Object result;

    @Test
    public void testExpression() {
        this.feel = this.testFEELTarget == BaseFEELTest.FEEL_TARGET.JAVA_TRANSLATED ? FEEL.newInstance(Collections.singletonList(new DoCompileFEELProfile())) : FEEL.newInstance();
        this.assertResult(this.expression, this.inputTypes, this.inputValues, this.result);
    }

    protected void assertResult(String expression, Map<String, Type> inputTypes, Map<String, Object> inputValues, Object result) {
        CompilerContext ctx = this.feel.newCompilerContext();
        inputTypes.forEach((arg_0, arg_1) -> ((CompilerContext)ctx).addInputVariableType(arg_0, arg_1));
        CompiledExpression compiledExpression = this.feel.compile(expression, ctx);
        if (result == null) {
            MatcherAssert.assertThat((String)("Evaluating: '" + expression + "'"), (Object)this.feel.evaluate(compiledExpression, inputValues), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        } else if (result instanceof Class) {
            MatcherAssert.assertThat((String)("Evaluating: '" + expression + "'"), (Object)this.feel.evaluate(compiledExpression, inputValues), (Matcher)Matchers.is((Matcher)Matchers.instanceOf((Class)((Class)result))));
        } else {
            MatcherAssert.assertThat((String)("Evaluating: '" + expression + "'"), (Object)this.feel.evaluate(compiledExpression, inputValues), (Matcher)Matchers.is((Object)result));
        }
    }

    protected static List<Object[]> enrichWith5thParameter(Object[][] cases) {
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        for (Object[] c : cases) {
            results.add(new Object[]{c[0], c[1], c[2], c[3], BaseFEELTest.FEEL_TARGET.AST_INTERPRETED});
        }
        for (Object[] c : cases) {
            results.add(new Object[]{c[0], c[1], c[2], c[3], BaseFEELTest.FEEL_TARGET.JAVA_TRANSLATED});
        }
        return results;
    }
}

