/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.util.List;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;

public final class FunctionTestUtil {
    public static <T> void assertResult(FEELFnResult<T> result, T expectedResult) {
        if (expectedResult == null) {
            FunctionTestUtil.assertResultNull(result);
        } else {
            FunctionTestUtil.assertResultNotError(result);
            Object resultValue = result.cata(left -> null, right -> right);
            Assert.assertThat((Object)resultValue, (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)resultValue, (Matcher)Matchers.equalTo(expectedResult));
        }
    }

    public static void assertResultBigDecimal(FEELFnResult<BigDecimal> result, BigDecimal expectedResult) {
        FunctionTestUtil.assertResultNotError(result);
        BigDecimal resultValue = (BigDecimal)result.cata(left -> null, right -> right);
        Assert.assertThat((Object)resultValue, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)resultValue, (Matcher)Matchers.comparesEqualTo((Comparable)expectedResult));
    }

    public static <T> void assertResultList(FEELFnResult<List<T>> result, List<Object> expectedResult) {
        FunctionTestUtil.assertResultNotError(result);
        List resultList = (List)result.cata(left -> null, right -> right);
        Assert.assertThat((Object)resultList, (Matcher)Matchers.hasSize((int)expectedResult.size()));
        if (expectedResult.isEmpty()) {
            Assert.assertThat((Object)resultList, (Matcher)Matchers.empty());
        } else {
            Assert.assertThat((Object)resultList, (Matcher)Matchers.contains((Object[])expectedResult.toArray(new Object[0])));
        }
    }

    public static <T> void assertPredicateOnResult(FEELFnResult<?> result, Class<T> clazz, Predicate<T> assertion) {
        FunctionTestUtil.assertResultNotError(result);
        Object resultValue = result.cata(left -> null, clazz::cast);
        Assert.assertThat((Object)resultValue, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)assertion.test(resultValue), (Matcher)Matchers.is((Object)true));
    }

    public static <T> void assertResultNull(FEELFnResult<T> result) {
        FunctionTestUtil.assertResultNotError(result);
        Assert.assertThat((Object)result.cata(left -> false, right -> right), (Matcher)Matchers.nullValue());
    }

    public static <T> void assertResultNotError(FEELFnResult<T> result) {
        Assert.assertThat(result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.isRight(), (Matcher)Matchers.is((Object)true));
    }

    public static <T> void assertResultError(FEELFnResult<T> result, Class expectedErrorEventClass) {
        Assert.assertThat(result, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)result.isLeft(), (Matcher)Matchers.is((Object)true));
        FEELEvent resultEvent = (FEELEvent)result.cata(left -> left, right -> null);
        FunctionTestUtil.checkErrorEvent(resultEvent, expectedErrorEventClass);
    }

    public static void checkErrorEvent(FEELEvent errorEvent, Class errorEventClass) {
        Assert.assertThat((Object)errorEvent, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)errorEvent.getSeverity(), (Matcher)Matchers.is((Object)FEELEvent.Severity.ERROR));
        Assert.assertThat((Object)errorEvent, (Matcher)Matchers.instanceOf((Class)errorEventClass));
    }

    private FunctionTestUtil() {
    }
}

