/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.IndexOfFunction;

public class IndexOfFunctionTest {
    private IndexOfFunction indexOfFunction;

    @Before
    public void setUp() {
        this.indexOfFunction = new IndexOfFunction();
    }

    @Test
    public void invokeListNull() {
        FunctionTestUtil.assertResultError(this.indexOfFunction.invoke((List)null, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.indexOfFunction.invoke(null, new Object()), InvalidParametersEvent.class);
    }

    @Test
    public void invokeMatchNull() {
        FunctionTestUtil.assertResultList(this.indexOfFunction.invoke(Collections.emptyList(), null), Collections.emptyList());
        FunctionTestUtil.assertResultList(this.indexOfFunction.invoke(Collections.singletonList("test"), null), Collections.emptyList());
        FunctionTestUtil.assertResultList(this.indexOfFunction.invoke(Arrays.asList("test", null), null), Collections.singletonList(BigDecimal.valueOf(2L)));
        FunctionTestUtil.assertResultList(this.indexOfFunction.invoke(Arrays.asList(null, "test"), null), Collections.singletonList(BigDecimal.ONE));
        FunctionTestUtil.assertResultList(this.indexOfFunction.invoke(Arrays.asList("test", null, BigDecimal.ZERO), null), Collections.singletonList(BigDecimal.valueOf(2L)));
        FunctionTestUtil.assertResultList(this.indexOfFunction.invoke(Arrays.asList("test", null, null, BigDecimal.ZERO), null), Arrays.asList(BigDecimal.valueOf(2L), BigDecimal.valueOf(3L)));
    }

    @Test
    public void invokeBigDecimal() {
        FunctionTestUtil.assertResult(this.indexOfFunction.invoke(Arrays.asList("test", null, 12), (Object)BigDecimal.valueOf(12L)), Collections.emptyList());
        FunctionTestUtil.assertResult(this.indexOfFunction.invoke(Arrays.asList("test", null, BigDecimal.valueOf(12L)), (Object)BigDecimal.valueOf(12L)), Collections.singletonList(BigDecimal.valueOf(3L)));
        FunctionTestUtil.assertResult(this.indexOfFunction.invoke(Arrays.asList("test", null, BigDecimal.valueOf(12L)), (Object)BigDecimal.valueOf(12L).setScale(4, 4)), Collections.singletonList(BigDecimal.valueOf(3L)));
        FunctionTestUtil.assertResult(this.indexOfFunction.invoke(Arrays.asList(BigDecimal.valueOf(12.0), "test", null, BigDecimal.valueOf(12L)), (Object)BigDecimal.valueOf(12L)), Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(4L)));
    }

    @Test
    public void invokeMatchNotNull() {
        FunctionTestUtil.assertResult(this.indexOfFunction.invoke(Arrays.asList("test", null, 12), (Object)"testttt"), Collections.emptyList());
        FunctionTestUtil.assertResult(this.indexOfFunction.invoke(Arrays.asList("test", null, BigDecimal.valueOf(12L)), (Object)"test"), Collections.singletonList(BigDecimal.valueOf(1L)));
        FunctionTestUtil.assertResult(this.indexOfFunction.invoke(Arrays.asList("test", null, "test"), (Object)"test"), Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(3L)));
    }
}

