/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.interval;

import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.interval.FinishesFunction;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

public class FinishesFunctionTest {
    private FinishesFunction finishesFunction;

    @Before
    public void setUp() {
        this.finishesFunction = FinishesFunction.INSTANCE;
    }

    @Test
    public void invokeParamIsNull() {
        FunctionTestUtil.assertResultError(this.finishesFunction.invoke((Comparable)null, (Range)new RangeImpl()), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.finishesFunction.invoke((Comparable)((Object)"a"), (Range)null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeParamsCantBeCompared() {
        FunctionTestUtil.assertResultError(this.finishesFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), Range.RangeBoundary.CLOSED)), InvalidParametersEvent.class);
    }

    @Test
    public void invokeParamSingleAndRange() {
        FunctionTestUtil.assertResult(this.finishesFunction.invoke((Comparable)((Object)"f"), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.TRUE);
        FunctionTestUtil.assertResult(this.finishesFunction.invoke((Comparable)((Object)"a"), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.FALSE);
        FunctionTestUtil.assertResult(this.finishesFunction.invoke((Comparable)((Object)"f"), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.OPEN)), Boolean.FALSE);
        FunctionTestUtil.assertResult(this.finishesFunction.invoke((Comparable)((Object)"g"), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.FALSE);
    }

    @Test
    public void invokeParamRangeAndRange() {
        FunctionTestUtil.assertResult(this.finishesFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.TRUE);
        FunctionTestUtil.assertResult(this.finishesFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"c"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.TRUE);
        FunctionTestUtil.assertResult(this.finishesFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"c"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"e"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.FALSE);
        FunctionTestUtil.assertResult(this.finishesFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"c"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.OPEN)), Boolean.FALSE);
    }
}

