/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime;

import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.ast.InfixOpNode;
import org.kie.dmn.feel.util.EvalHelper;

public class FEELNumberCoercionTest {
    private final FEEL feel = FEEL.newInstance();

    private Object evaluateInfix(Object x, InfixOpNode.InfixOperator op, Object y) {
        HashMap<String, Object> inputVariables = new HashMap<String, Object>();
        inputVariables.put("x", x);
        inputVariables.put("y", y);
        String expression = "x " + op.symbol + " y";
        System.out.println(expression);
        return this.feel.evaluate(expression, inputVariables);
    }

    @Test
    public void test() {
        Assertions.assertThat((Object)this.evaluateInfix(1, InfixOpNode.InfixOperator.LT, 2.0)).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.evaluateInfix(2.0, InfixOpNode.InfixOperator.LT, 1)).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.evaluateInfix(1, InfixOpNode.InfixOperator.LTE, 2.0)).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.evaluateInfix(2.0, InfixOpNode.InfixOperator.LTE, 1)).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.evaluateInfix(1, InfixOpNode.InfixOperator.GT, 2.0)).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.evaluateInfix(2.0, InfixOpNode.InfixOperator.GT, 1)).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.evaluateInfix(1, InfixOpNode.InfixOperator.GTE, 2.0)).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.evaluateInfix(2.0, InfixOpNode.InfixOperator.GTE, 1)).isEqualTo((Object)Boolean.TRUE);
    }

    @SafeVarargs
    private final Object evaluate(String expression, Map.Entry<String, ?> ... vars) {
        HashMap inputVariables = new HashMap();
        for (Map.Entry<String, ?> v : vars) {
            inputVariables.put(v.getKey(), v.getValue());
        }
        return this.feel.evaluate(expression, inputVariables);
    }

    private static Map.Entry<String, Object> var(String name, Object value) {
        return new AbstractMap.SimpleEntry<String, Object>(name, value);
    }

    @Test
    public void testOthers() {
        Assertions.assertThat((Object)this.evaluate("ceiling( 1.01 )", new Map.Entry[0])).isEqualTo((Object)EvalHelper.getBigDecimalOrNull((Object)2.0));
        Assertions.assertThat((Object)this.evaluate("ceiling( x )", FEELNumberCoercionTest.var("x", 1.01))).isEqualTo((Object)EvalHelper.getBigDecimalOrNull((Object)2.0));
        Assertions.assertThat(((Map)this.evaluate("{ myf : function( v1, v2 ) ceiling(v1), invoked: myf(v2: false, v1: x) }", FEELNumberCoercionTest.var("x", 1.01))).get("invoked")).isEqualTo((Object)EvalHelper.getBigDecimalOrNull((Object)2.0));
        Assertions.assertThat(((Map)this.evaluate("{ myf : function( v1, v2 ) v1, invoked: myf(v2: false, v1: x) }", FEELNumberCoercionTest.var("x", 1.01))).get("invoked")).isEqualTo((Object)EvalHelper.getBigDecimalOrNull((Object)1.01));
        Assertions.assertThat((Object)this.evaluate(" x.y ", FEELNumberCoercionTest.var("x", new HashMap<String, Object>(){
            {
                this.put("y", 1.01);
            }
        }))).isEqualTo((Object)EvalHelper.getBigDecimalOrNull((Object)1.01));
        Assertions.assertThat((Object)this.evaluate("ceiling( x.y )", FEELNumberCoercionTest.var("x", new HashMap<String, Object>(){
            {
                this.put("y", 1.01);
            }
        }))).isEqualTo((Object)EvalHelper.getBigDecimalOrNull((Object)2.0));
    }

    @Test
    public void testMethodGetBigDecimalOrNull() {
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)1)).isEqualTo((Object)BigDecimal.ONE);
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)1)).isEqualTo((Object)BigDecimal.ONE);
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)1)).isEqualTo((Object)BigDecimal.ONE);
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)1L)).isEqualTo((Object)BigDecimal.ONE);
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)Float.valueOf(1.0f))).isEqualTo((Object)BigDecimal.ONE);
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)Float.valueOf(1.1f))).isEqualTo((Object)BigDecimal.valueOf(1.1));
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)1.0)).isEqualTo((Object)BigDecimal.ONE);
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)1.1)).isEqualTo((Object)BigDecimal.valueOf(1.1));
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)"1")).isEqualTo((Object)BigDecimal.ONE);
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)"1.1")).isEqualTo((Object)BigDecimal.valueOf(1.1));
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)"1.1000000")).isEqualTo((Object)BigDecimal.valueOf(1.1).setScale(7, 6));
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)Double.POSITIVE_INFINITY)).isNull();
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)Double.NEGATIVE_INFINITY)).isNull();
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)Double.NaN)).isNull();
    }
}

