/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.FEEL;

public class FEELEventListenerTest {
    private static final String LISTENER_OUTPUT = "Listener output";
    private FEEL feel;
    private String testVariable;

    @Before
    public void setup() {
        this.testVariable = null;
        this.feel = FEEL.newInstance();
        this.feel.addListener(event -> {
            this.testVariable = LISTENER_OUTPUT;
        });
        this.feel.addListener(System.out::println);
        this.feel.addListener(evt -> {
            if (evt.getSeverity() == FEELEvent.Severity.ERROR) {
                System.err.println(evt);
            }
        });
    }

    @Test
    public void testParserError() {
        this.feel.evaluate("10 + / 5");
        Assertions.assertThat((String)this.testVariable).isEqualTo(LISTENER_OUTPUT);
    }

    @Test
    public void testSomeBuiltinFunctions() {
        System.out.println(this.feel.evaluate("append( null, 1, 2 )"));
        Assertions.assertThat((String)this.testVariable).isEqualTo(LISTENER_OUTPUT);
    }
}

