/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.examples;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.kie.dmn.feel.lang.examples.ExamplesTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExamplesBaseTest {
    public static final String DEFAULT_IDENT = "    ";
    private static final Logger logger = LoggerFactory.getLogger(ExamplesBaseTest.class);

    protected static String loadExpression(String fileName) {
        try {
            return new String(Files.readAllBytes(Paths.get(ExamplesTest.class.getResource(fileName).toURI())));
        }
        catch (Exception e) {
            logger.error("Error reading file " + fileName, (Throwable)e);
            Assertions.fail((String)("Error reading file " + fileName));
            return null;
        }
    }

    protected String printContext(Map context) {
        return this.printContext(context, "");
    }

    private String printContext(Map<String, Object> context, String ident) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        for (Map.Entry<String, Object> e : context.entrySet()) {
            builder.append(ident).append(DEFAULT_IDENT).append((Object)e.getKey()).append(": ");
            if (e.getValue() instanceof Map) {
                builder.append(this.printContext((Map)e.getValue(), ident + DEFAULT_IDENT));
                continue;
            }
            builder.append(e.getValue()).append("\n");
        }
        builder.append(ident + "}\n");
        return builder.toString();
    }
}

