/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.codegen.feel11;

import com.github.javaparser.ast.expr.Expression;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.codegen.feel11.ASTCompilerVisitor;
import org.kie.dmn.feel.codegen.feel11.ASTUnaryTestTransform;
import org.kie.dmn.feel.codegen.feel11.CodegenTestUtil;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELSupport;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELUnaryTests;
import org.kie.dmn.feel.codegen.feel11.CompilerBytecodeLoader;
import org.kie.dmn.feel.codegen.feel11.DirectCompilerResult;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.Visitor;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.parser.feel11.ASTBuilderVisitor;
import org.kie.dmn.feel.parser.feel11.FEELParser;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Parser;
import org.kie.dmn.feel.util.EvalHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectCompilerUnaryTestsTest {
    public static final Logger LOG = LoggerFactory.getLogger(DirectCompilerUnaryTestsTest.class);

    private List<Boolean> parseCompileEvaluate(String feelLiteralExpression, Object l) {
        Object left = EvalHelper.coerceNumber((Object)l);
        FEELEventListenersManager mgr = new FEELEventListenersManager();
        CompiledFEELSupport.SyntaxErrorListener listener = new CompiledFEELSupport.SyntaxErrorListener();
        mgr.addListener((FEELEventListener)listener);
        EvaluationContext emptyContext = CodegenTestUtil.newEmptyEvaluationContext(mgr);
        CompiledFEELUnaryTests compiledUnaryTests = this.parse(feelLiteralExpression, mgr, listener);
        LOG.debug("{}", (Object)compiledUnaryTests);
        List<Boolean> result = compiledUnaryTests.getUnaryTests().stream().map(ut -> (Boolean)ut.apply((Object)emptyContext, left)).collect(Collectors.toList());
        if (listener.isError()) {
            LOG.debug("{}", (Object)listener.event());
            return Collections.emptyList();
        }
        LOG.debug("{}", result);
        return result;
    }

    @Test
    public void test_Dash() {
        Assertions.assertThat(this.parseCompileEvaluate("-", 1)).containsExactly((Object[])new Boolean[]{Boolean.TRUE});
        Assertions.assertThat(this.parseCompileEvaluate("-, -", 1)).isEmpty();
    }

    @Test
    public void test_positiveUnaryTestIneq() {
        Assertions.assertThat(this.parseCompileEvaluate("<47", 1)).containsExactly((Object[])new Boolean[]{Boolean.TRUE});
        Assertions.assertThat(this.parseCompileEvaluate("<47, <100", 1)).containsExactly((Object[])new Boolean[]{Boolean.TRUE, Boolean.TRUE});
        Assertions.assertThat(this.parseCompileEvaluate("<47, <100, <-47", 1)).containsExactly((Object[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.FALSE});
        Assertions.assertThat(this.parseCompileEvaluate(">=1, >2, <3, <=4", 0)).containsExactly((Object[])new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE});
        Assertions.assertThat(this.parseCompileEvaluate(">=1, >2, <3, <=4", 1)).containsExactly((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE});
        Assertions.assertThat(this.parseCompileEvaluate(">=1, >2, <3, <=4", 2)).containsExactly((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE});
        Assertions.assertThat(this.parseCompileEvaluate(">=1, >2, <3, <=4", 3)).containsExactly((Object[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.TRUE});
        Assertions.assertThat(this.parseCompileEvaluate(">=1, >2, <3, <=4", 4)).containsExactly((Object[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.TRUE});
        Assertions.assertThat(this.parseCompileEvaluate(">=1, >2, <3, <=4", 5)).containsExactly((Object[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE});
        Assertions.assertThat(this.parseCompileEvaluate("!=1, !=42", 1)).containsExactly((Object[])new Boolean[]{Boolean.FALSE, Boolean.TRUE});
    }

    @Test
    public void test_positiveUnaryTestIneq_forEQ() {
        Assertions.assertThat(this.parseCompileEvaluate("<47, =1", 1)).containsExactly((Object[])new Boolean[]{Boolean.TRUE, Boolean.TRUE});
        Assertions.assertThat(this.parseCompileEvaluate("<47, =47", 1)).containsExactly((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        Assertions.assertThat(this.parseCompileEvaluate("<47, 1", 1)).containsExactly((Object[])new Boolean[]{Boolean.TRUE, Boolean.TRUE});
        Assertions.assertThat(this.parseCompileEvaluate("<47, 47", 1)).containsExactly((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE});
    }

    @Test
    public void test_not() {
        Assertions.assertThat(this.parseCompileEvaluate("not(=47), not(<1), not(!=1)", 1)).isEmpty();
    }

    @Test
    public void test_simpleUnaryTest_forRANGE() {
        Assertions.assertThat(this.parseCompileEvaluate("[1..2]", 1)).containsExactly((Object[])new Boolean[]{Boolean.TRUE});
        Assertions.assertThat(this.parseCompileEvaluate("[1..2], [2..3]", 1)).containsExactly((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        Assertions.assertThat(this.parseCompileEvaluate("(1..2], [2..3]", 1)).containsExactly((Object[])new Boolean[]{Boolean.FALSE, Boolean.FALSE});
        Assertions.assertThat(this.parseCompileEvaluate("(1..2], [2..3]", 2)).containsExactly((Object[])new Boolean[]{Boolean.TRUE, Boolean.TRUE});
    }

    @Test
    public void t2() {
        Assertions.assertThat(this.parseCompileEvaluate("\"asd\"", "asd")).containsExactly((Object[])new Boolean[]{Boolean.TRUE});
    }

    private CompiledFEELUnaryTests parse(String input, FEELEventListenersManager mgr, CompiledFEELSupport.SyntaxErrorListener listener) {
        return this.parse(input, Collections.emptyMap(), mgr, listener);
    }

    private CompiledFEELUnaryTests parse(String input, Map<String, Type> inputTypes, FEELEventListenersManager mgr, CompiledFEELSupport.SyntaxErrorListener listener) {
        DirectCompilerResult directResult;
        FEEL_1_1Parser parser = FEELParser.parse((FEELEventListenersManager)mgr, (String)input, inputTypes, Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), null);
        FEEL_1_1Parser.UnaryTestsRootContext tree = parser.unaryTestsRoot();
        if (listener.isError()) {
            directResult = CompiledFEELSupport.compiledErrorUnaryTest((String)listener.event().getMessage());
        } else {
            ASTBuilderVisitor v = new ASTBuilderVisitor(inputTypes, null);
            BaseNode node = (BaseNode)v.visit((ParseTree)tree);
            BaseNode transformed = ((ASTUnaryTestTransform.UnaryTestSubexpr)node.accept((Visitor)new ASTUnaryTestTransform())).node();
            directResult = (DirectCompilerResult)transformed.accept((Visitor)new ASTCompilerVisitor());
        }
        Expression expr = directResult.getExpression();
        CompiledFEELUnaryTests cu = new CompilerBytecodeLoader().makeFromJPUnaryTestsExpression(input, expr, directResult.getFieldDeclarations());
        return cu;
    }
}

