/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.twovaluelogic;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.twovaluelogic.NNCountFunction;

public class CountFunctionTest {
    private NNCountFunction countFunction;

    @Before
    public void setUp() {
        this.countFunction = new NNCountFunction();
    }

    @Test
    public void invokeParamListNull() {
        FunctionTestUtil.assertResult(this.countFunction.invoke((List)null), BigDecimal.ZERO);
    }

    @Test
    public void invokeParamListEmpty() {
        FunctionTestUtil.assertResult(this.countFunction.invoke(Collections.emptyList()), BigDecimal.ZERO);
    }

    @Test
    public void invokeParamListNonEmpty() {
        FunctionTestUtil.assertResult(this.countFunction.invoke(Arrays.asList(1, 2, "test")), BigDecimal.valueOf(3L));
    }

    @Test
    public void invokeParamArrayNull() {
        FunctionTestUtil.assertResult(this.countFunction.invoke((Object[])null), BigDecimal.ZERO);
    }

    @Test
    public void invokeParamArrayEmpty() {
        FunctionTestUtil.assertResult(this.countFunction.invoke(new Object[0]), BigDecimal.ZERO);
    }

    @Test
    public void invokeParamArrayNonEmpty() {
        FunctionTestUtil.assertResult(this.countFunction.invoke(new Object[]{1, 2, "test"}), BigDecimal.valueOf(3L));
    }
}

