/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.junit.runners.Parameterized;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.BaseFEELTest;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

public class FEELListsTest
extends BaseFEELTest {
    @Parameterized.Parameters(name="{3}: {0} ({1}) = {2}")
    public static Collection<Object[]> data() {
        Object[][] cases = new Object[][]{{"[ 5, 10+2, \"foo\"+\"bar\", true ]", Arrays.asList(BigDecimal.valueOf(5L), BigDecimal.valueOf(12L), "foobar", Boolean.TRUE), null}, {"[ null ]", Arrays.asList(new Object[]{null}), null}, {"[ null, null ]", Arrays.asList(null, null), null}, {"[ null, 47, null ]", Arrays.asList(null, BigDecimal.valueOf(47L), null), null}, {"[\"a\", \"b\", \"c\"][1]", "a", null}, {"[\"a\", \"b\", \"c\"][2]", "b", null}, {"[\"a\", \"b\", \"c\"][3]", "c", null}, {"[\"a\", \"b\", \"c\"][-1]", "c", null}, {"[\"a\", \"b\", \"c\"][-2]", "b", null}, {"[\"a\", \"b\", \"c\"][-3]", "a", null}, {"[\"a\", \"b\", \"c\"][4]", null, FEELEvent.Severity.WARN}, {"[\"a\", \"b\", \"c\"][984]", null, FEELEvent.Severity.WARN}, {"[\"a\", \"b\", \"c\"][-4]", null, FEELEvent.Severity.WARN}, {"[\"a\", \"b\", \"c\"][-984]", null, FEELEvent.Severity.WARN}, {"\"a\"[1]", "a", null}, {"\"a\"[2]", null, FEELEvent.Severity.WARN}, {"{L :3, r: L[1]}.r", BigDecimal.valueOf(3L), null}, {"{L :3, r: L[2]}.r", null, FEELEvent.Severity.WARN}, {"\"a\"[-1]", "a", null}, {"\"a\"[-2]", null, FEELEvent.Severity.WARN}, {"{ a list : [10, 20, 30, 40], second : a list[2] }.second", BigDecimal.valueOf(20L), null}, {"[1, 2, 3, 4][item = 4]", Collections.singletonList(BigDecimal.valueOf(4L)), null}, {"[1, 2, 3, 4][item > 2]", Arrays.asList(BigDecimal.valueOf(3L), BigDecimal.valueOf(4L)), null}, {"[1, 2, 3, 4][item > 5]", Collections.emptyList(), null}, {"[ {x:1, y:2}, {x:2, y:3} ][x = 1]", Collections.singletonList(new HashMap<String, Object>(){
            {
                this.put("x", BigDecimal.valueOf(1L));
                this.put("y", BigDecimal.valueOf(2L));
            }
        }), null}, {"[ {x:1, y:2}, {x:2, y:3} ][x > 1]", Collections.singletonList(new HashMap<String, Object>(){
            {
                this.put("x", BigDecimal.valueOf(2L));
                this.put("y", BigDecimal.valueOf(3L));
            }
        }), null}, {"[ {x:1, y:2}, {x:2, y:3} ][x = 0]", Collections.emptyList(), null}, {"{x:false, l:[ {x:1, y:2}, {x:2, y:3} ],r:l[x] }.r", Collections.emptyList(), null}, {"[\"a\", \"b\", \"c\"][a]", Collections.emptyList(), null}, {"{ a list : [ { a : false, b : 2 }, { a : true, b : 3 } ], r : a list[a] }.r", Collections.singletonList(new HashMap<String, Object>(){
            {
                this.put("a", true);
                this.put("b", BigDecimal.valueOf(3L));
            }
        }), null}, {"{ a list : [ { a : false, b : 2 }, { a : null, b : 3 }, { b : 4 } ], r : a list[a] }.r", Collections.emptyList(), null}, {"{ a list : [ \"a\", \"b\", \"c\" ], x : 2, a : a list[x]}.a", "b", null}, {"{ a list : [ { x : false, y : 2 }, { x : true, y : 3 } ], x : \"asd\", a : a list[x] }.a", Collections.singletonList(new HashMap<String, Object>(){
            {
                this.put("x", true);
                this.put("y", BigDecimal.valueOf(3L));
            }
        }), null}, {"{ a list : [ { x : false, y : 2 }, { x : true, y : 3 } ], x : false, a : a list[x] }.a", Collections.singletonList(new HashMap<String, Object>(){
            {
                this.put("x", true);
                this.put("y", BigDecimal.valueOf(3L));
            }
        }), null}, {"{ a list : [ { x : false, y : 2 }, { x : true, y : 3 } ], x : null, a : a list[x] }.a", Collections.singletonList(new HashMap<String, Object>(){
            {
                this.put("x", true);
                this.put("y", BigDecimal.valueOf(3L));
            }
        }), null}, {"{ people : [ { firstName : \"bob\" }, { firstName : \"max\" } ], result : people[ lastName = null ] }.result", Arrays.asList(new HashMap<String, Object>(){
            {
                this.put("firstName", "bob");
            }
        }, new HashMap<String, Object>(){
            {
                this.put("firstName", "max");
            }
        }), null}, {"[ {x:1, y:2}, {x:2, y:3} ].y", Arrays.asList(BigDecimal.valueOf(2L), BigDecimal.valueOf(3L)), null}, {"[ {x:1, y:2}, {x:2} ].y", Arrays.asList(BigDecimal.valueOf(2L), null), null}, {"[ {x:1, y:2}, {x:2, y:3} ].z", Arrays.asList(null, null), null}, {"{ Data: [{v: \"A1\"}, {v: null}, {v: \"C1\"}], r: Data.v }.r", Arrays.asList("A1", null, "C1"), null}, {"{ Data: [{v: \"A1\"}, {v: null}, {v: \"C1\"}], r: Data[v != \"D1\"].v }.r", Arrays.asList("A1", null, "C1"), null}, {"[ ( 10 .. 20 ) ]", Collections.singletonList(new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)BigDecimal.valueOf(10L), (Comparable)BigDecimal.valueOf(20L), Range.RangeBoundary.OPEN)), null}, {"[ ] 10 .. 20 [ ]", Collections.singletonList(new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)BigDecimal.valueOf(10L), (Comparable)BigDecimal.valueOf(20L), Range.RangeBoundary.OPEN)), null}, {"[ ( duration(\"P1D\") .. duration(\"P10D\") ) ]", Collections.singletonList(new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.OPEN)), null}, {"[ ( duration(\"P1D\") .. duration(\"P10D\") [ ]", Collections.singletonList(new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.OPEN)), null}, {"[ ( duration(\"P1D\") .. duration(\"P10D\") ] ]", Collections.singletonList(new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.CLOSED)), null}, {"[ ] duration(\"P1D\") .. duration(\"P10D\") ) ]", Collections.singletonList(new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.OPEN)), null}, {"[ ] duration(\"P1D\") .. duration(\"P10D\") [ ]", Collections.singletonList(new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.OPEN)), null}, {"[ ] duration(\"P1D\") .. duration(\"P10D\") ] ]", Collections.singletonList(new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.CLOSED)), null}, {"[ [ duration(\"P1D\") .. duration(\"P10D\") ) ]", Collections.singletonList(new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.OPEN)), null}, {"[ [ duration(\"P1D\") .. duration(\"P10D\") [ ]", Collections.singletonList(new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.OPEN)), null}, {"[ [ duration(\"P1D\") .. duration(\"P10D\") ] ]", Collections.singletonList(new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.CLOSED)), null}, {"[ ( duration(\"P1D\") .. duration(\"P10D\") ), ( duration(\"P2D\") .. duration(\"P10D\") )][1]", new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.OPEN), null}};
        return FEELListsTest.addAdditionalParameters(cases, false);
    }
}

