/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.AppendFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class AppendFunctionTest {
    private AppendFunction appendFunction;

    @Before
    public void setUp() {
        this.appendFunction = new AppendFunction();
    }

    @Test
    public void invokeInvalidParams() {
        FunctionTestUtil.assertResultError(this.appendFunction.invoke((List)null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.appendFunction.invoke((List)null, new Object[0]), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.appendFunction.invoke(Collections.emptyList(), null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeEmptyParams() {
        FunctionTestUtil.assertResultList(this.appendFunction.invoke(Collections.emptyList(), new Object[0]), Collections.emptyList());
    }

    @Test
    public void invokeAppendNothing() {
        FunctionTestUtil.assertResultList(this.appendFunction.invoke(List.of("test"), new Object[0]), List.of("test"));
        FunctionTestUtil.assertResultList(this.appendFunction.invoke(Arrays.asList("test", "test2"), new Object[0]), Arrays.asList("test", "test2"));
    }

    @Test
    public void invokeAppendSomething() {
        FunctionTestUtil.assertResultList(this.appendFunction.invoke(Collections.emptyList(), new Object[]{"test"}), List.of("test"));
        FunctionTestUtil.assertResultList(this.appendFunction.invoke(List.of("test"), new Object[]{"test2"}), Arrays.asList("test", "test2"));
        FunctionTestUtil.assertResultList(this.appendFunction.invoke(List.of("test"), new Object[]{"test2", "test3"}), Arrays.asList("test", "test2", "test3"));
    }
}

