/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.InsertBeforeFunction;

public class InsertBeforeFunctionTest {
    private InsertBeforeFunction insertBeforeFunction;

    @Before
    public void setUp() {
        this.insertBeforeFunction = new InsertBeforeFunction();
    }

    @Test
    public void invokeListNull() {
        FunctionTestUtil.assertResultError(this.insertBeforeFunction.invoke(null, BigDecimal.ZERO, new Object()), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokePositionNull() {
        FunctionTestUtil.assertResultError(this.insertBeforeFunction.invoke(Collections.emptyList(), null, new Object()), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeListPositionNull() {
        FunctionTestUtil.assertResultError(this.insertBeforeFunction.invoke(null, null, new Object()), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokePositionZero() {
        FunctionTestUtil.assertResultError(this.insertBeforeFunction.invoke(Collections.emptyList(), BigDecimal.ZERO, new Object()), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokePositionOutsideListBounds() {
        FunctionTestUtil.assertResultError(this.insertBeforeFunction.invoke(Collections.emptyList(), BigDecimal.ONE, new Object()), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.insertBeforeFunction.invoke(Collections.emptyList(), BigDecimal.valueOf(-1L), new Object()), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeInsertIntoEmptyList() {
        FunctionTestUtil.assertResultError(this.insertBeforeFunction.invoke(Collections.emptyList(), BigDecimal.ONE, null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokePositionPositive() {
        FunctionTestUtil.assertResult(this.insertBeforeFunction.invoke(Collections.singletonList("test"), BigDecimal.ONE, null), Arrays.asList(null, "test"), new String[0]);
        FunctionTestUtil.assertResult(this.insertBeforeFunction.invoke(Arrays.asList("test", null, BigDecimal.ZERO), BigDecimal.valueOf(2L), (Object)"testtt"), Arrays.asList("test", "testtt", null, BigDecimal.ZERO), new String[0]);
        FunctionTestUtil.assertResult(this.insertBeforeFunction.invoke(Arrays.asList("test", null, BigDecimal.ZERO), BigDecimal.valueOf(3L), (Object)"testtt"), Arrays.asList("test", null, "testtt", BigDecimal.ZERO), new String[0]);
    }

    @Test
    public void invokePositionNegative() {
        FunctionTestUtil.assertResult(this.insertBeforeFunction.invoke(Collections.singletonList("test"), BigDecimal.valueOf(-1L), null), Arrays.asList(null, "test"), new String[0]);
        FunctionTestUtil.assertResult(this.insertBeforeFunction.invoke(Arrays.asList("test", null, BigDecimal.ZERO), BigDecimal.valueOf(-2L), (Object)"testtt"), Arrays.asList("test", "testtt", null, BigDecimal.ZERO), new String[0]);
        FunctionTestUtil.assertResult(this.insertBeforeFunction.invoke(Arrays.asList("test", null, BigDecimal.ZERO), BigDecimal.valueOf(-3L), (Object)"testtt"), Arrays.asList("testtt", "test", null, BigDecimal.ZERO), new String[0]);
    }
}

