/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.EndsWithFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class EndsWithFunctionTest {
    private EndsWithFunction endsWithFunction;

    @Before
    public void setUp() {
        this.endsWithFunction = new EndsWithFunction();
    }

    @Test
    public void invokeParamsNull() {
        FunctionTestUtil.assertResultError(this.endsWithFunction.invoke((String)null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.endsWithFunction.invoke(null, "test"), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.endsWithFunction.invoke("test", null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeEndsWith() {
        FunctionTestUtil.assertResult(this.endsWithFunction.invoke("test", "t"), true, new String[0]);
        FunctionTestUtil.assertResult(this.endsWithFunction.invoke("test", "st"), true, new String[0]);
        FunctionTestUtil.assertResult(this.endsWithFunction.invoke("test", "est"), true, new String[0]);
        FunctionTestUtil.assertResult(this.endsWithFunction.invoke("test", "test"), true, new String[0]);
    }

    @Test
    public void invokeNotEndsWith() {
        FunctionTestUtil.assertResult(this.endsWithFunction.invoke("test", "es"), false, new String[0]);
        FunctionTestUtil.assertResult(this.endsWithFunction.invoke("test", "ttttt"), false, new String[0]);
        FunctionTestUtil.assertResult(this.endsWithFunction.invoke("test", "estt"), false, new String[0]);
        FunctionTestUtil.assertResult(this.endsWithFunction.invoke("test", "tt"), false, new String[0]);
    }
}

