/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.extended;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.lang.ast.AtLiteralNode;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.BooleanNode;
import org.kie.dmn.feel.lang.ast.FunctionInvocationNode;
import org.kie.dmn.feel.lang.ast.NullNode;
import org.kie.dmn.feel.lang.ast.NumberNode;
import org.kie.dmn.feel.lang.ast.StringNode;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.extended.RangeFunction;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

public class RangeFunctionTest {
    private RangeFunction rangeFunction;

    @Before
    public void setUp() {
        this.rangeFunction = new RangeFunction();
    }

    @Test
    public void invokeNull() {
        List<String> from = Arrays.asList(null, " ", "", "[..]");
        from.forEach(it -> FunctionTestUtil.assertResultError(this.rangeFunction.invoke(it), InvalidParametersEvent.class, it));
    }

    @Test
    public void invokeDifferentTypes() {
        List<String> from = Arrays.asList("[1..\"cheese\"]", "[1..date(\"1978-09-12\")]", "[1..date(\"1978-09-12\")]", "[1..\"upper case(\"aBc4\")\"]");
        from.forEach(it -> FunctionTestUtil.assertResultError(this.rangeFunction.invoke(it), InvalidParametersEvent.class, it));
    }

    @Test
    public void invokeInvalidTypes() {
        String from = "[if(false)..if(true)]";
        FunctionTestUtil.assertResultError(this.rangeFunction.invoke(from), InvalidParametersEvent.class, from);
    }

    @Test
    public void invoke_LeftNull() {
        String from = "(..2)";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, null, (Comparable)BigDecimal.valueOf(2L), Range.RangeBoundary.OPEN), from);
        from = "(..\"z\")";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, null, (Comparable)((Object)"z"), Range.RangeBoundary.OPEN), from);
        from = "(..\"yz\")";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, null, (Comparable)((Object)"yz"), Range.RangeBoundary.OPEN), from);
        from = "(..date(\"1978-10-13\"))";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, null, (Comparable)LocalDate.of(1978, 10, 13), Range.RangeBoundary.OPEN), from);
        from = "(..duration(\"P3DT20H14M\"))";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, null, (Comparable)Duration.parse("P3DT20H14M"), Range.RangeBoundary.OPEN), from);
        from = "(..duration(\"P2Y6M\"))";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, null, (Comparable)new ComparablePeriod(Period.parse("P2Y6M")), Range.RangeBoundary.OPEN), from);
    }

    @Test
    public void invoke_RightNull() {
        String from = "(1..)";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)BigDecimal.ONE, null, Range.RangeBoundary.OPEN), from);
        from = "(\"a\"..)";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)((Object)"a"), null, Range.RangeBoundary.OPEN), from);
        from = "(\"ab\"..)";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)((Object)"ab"), null, Range.RangeBoundary.OPEN), from);
        from = "(date(\"1978-09-12\")..)";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)LocalDate.of(1978, 9, 12), null, Range.RangeBoundary.OPEN), from);
        from = "(duration(\"P2DT20H14M\")..)";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P2DT20H14M"), null, Range.RangeBoundary.OPEN), from);
        from = "(duration(\"P1Y6M\")..)";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)new ComparablePeriod(Period.parse("P1Y6M")), null, Range.RangeBoundary.OPEN), from);
    }

    @Test
    public void invoke_OpenOpenBoundaries() {
        String from = "(1..2)";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)BigDecimal.ONE, (Comparable)BigDecimal.valueOf(2L), Range.RangeBoundary.OPEN), from);
        from = "(\"a\"..\"z\")";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)((Object)"a"), (Comparable)((Object)"z"), Range.RangeBoundary.OPEN), from);
        from = "(\"ab\"..\"yz\")";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)((Object)"ab"), (Comparable)((Object)"yz"), Range.RangeBoundary.OPEN), from);
        from = "(date(\"1978-09-12\")..date(\"1978-10-13\"))";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)LocalDate.of(1978, 9, 12), (Comparable)LocalDate.of(1978, 10, 13), Range.RangeBoundary.OPEN), from);
        from = "(duration(\"P2DT20H14M\")..duration(\"P3DT20H14M\"))";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P2DT20H14M"), (Comparable)Duration.parse("P3DT20H14M"), Range.RangeBoundary.OPEN), from);
        from = "(duration(\"P1Y6M\")..duration(\"P2Y6M\"))";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)new ComparablePeriod(Period.parse("P1Y6M")), (Comparable)new ComparablePeriod(Period.parse("P2Y6M")), Range.RangeBoundary.OPEN), from);
    }

    @Test
    public void invoke_OpenClosedBoundaries() {
        String from = "(1..2]";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)BigDecimal.ONE, (Comparable)BigDecimal.valueOf(2L), Range.RangeBoundary.CLOSED), from);
        from = "(\"a\"..\"z\"]";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)((Object)"a"), (Comparable)((Object)"z"), Range.RangeBoundary.CLOSED), from);
        from = "(date(\"1978-09-12\")..date(\"1978-10-13\")]";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)LocalDate.of(1978, 9, 12), (Comparable)LocalDate.of(1978, 10, 13), Range.RangeBoundary.CLOSED), from);
        from = "(duration(\"P2DT20H14M\")..duration(\"P3DT20H14M\")]";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P2DT20H14M"), (Comparable)Duration.parse("P3DT20H14M"), Range.RangeBoundary.CLOSED), from);
    }

    @Test
    public void invoke_ClosedOpenBoundaries() {
        String from = "[1..2)";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.ONE, (Comparable)BigDecimal.valueOf(2L), Range.RangeBoundary.OPEN), from);
        from = "[\"a\"..\"z\")";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"z"), Range.RangeBoundary.OPEN), from);
        from = "[date(\"1978-09-12\")..date(\"1978-10-13\"))";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)LocalDate.of(1978, 9, 12), (Comparable)LocalDate.of(1978, 10, 13), Range.RangeBoundary.OPEN), from);
        from = "[duration(\"P2DT20H14M\")..duration(\"P3DT20H14M\"))";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke("[duration(\"P2DT20H14M\")..duration(\"P3DT20H14M\"))"), new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Duration.parse("P2DT20H14M"), (Comparable)Duration.parse("P3DT20H14M"), Range.RangeBoundary.OPEN), from);
    }

    @Test
    public void invoke_ClosedClosedBoundaries() {
        String from = "[1..2)";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke("[1..2]"), new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.ONE, (Comparable)BigDecimal.valueOf(2L), Range.RangeBoundary.CLOSED), from);
        from = "[2..1]";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.valueOf(2L), (Comparable)BigDecimal.ONE, Range.RangeBoundary.CLOSED), from);
        from = "[\"a\"..\"z\"]";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"z"), Range.RangeBoundary.CLOSED), from);
        from = "[date(\"1978-09-12\")..date(\"1978-10-13\")]";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)LocalDate.of(1978, 9, 12), (Comparable)LocalDate.of(1978, 10, 13), Range.RangeBoundary.CLOSED), from);
        from = "[duration(\"P2DT20H14M\")..duration(\"P3DT20H14M\")]";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Duration.parse("P2DT20H14M"), (Comparable)Duration.parse("P3DT20H14M"), Range.RangeBoundary.CLOSED), from);
    }

    @Test
    public void invoke_WithOneFunctionNode() {
        String from = "[number(\"1\", \",\", \".\")\"..2]";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.ONE, (Comparable)BigDecimal.valueOf(2L), Range.RangeBoundary.CLOSED), from);
        from = "[\"a\"..lower case(\"Z\")]";
        FunctionTestUtil.assertResult(this.rangeFunction.invoke(from), new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"z"), Range.RangeBoundary.CLOSED), from);
    }

    @Test
    public void nodeIsAllowed_True() {
        BaseNode node = this.rangeFunction.getNullNode();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeIsAllowed(node)).withFailMessage(node.getText(), new Object[0])).isTrue();
        node = this.getNumberNode();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeIsAllowed(node)).withFailMessage(node.getText(), new Object[0])).isTrue();
        node = this.getStringNode();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeIsAllowed(node)).withFailMessage(node.getText(), new Object[0])).isTrue();
        node = this.getAtLiteralNode();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeIsAllowed(node)).withFailMessage(node.getText(), new Object[0])).isTrue();
        node = this.getFunctionInvocationNodeA();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeIsAllowed(node)).withFailMessage(node.getText(), new Object[0])).isTrue();
    }

    @Test
    public void nodeIsAllowed_False() {
        BaseNode node = this.rangeFunction.parse("if(true)");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeIsAllowed(node)).withFailMessage(node.getText(), new Object[0])).isFalse();
        node = this.getBooleanNode();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeIsAllowed(node)).withFailMessage(node.getText(), new Object[0])).isFalse();
    }

    @Test
    public void nodeValueIsAllowed_True() {
        Comparable<Integer> value = null;
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeValueIsAllowed(value)).withFailMessage(String.format("%s", value), new Object[0])).isTrue();
        value = 12;
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeValueIsAllowed((Object)value)).withFailMessage(String.format("%s", value), new Object[0])).isTrue();
        value = BigDecimal.valueOf(23.3243);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeValueIsAllowed((Object)value)).withFailMessage(String.format("%s", value), new Object[0])).isTrue();
        value = DateTimeFormatter.ISO_DATE.parse((CharSequence)"2016-07-29", LocalDate::from);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeValueIsAllowed((Object)value)).withFailMessage(String.format("%s", value), new Object[0])).isTrue();
        value = DateTimeFormatter.ISO_TIME.parse((CharSequence)"23:59:00", LocalTime::from);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeValueIsAllowed((Object)value)).withFailMessage(String.format("%s", value), new Object[0])).isTrue();
        value = LocalDateTime.of(2016, 7, 29, 5, 48, 23, 0);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeValueIsAllowed((Object)value)).withFailMessage(String.format("%s", value), new Object[0])).isTrue();
        value = Duration.parse("P2DT20H14M");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeValueIsAllowed((Object)value)).withFailMessage(String.format("%s", value), new Object[0])).isTrue();
    }

    @Test
    public void nodeValueIsAllowed_False() {
        List value = Boolean.TRUE;
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeValueIsAllowed((Object)value)).withFailMessage(String.format("%s", value), new Object[0])).isFalse();
        value = Collections.emptyMap();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeValueIsAllowed((Object)value)).withFailMessage(String.format("%s", value), new Object[0])).isFalse();
        value = Collections.emptyList();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodeValueIsAllowed(value)).withFailMessage(String.format("%s", value), new Object[0])).isFalse();
    }

    @Test
    public void nodesReturnsSameType_True() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodesReturnsSameType(null, null)).withFailMessage("null - null", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodesReturnsSameType((Object)"Hello", (Object)"world")).withFailMessage("\"Hello\" - \"world\"", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodesReturnsSameType(null, (Object)"world")).withFailMessage("null - \"world\"", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodesReturnsSameType((Object)1, null)).withFailMessage("1 - null", new Object[0])).isTrue();
    }

    @Test
    public void nodesReturnsSameType_False() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.rangeFunction.nodesReturnsSameType((Object)"1", (Object)1)).withFailMessage("\"1\" - 1", new Object[0])).isFalse();
    }

    @Test
    public void evaluateWithValidFunctionInvocationNode() {
        Object[][] data = RangeFunctionTest.validFunctionInvocationNodeData();
        Arrays.stream(data).forEach(objects -> {
            String expression = String.format("[%1$s..%1$s]", objects[0]);
            FEELFnResult retrieved = this.rangeFunction.invoke(expression);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)retrieved.isRight()).withFailMessage(() -> String.format("Expected 'retrieved.isRight()' from, %s", expression))).isTrue();
        });
    }

    @Test
    public void evaluateWithInvalidFunctionInvocationNode() {
        Object[][] data = RangeFunctionTest.invalidFunctionInvocationNodeData();
        Arrays.stream(data).forEach(objects -> {
            String expression = String.format("[%1$s..%1$s]", objects[0]);
            FEELFnResult retrieved = this.rangeFunction.invoke(expression);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)retrieved.isLeft()).withFailMessage(() -> String.format("Expected 'retrieved.isLeft()' from, %s", expression))).isTrue();
        });
    }

    @Test
    public void parse_NotEmptyString() {
        String input = "";
        ((ObjectAssert)Assertions.assertThat((Object)this.rangeFunction.parse(input)).withFailMessage(String.format("Check `%s`", input), new Object[0])).isInstanceOf(NullNode.class);
        input = "null";
        ((ObjectAssert)Assertions.assertThat((Object)this.rangeFunction.parse("null")).withFailMessage(String.format("Check `%s`", input), new Object[0])).isInstanceOf(NullNode.class);
        input = "1";
        ((ObjectAssert)Assertions.assertThat((Object)this.rangeFunction.parse("1")).withFailMessage(String.format("Check `%s`", input), new Object[0])).isInstanceOf(NumberNode.class);
        input = "\"a\"";
        ((ObjectAssert)Assertions.assertThat((Object)this.rangeFunction.parse(input)).withFailMessage(String.format("Check `%s`", input), new Object[0])).isInstanceOf(StringNode.class);
        input = "false";
        ((ObjectAssert)Assertions.assertThat((Object)this.rangeFunction.parse(input)).withFailMessage(String.format("Check `%s`", input), new Object[0])).isInstanceOf(BooleanNode.class);
        input = "@\"2019-01-01\"";
        ((ObjectAssert)Assertions.assertThat((Object)this.rangeFunction.parse(input)).withFailMessage(String.format("Check `%s`", input), new Object[0])).isInstanceOf(AtLiteralNode.class);
        input = "duration(\"P2DT20H14M\")";
        ((ObjectAssert)Assertions.assertThat((Object)this.rangeFunction.parse(input)).withFailMessage(String.format("Check `%s`", input), new Object[0])).isInstanceOf(FunctionInvocationNode.class);
    }

    @Test
    public void parse_emptyString() {
        ((ObjectAssert)Assertions.assertThat((Object)this.rangeFunction.parse("")).withFailMessage("Check ``", new Object[0])).isInstanceOf(NullNode.class);
    }

    @Test
    public void getNullNode() {
        Assertions.assertThat((Object)this.rangeFunction.getNullNode()).isInstanceOf(NullNode.class);
    }

    private NumberNode getNumberNode() {
        return (NumberNode)this.rangeFunction.parse("1");
    }

    private StringNode getStringNode() {
        return (StringNode)this.rangeFunction.parse("\"a\"");
    }

    private BooleanNode getBooleanNode() {
        return (BooleanNode)this.rangeFunction.parse("false");
    }

    private AtLiteralNode getAtLiteralNode() {
        return (AtLiteralNode)this.rangeFunction.parse("@\"2019-01-01\"");
    }

    private FunctionInvocationNode getFunctionInvocationNodeA() {
        return (FunctionInvocationNode)this.rangeFunction.parse("duration(\"P2DT20H14M\")");
    }

    private static Object[][] validFunctionInvocationNodeData() {
        return new Object[][]{{"string(1.1)", "1.1"}, {"replace( \"  foo   bar zed  \", \"^(\\s)+|(\\s)+$|\\s+(?=\\s)\", \"\" )", "foo bar zed"}, {"string(null)", null}, {"string(date(\"2016-08-14\"))", "2016-08-14"}, {"string(\"Happy %.0fth birthday, Mr %s!\", 38, \"Doe\")", "Happy 38th birthday, Mr Doe!"}, {"number(null, \",\", \".\")", null}, {"number(\"1,000.05\", \",\", \".\")", new BigDecimal("1000.05")}, {"number(\"1.000,05\", \".\", \",\")", new BigDecimal("1000.05")}, {"number(\"1000,05\", null, \",\")", new BigDecimal("1000.05")}, {"number(\"1,000.05e+12\", \",\", \".\")", new BigDecimal("1000.05e+12")}, {"number(\"1.000,05e+12\", \".\", \",\")", new BigDecimal("1000.05e+12")}, {"number(\"1000,05e+12\", null, \",\")", new BigDecimal("1000.05e+12")}, {"substring(\"foobar\", 3)", "obar"}, {"substring(\"foobar\", 3, 3)", "oba"}, {"substring(\"foobar\", -2, 1)", "a"}, {"substring(\"foobar\", -2, 5)", "ar"}, {"substring(\"foobar\", 15, 5)", null}, {"string length(\"foobar\")", BigDecimal.valueOf(6L)}, {"string length(null)", null}, {"upper case(\"aBc4\")", "ABC4"}, {"upper case(null)", null}, {"lower case(\"aBc4\")", "abc4"}, {"lower case(null)", null}, {"substring before( \"foobar\", \"bar\")", "foo"}, {"substring before( \"foobar\", \"xyz\")", ""}, {"substring before( \"foobar\", \"foo\")", ""}, {"substring after( \"foobar\", \"foo\")", "bar"}, {"substring after( \"foobar\", \"xyz\")", ""}, {"substring after( \"foobar\", \"bar\")", ""}, {"replace(\"banana\",\"a\",\"o\")", "bonono"}, {"replace(\"banana\",\"(an)+\", \"**\")", "b**a"}, {"replace(\"banana\",\"[aeiouy]\",\"[$0]\")", "b[a]n[a]n[a]"}, {"replace(\"0123456789\",\"(\\d{3})(\\d{3})(\\d{4})\",\"($1) $2-$3\")", "(012) 345-6789"}, {"count([1, 2, 3])", BigDecimal.valueOf(3L)}, {"count( 1, 2, 3 )", BigDecimal.valueOf(3L)}, {"min( \"a\", \"b\", \"c\" )", "a"}, {"min([ \"a\", \"b\", \"c\" ])", "a"}, {"max( 1, 2, 3 )", BigDecimal.valueOf(3L)}, {"max([ 1, 2, 3 ])", BigDecimal.valueOf(3L)}, {"max(duration(\"PT1H6M\"), duration(\"PT1H5M\"))", Duration.parse("PT1H6M")}, {"max(duration(\"P6Y\"), duration(\"P5Y\"))", ComparablePeriod.parse((CharSequence)"P6Y")}, {"sum( 1, 2, 3 )", BigDecimal.valueOf(6L)}, {"sum([ 1, 2, 3 ])", BigDecimal.valueOf(6L)}, {"sum([])", null}, {"product( 2, 3, 4 )", BigDecimal.valueOf(24L)}, {"product([ 2, 3, 4 ])", BigDecimal.valueOf(24L)}, {"product([])", null}, {"mean( 1, 2, 3 )", BigDecimal.valueOf(2L)}, {"mean([ 1, 2, 3 ])", BigDecimal.valueOf(2L)}, {"decimal( 1/3, 2 )", new BigDecimal("0.33")}, {"decimal( 1.5, 0 )", new BigDecimal("2")}, {"decimal( 2.5, 0 )", new BigDecimal("2")}, {"decimal( null, 0 )", null}, {"floor( 1.5 )", new BigDecimal("1")}, {"floor( -1.5 )", new BigDecimal("-2")}, {"floor( null )", null}, {"ceiling( 1.5 )", new BigDecimal("2")}, {"ceiling( -1.5 )", new BigDecimal("-1")}, {"ceiling( null )", null}, {"ceiling( n : 1.5 )", new BigDecimal("2")}, {"abs( 10 )", new BigDecimal("10")}, {"abs( -10 )", new BigDecimal("10")}, {"abs( n: -10 )", new BigDecimal("10")}, {"abs(@\"PT5H\")", Duration.parse("PT5H")}, {"abs(@\"-PT5H\")", Duration.parse("PT5H")}, {"abs(n: @\"-PT5H\")", Duration.parse("PT5H")}, {"abs(duration(\"P1Y\"))", ComparablePeriod.parse((CharSequence)"P1Y")}, {"abs(duration(\"-P1Y\"))", ComparablePeriod.parse((CharSequence)"P1Y")}, {"day of year( date(2019, 9, 17) )", BigDecimal.valueOf(260L)}, {"day of week( date(2019, 9, 17) )", "Tuesday"}, {"month of year( date(2019, 9, 17) )", "September"}, {"week of year( date(2019, 9, 17) )", BigDecimal.valueOf(38L)}, {"week of year( date(2003, 12, 29) )", BigDecimal.valueOf(1L)}, {"week of year( date(2004, 1, 4) )", BigDecimal.valueOf(1L)}, {"week of year( date(2005, 1, 3) )", BigDecimal.valueOf(1L)}, {"week of year( date(2005, 1, 9) )", BigDecimal.valueOf(1L)}, {"week of year( date(2005, 1, 1) )", BigDecimal.valueOf(53L)}, {"median( 8, 2, 5, 3, 4 )", new BigDecimal("4")}, {"median( [6, 1, 2, 3] )", new BigDecimal("2.5")}, {"median( [ ] ) ", null}};
    }

    private static Object[][] invalidFunctionInvocationNodeData() {
        return new Object[][]{{"contains(\"foobar\", \"ob\")", Boolean.TRUE}, {"contains(\"foobar\", \"of\")", Boolean.FALSE}, {"starts with(\"foobar\", \"of\")", Boolean.FALSE}, {"starts with(\"foobar\", \"fo\")", Boolean.TRUE}, {"ends with(\"foobar\", \"of\")", Boolean.FALSE}, {"ends with(\"foobar\", \"bar\")", Boolean.TRUE}, {"matches(\"foo\", \"[a-z]{3}\")", Boolean.TRUE}, {"matches(\"banana\", \"[a-z]{3}\")", Boolean.TRUE}, {"matches(\"two \\n lines\", \"two.*lines\")", Boolean.FALSE}, {"matches(\"two \\n lines\", \"two.*lines\", \"s\")", Boolean.TRUE}, {"matches(\"one\\ntwo\\nthree\", \"^two$\")", Boolean.FALSE}, {"matches(\"one\\ntwo\\nthree\", \"^two$\", \"m\")", Boolean.TRUE}, {"matches(\"FoO\", \"foo\")", Boolean.FALSE}, {"matches(\"FoO\", \"foo\", \"i\")", Boolean.TRUE}, {"list contains([1, 2, 3], 2)", Boolean.TRUE}, {"list contains([1, 2, 3], 5)", Boolean.FALSE}, {"sublist( [1, 2, 3, 4, 5 ], 3, 2 )", Arrays.asList(BigDecimal.valueOf(3L), BigDecimal.valueOf(4L))}, {"sublist( [1, 2, 3, 4, 5 ], -2, 1 )", Collections.singletonList(BigDecimal.valueOf(4L))}, {"sublist( [1, 2, 3, 4, 5 ], -5, 3 )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L))}, {"sublist( [1, 2, 3, 4, 5 ], 1, 3 )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L))}, {"append( [1, 2], 3, 4 )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L))}, {"append( [], 3, 4 )", Arrays.asList(BigDecimal.valueOf(3L), BigDecimal.valueOf(4L))}, {"append( [1, 2] )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L))}, {"append( [1, 2], null, 4 )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), null, BigDecimal.valueOf(4L))}, {"append( 0, 1, 2 )", Arrays.asList(BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(2L))}, {"concatenate( [1, 2], [3] )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L))}, {"concatenate( [1, 2], 3, [4] )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L))}, {"insert before( [1, 2, 3], 1, 4 )", Arrays.asList(BigDecimal.valueOf(4L), BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L))}, {"insert before( [1, 2, 3], 3, 4 )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(4L), BigDecimal.valueOf(3L))}, {"insert before( [1, 2, 3], 3, null )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), null, BigDecimal.valueOf(3L))}, {"insert before( [1, 2, 3], -3, 4 )", Arrays.asList(BigDecimal.valueOf(4L), BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L))}, {"insert before( [1, 2, 3], -1, 4 )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(4L), BigDecimal.valueOf(3L))}, {"remove( [1, 2, 3], 1 )", Arrays.asList(BigDecimal.valueOf(2L), BigDecimal.valueOf(3L))}, {"remove( [1, 2, 3], 3 )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L))}, {"remove( [1, 2, 3], -1 )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L))}, {"remove( [1, 2, 3], -3 )", Arrays.asList(BigDecimal.valueOf(2L), BigDecimal.valueOf(3L))}, {"reverse( [1, 2, 3] )", Arrays.asList(BigDecimal.valueOf(3L), BigDecimal.valueOf(2L), BigDecimal.valueOf(1L))}, {"index of( [1, 2, 3, 2], 2 )", Arrays.asList(BigDecimal.valueOf(2L), BigDecimal.valueOf(4L))}, {"index of( [1, 2, null, null], null )", Arrays.asList(BigDecimal.valueOf(3L), BigDecimal.valueOf(4L))}, {"index of( [1, 2, null, null], 1 )", Collections.singletonList(BigDecimal.valueOf(1L))}, {"union( [1, 2, 1], [2, 3], 2, 4 )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L))}, {"union( [1, 2, null], 4 )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), null, BigDecimal.valueOf(4L))}, {"union( null, 4 )", Arrays.asList(null, BigDecimal.valueOf(4L))}, {"distinct values( [1, 2, 3, 2, 4] )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L))}, {"distinct values( [1, 2, null, 2, 4] )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), null, BigDecimal.valueOf(4L))}, {"distinct values( 1 )", Collections.singletonList(BigDecimal.valueOf(1L))}, {"sort( [3, 1, 4, 5, 2], function(x,y) x < y )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L), BigDecimal.valueOf(5L))}, {"sort( [3, 1, 4, 5, 2] )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L), BigDecimal.valueOf(5L))}, {"sort( list : [3, 1, 4, 5, 2] )", Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L), BigDecimal.valueOf(5L))}, {"sort( [\"c\", \"e\", \"d\", \"a\", \"b\"], function(x,y) x < y )", Arrays.asList("a", "b", "c", "d", "e")}, {"sort( list : [\"c\", \"e\", \"d\", \"a\", \"b\"], precedes : function(x,y) x < y )", Arrays.asList("a", "b", "c", "d", "e")}, {"sort( precedes : function(x,y) x < y, list : [\"c\", \"e\", \"d\", \"a\", \"b\"] )", Arrays.asList("a", "b", "c", "d", "e")}, {"all( true )", true}, {"all( false )", false}, {"all( [true] )", true}, {"all( [false] )", false}, {"all( true, false )", false}, {"all( true, true )", true}, {"all( [true, false] )", false}, {"all( [true, true] )", true}, {"all( [false,null,true] )", false}, {"all( [] )", true}, {"any( true )", true}, {"any( false )", false}, {"any( [true] )", true}, {"any( [false] )", false}, {"any( true, false )", true}, {"any( true, true )", true}, {"any( [true, false] )", true}, {"any( [true, true] )", true}, {"any( [false,null,true] )", true}, {"any( [] )", false}};
    }
}

