/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAccessor;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.DateFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class DateFunctionTest {
    private DateFunction dateFunction;

    @Before
    public void setUp() {
        this.dateFunction = new DateFunction();
    }

    @Test
    public void invokeParamStringNull() {
        FunctionTestUtil.assertResultError(this.dateFunction.invoke((String)null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamStringNotDateOrTime() {
        FunctionTestUtil.assertResultError(this.dateFunction.invoke("test"), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateFunction.invoke("2017-09-test"), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateFunction.invoke("2017-09-89"), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamStringDate() {
        FunctionTestUtil.assertResult(this.dateFunction.invoke("2017-09-07"), LocalDate.of(2017, 9, 7), new String[0]);
    }

    @Test
    public void invokeParamStringPaddingYearsDate() {
        FunctionTestUtil.assertResult(this.dateFunction.invoke("0001-12-31"), LocalDate.of(1, 12, 31), new String[0]);
        FunctionTestUtil.assertResult(this.dateFunction.invoke("0012-12-31"), LocalDate.of(12, 12, 31), new String[0]);
        FunctionTestUtil.assertResult(this.dateFunction.invoke("0123-12-31"), LocalDate.of(123, 12, 31), new String[0]);
        FunctionTestUtil.assertResult(this.dateFunction.invoke("1234-12-31"), LocalDate.of(1234, 12, 31), new String[0]);
        FunctionTestUtil.assertResultError(this.dateFunction.invoke("01211-12-31"), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateFunction.invoke("012117-12-31"), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateFunction.invoke("001211-12-31"), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamYearMonthDayNulls() {
        FunctionTestUtil.assertResultError(this.dateFunction.invoke(null, null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateFunction.invoke((Number)10, null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateFunction.invoke(null, (Number)10, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateFunction.invoke(null, null, (Number)10), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateFunction.invoke((Number)10, (Number)10, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateFunction.invoke((Number)10, null, (Number)10), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateFunction.invoke(null, (Number)10, (Number)10), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamYearMonthDayInvalidDate() {
        FunctionTestUtil.assertResultError(this.dateFunction.invoke((Number)2017, (Number)6, (Number)59), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateFunction.invoke((Number)2017, (Number)59, (Number)12), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateFunction.invoke((Number)Integer.MAX_VALUE, (Number)6, (Number)12), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamYearMonthDay() {
        FunctionTestUtil.assertResult(this.dateFunction.invoke((Number)2017, (Number)6, (Number)12), LocalDate.of(2017, 6, 12), new String[0]);
    }

    @Test
    public void invokeParamTemporalNull() {
        FunctionTestUtil.assertResultError(this.dateFunction.invoke((TemporalAccessor)null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamTemporalWrongTemporal() {
        FunctionTestUtil.assertResultError(this.dateFunction.invoke((TemporalAccessor)DayOfWeek.MONDAY), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamTemporal() {
        FunctionTestUtil.assertResult(this.dateFunction.invoke((TemporalAccessor)LocalDate.of(2017, 6, 12)), LocalDate.of(2017, 6, 12), new String[0]);
    }
}

