/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.NumberFunction;

public class NumberFunctionTest {
    private NumberFunction numberFunction;

    @Before
    public void setUp() {
        this.numberFunction = new NumberFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultError(this.numberFunction.invoke(null, null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.numberFunction.invoke(null, " ", null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.numberFunction.invoke(null, null, "."), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.numberFunction.invoke(null, " ", "."), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeIllegalNumber() {
        FunctionTestUtil.assertResultError(this.numberFunction.invoke("test", null, null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeNumberWithLeadingZeros() {
        FunctionTestUtil.assertResult(this.numberFunction.invoke("009876", null, null), BigDecimal.valueOf(9876L), new String[0]);
    }

    @Test
    public void invokeNumberWithoutDecimalPart() {
        FunctionTestUtil.assertResult(this.numberFunction.invoke("9876", null, null), BigDecimal.valueOf(9876L), new String[0]);
    }

    @Test
    public void invokeNumberWithGroupCharSpace() {
        FunctionTestUtil.assertResult(this.numberFunction.invoke("9 876", " ", null), BigDecimal.valueOf(9876L), new String[0]);
        FunctionTestUtil.assertResult(this.numberFunction.invoke("9 876 000", " ", null), BigDecimal.valueOf(9876000L), new String[0]);
    }

    @Test
    public void invokeNumberWithGroupCharComma() {
        FunctionTestUtil.assertResult(this.numberFunction.invoke("9,876", ",", null), BigDecimal.valueOf(9876L), new String[0]);
        FunctionTestUtil.assertResult(this.numberFunction.invoke("9,876,000", ",", null), BigDecimal.valueOf(9876000L), new String[0]);
    }

    @Test
    public void invokeNumberWithGroupCharDot() {
        FunctionTestUtil.assertResult(this.numberFunction.invoke("9.876", ".", null), BigDecimal.valueOf(9876L), new String[0]);
        FunctionTestUtil.assertResult(this.numberFunction.invoke("9.876.000", ".", null), BigDecimal.valueOf(9876000L), new String[0]);
    }

    @Test
    public void invokeNumberWithDecimalCharComma() {
        FunctionTestUtil.assertResult(this.numberFunction.invoke("9,876", null, ","), BigDecimal.valueOf(9.876), new String[0]);
    }

    @Test
    public void invokeNumberWithDecimalCharDot() {
        FunctionTestUtil.assertResult(this.numberFunction.invoke("9.876", null, "."), BigDecimal.valueOf(9.876), new String[0]);
    }

    @Test
    public void invokeNumberWithGroupAndDecimalChar() {
        FunctionTestUtil.assertResult(this.numberFunction.invoke("9 876.124", " ", "."), BigDecimal.valueOf(9876.124), new String[0]);
        FunctionTestUtil.assertResult(this.numberFunction.invoke("9 876 000.124", " ", "."), BigDecimal.valueOf(9876000.124), new String[0]);
        FunctionTestUtil.assertResult(this.numberFunction.invoke("9.876.000,124", ".", ","), BigDecimal.valueOf(9876000.124), new String[0]);
    }

    @Test
    public void invokeIncorrectGroup() {
        FunctionTestUtil.assertResultError(this.numberFunction.invoke("1 000", ".", null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeInvalidGroup() {
        FunctionTestUtil.assertResultError(this.numberFunction.invoke("1 000", "test", null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeEmptyGroup() {
        FunctionTestUtil.assertResultError(this.numberFunction.invoke("1 000", "", null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeIncorrectDecimal() {
        FunctionTestUtil.assertResultError(this.numberFunction.invoke("1,1", null, "."), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeInvalidDecimal() {
        FunctionTestUtil.assertResultError(this.numberFunction.invoke("1.1", null, "test"), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeEmptyDecimal() {
        FunctionTestUtil.assertResultError(this.numberFunction.invoke("1.1", null, ""), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeGroupEqualsDecimal() {
        FunctionTestUtil.assertResultError(this.numberFunction.invoke("1 000.1", ".", "."), InvalidParametersEvent.class, new String[0]);
    }
}

