/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.ReplaceFunction;

public class ReplaceFunctionTest {
    private ReplaceFunction replaceFunction;

    @Before
    public void setUp() {
        this.replaceFunction = new ReplaceFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke(null, null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke("testString", null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke("testString", "test", null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke(null, "test", null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke(null, "test", "ttt"), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke(null, null, "ttt"), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeNullWithFlags() {
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke(null, null, null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke("testString", null, null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke("testString", "test", null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke(null, "test", null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke(null, "test", "ttt", null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke(null, null, "ttt", null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke(null, null, null, "s"), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke("testString", null, null, "s"), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke("testString", "test", null, "s"), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke(null, "test", null, "s"), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke(null, "test", "ttt", "s"), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.replaceFunction.invoke(null, null, "ttt", "s"), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeWithoutFlagsPatternMatches() {
        FunctionTestUtil.assertResult(this.replaceFunction.invoke("testString", "^test", "ttt"), "tttString", new String[0]);
        FunctionTestUtil.assertResult(this.replaceFunction.invoke("testStringtest", "^test", "ttt"), "tttStringtest", new String[0]);
    }

    @Test
    public void invokeWithoutFlagsPatternNotMatches() {
        FunctionTestUtil.assertResult(this.replaceFunction.invoke("testString", "ttest", "ttt"), "testString", new String[0]);
        FunctionTestUtil.assertResult(this.replaceFunction.invoke("testString", "$test", "ttt"), "testString", new String[0]);
    }

    @Test
    public void invokeWithFlagDotAll() {
        FunctionTestUtil.assertResult(this.replaceFunction.invoke("fo\nbar", "o.b", "ttt", "s"), "ftttar", new String[0]);
    }

    @Test
    public void invokeWithFlagMultiline() {
        FunctionTestUtil.assertResult(this.replaceFunction.invoke("foo\nbar", "^b", "ttt", "m"), "foo\ntttar", new String[0]);
    }

    @Test
    public void invokeWithFlagCaseInsensitive() {
        FunctionTestUtil.assertResult(this.replaceFunction.invoke("foobar", "^fOO", "ttt", "i"), "tttbar", new String[0]);
    }

    @Test
    public void invokeWithAllFlags() {
        FunctionTestUtil.assertResult(this.replaceFunction.invoke("fo\nbar", "O.^b", "ttt", "smi"), "ftttar", new String[0]);
    }
}

