/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.SubstringFunction;

public class SubstringFunctionTest {
    private SubstringFunction substringFunction;

    @Before
    public void setUp() {
        this.substringFunction = new SubstringFunction();
    }

    @Test
    public void invokeNull2ParamsMethod() {
        FunctionTestUtil.assertResultError(this.substringFunction.invoke((String)null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.substringFunction.invoke("test", null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.substringFunction.invoke(null, (Number)0), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeNull3ParamsMethod() {
        FunctionTestUtil.assertResultError(this.substringFunction.invoke(null, null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.substringFunction.invoke("test", null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.substringFunction.invoke("test", null, (Number)2), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.substringFunction.invoke(null, (Number)0, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.substringFunction.invoke(null, null, (Number)2), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.substringFunction.invoke(null, (Number)0, (Number)2), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeStartZero() {
        FunctionTestUtil.assertResultError(this.substringFunction.invoke("test", (Number)0), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.substringFunction.invoke("test", (Number)0, null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeStartOutOfListBounds() {
        FunctionTestUtil.assertResultError(this.substringFunction.invoke("test", (Number)10), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.substringFunction.invoke("test", (Number)10, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.substringFunction.invoke("test", (Number)-10), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.substringFunction.invoke("test", (Number)-10, null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeLengthNegative() {
        FunctionTestUtil.assertResultError(this.substringFunction.invoke("test", (Number)1, (Number)-3), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeLengthOutOfListBounds() {
        FunctionTestUtil.assertResult(this.substringFunction.invoke("test", (Number)2, (Number)3), "est", new String[0]);
        FunctionTestUtil.assertResult(this.substringFunction.invoke("test", (Number)-3, (Number)3), "est", new String[0]);
    }

    @Test
    public void invokeStartPositive() {
        FunctionTestUtil.assertResult(this.substringFunction.invoke("test", (Number)1), "test", new String[0]);
        FunctionTestUtil.assertResult(this.substringFunction.invoke("test", (Number)2), "est", new String[0]);
        FunctionTestUtil.assertResult(this.substringFunction.invoke("test", (Number)4), "t", new String[0]);
        FunctionTestUtil.assertResult(this.substringFunction.invoke("test", (Number)2, (Number)1), "e", new String[0]);
        FunctionTestUtil.assertResult(this.substringFunction.invoke("test", (Number)2, (Number)2), "es", new String[0]);
    }

    @Test
    public void invokeStartNegative() {
        FunctionTestUtil.assertResult(this.substringFunction.invoke("test", (Number)-1), "t", new String[0]);
        FunctionTestUtil.assertResult(this.substringFunction.invoke("test", (Number)-2), "st", new String[0]);
        FunctionTestUtil.assertResult(this.substringFunction.invoke("test", (Number)-4), "test", new String[0]);
        FunctionTestUtil.assertResult(this.substringFunction.invoke("test", (Number)-2, (Number)1), "s", new String[0]);
        FunctionTestUtil.assertResult(this.substringFunction.invoke("test", (Number)-3, (Number)2), "es", new String[0]);
    }
}

