/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import ch.obermuhlner.math.big.BigDecimalMath;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.Duration;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.InfixOpNode;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class InfixOpNodeTest {
    private static List<BinaryOperator<BigDecimal>> MATH_OPERATORS;

    @Before
    public void setUp() throws Exception {
        MATH_OPERATORS = new ArrayList<BinaryOperator<BigDecimal>>();
        MATH_OPERATORS.add((l, r) -> l.add((BigDecimal)r, MathContext.DECIMAL128));
        MATH_OPERATORS.add((l, r) -> l.subtract((BigDecimal)r, MathContext.DECIMAL128));
        MATH_OPERATORS.add((l, r) -> l.multiply((BigDecimal)r, MathContext.DECIMAL128));
        MATH_OPERATORS.add((l, r) -> l.divide((BigDecimal)r, MathContext.DECIMAL128));
        MATH_OPERATORS.add((l, r) -> BigDecimalMath.pow((BigDecimal)l, (BigDecimal)r, (MathContext)MathContext.DECIMAL128));
    }

    @Test
    public void math_BothNumbers() {
        Random rnd = new Random();
        MATH_OPERATORS.forEach(operator -> {
            BigDecimal left = BigDecimal.valueOf(rnd.nextDouble());
            BigDecimal right = BigDecimal.valueOf(rnd.nextDouble());
            BigDecimal expected = (BigDecimal)operator.apply(left, right);
            Object retrieved = InfixOpNode.math((Object)left, (Object)right, null, (BinaryOperator)operator);
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)retrieved).isNotNull()).isInstanceOf(BigDecimal.class)).isEqualTo((Object)expected);
        });
    }

    @Test
    public void math_NumberAndString() {
        Random rnd = new Random();
        MATH_OPERATORS.forEach(operator -> {
            BigDecimal left = BigDecimal.valueOf(rnd.nextDouble());
            String right = String.valueOf(rnd.nextDouble());
            Object retrieved = InfixOpNode.math((Object)left, (Object)right, null, (BinaryOperator)operator);
            Assertions.assertThat((Object)retrieved).isNull();
        });
    }

    @Test
    public void addLocalDateAndDuration() {
        LocalDate left = LocalDate.of(2021, 1, 1);
        Duration right = Duration.of(-1L, ChronoUnit.HOURS);
        LocalDate retrieved = (LocalDate)InfixOpNode.add((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2020, 12, 31));
        right = Duration.of(-24L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.add((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2020, 12, 31));
        right = Duration.of(-25L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.add((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2020, 12, 30));
        right = Duration.of(1L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.add((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2021, 1, 1));
        left = LocalDate.of(2021, 1, 2);
        right = Duration.of(1L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.add((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2021, 1, 2));
        right = Duration.of(24L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.add((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2021, 1, 3));
        right = Duration.of(25L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.add((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2021, 1, 3));
        left = LocalDate.of(2021, 1, 3);
        right = Duration.of(25L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.add((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2021, 1, 4));
        left = LocalDate.of(2020, 12, 30);
        right = Duration.of(-25L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.add((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2020, 12, 28));
        left = LocalDate.of(2020, 12, 31);
        right = Duration.of(-1L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.add((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2020, 12, 30));
    }

    @Test
    public void subLocalDateAndDuration() {
        LocalDate left = LocalDate.of(2021, 1, 1);
        Duration right = Duration.of(-1L, ChronoUnit.HOURS);
        LocalDate retrieved = (LocalDate)InfixOpNode.sub((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2021, 1, 1));
        right = Duration.of(-24L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.sub((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2021, 1, 2));
        right = Duration.of(-25L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.sub((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2021, 1, 2));
        right = Duration.of(1L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.sub((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2020, 12, 31));
        left = LocalDate.of(2021, 1, 2);
        right = Duration.of(1L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.sub((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2021, 1, 1));
        right = Duration.of(24L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.sub((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2021, 1, 1));
        right = Duration.of(25L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.sub((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2020, 12, 31));
        left = LocalDate.of(2021, 1, 3);
        right = Duration.of(25L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.sub((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2021, 1, 1));
        left = LocalDate.of(2020, 12, 30);
        right = Duration.of(-25L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.sub((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2020, 12, 31));
        left = LocalDate.of(2020, 12, 31);
        right = Duration.of(-1L, ChronoUnit.HOURS);
        retrieved = (LocalDate)InfixOpNode.sub((Object)left, (Object)right, null);
        Assertions.assertThat((LocalDate)retrieved).isEqualTo((Object)LocalDate.of(2020, 12, 31));
    }

    @Test
    public void mulDurationAndDuration() {
        Duration left = Duration.of(5L, ChronoUnit.DAYS);
        Duration right = Duration.of(5L, ChronoUnit.DAYS);
        Assertions.assertThat((Object)InfixOpNode.mult((Object)left, (Object)right, (EvaluationContext)((EvaluationContext)Mockito.mock(EvaluationContext.class)))).isNull();
    }

    @Test
    public void isAllowedMultiplicationBasedOnSpec() {
        EvaluationContext evaluationContext = (EvaluationContext)Mockito.mock(EvaluationContext.class);
        Comparable<Integer> left = 23;
        Comparable<Double> right = 354.5;
        Assertions.assertThat((boolean)InfixOpNode.isAllowedMultiplicationBasedOnSpec((Object)left, (Object)right, (EvaluationContext)evaluationContext)).isTrue();
        ((EvaluationContext)Mockito.verify((Object)evaluationContext, (VerificationMode)Mockito.never())).notifyEvt((Supplier)ArgumentMatchers.any());
        right = Duration.of(5L, ChronoUnit.DAYS);
        Assertions.assertThat((boolean)InfixOpNode.isAllowedMultiplicationBasedOnSpec((Object)left, (Object)right, (EvaluationContext)evaluationContext)).isTrue();
        ((EvaluationContext)Mockito.verify((Object)evaluationContext, (VerificationMode)Mockito.never())).notifyEvt((Supplier)ArgumentMatchers.any());
        left = Duration.of(5L, ChronoUnit.DAYS);
        right = 354.5;
        Assertions.assertThat((boolean)InfixOpNode.isAllowedMultiplicationBasedOnSpec((Object)left, (Object)right, (EvaluationContext)evaluationContext)).isTrue();
        ((EvaluationContext)Mockito.verify((Object)evaluationContext, (VerificationMode)Mockito.never())).notifyEvt((Supplier)ArgumentMatchers.any());
        left = Duration.of(5L, ChronoUnit.DAYS);
        right = Duration.of(5L, ChronoUnit.DAYS);
        Assertions.assertThat((boolean)InfixOpNode.isAllowedMultiplicationBasedOnSpec((Object)left, (Object)right, (EvaluationContext)evaluationContext)).isFalse();
        ((EvaluationContext)Mockito.verify((Object)evaluationContext, (VerificationMode)Mockito.times((int)1))).notifyEvt((Supplier)ArgumentMatchers.any(Supplier.class));
    }
}

