/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Period;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.AbsFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class AbsFunctionTest {
    private AbsFunction absFunction;

    @Before
    public void setUp() {
        this.absFunction = AbsFunction.INSTANCE;
    }

    @Test
    public void testAbsFunctionNumber() {
        FunctionTestUtil.assertResult(this.absFunction.invoke(BigDecimal.valueOf(10L)), BigDecimal.valueOf(10L), new String[0]);
        FunctionTestUtil.assertResult(this.absFunction.invoke(BigDecimal.valueOf(-10L)), BigDecimal.valueOf(10L), new String[0]);
        FunctionTestUtil.assertResultError(this.absFunction.invoke((BigDecimal)null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void testAbsFunctionDuration() {
        FunctionTestUtil.assertResult(this.absFunction.invoke(Duration.ofSeconds(100L, 50L)), Duration.ofSeconds(100L, 50L), new String[0]);
        FunctionTestUtil.assertResult(this.absFunction.invoke(Duration.ofSeconds(-100L, 50L)), Duration.ofSeconds(100L, -50L), new String[0]);
        FunctionTestUtil.assertResult(this.absFunction.invoke(Duration.ofSeconds(100L, -50L)), Duration.ofSeconds(100L, -50L), new String[0]);
        FunctionTestUtil.assertResult(this.absFunction.invoke(Duration.ofSeconds(-100L, -50L)), Duration.ofSeconds(100L, 50L), new String[0]);
        FunctionTestUtil.assertResultError(this.absFunction.invoke((Duration)null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void testAbsFunctionPeriod() {
        FunctionTestUtil.assertResult(this.absFunction.invoke(Period.of(100, 50, 0)), Period.of(100, 50, 0), new String[0]);
        FunctionTestUtil.assertResult(this.absFunction.invoke(Period.of(-100, 50, 0)), Period.of(100, -50, 0), new String[0]);
        FunctionTestUtil.assertResult(this.absFunction.invoke(Period.of(100, -50, 0)), Period.of(100, -50, 0), new String[0]);
        FunctionTestUtil.assertResult(this.absFunction.invoke(Period.of(-100, -50, 0)), Period.of(100, 50, 0), new String[0]);
        FunctionTestUtil.assertResult(this.absFunction.invoke(Period.of(-1, 30, 0)), Period.of(-1, 30, 0), new String[0]);
        FunctionTestUtil.assertResultError(this.absFunction.invoke((Period)null), InvalidParametersEvent.class, new String[0]);
    }
}

