/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.UnionFunction;

public class UnionFunctionTest {
    private UnionFunction unionFunction;

    @Before
    public void setUp() {
        this.unionFunction = new UnionFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultError(this.unionFunction.invoke(null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeEmptyArray() {
        FunctionTestUtil.assertResultList(this.unionFunction.invoke(new Object[0]), Collections.emptyList());
    }

    @Test
    public void invokeSingleObject() {
        FunctionTestUtil.assertResult(this.unionFunction.invoke(new Object[]{10}), Collections.singletonList(10), new String[0]);
    }

    @Test
    public void invokeSingleObjectInAList() {
        FunctionTestUtil.assertResult(this.unionFunction.invoke(new Object[]{Collections.singletonList(10)}), Collections.singletonList(10), new String[0]);
    }

    @Test
    public void invokeSingleObjectInAnArray() {
        int[] testArray = new int[]{10};
        FunctionTestUtil.assertResult(this.unionFunction.invoke(new Object[]{testArray}), Collections.singletonList(testArray), new String[0]);
    }

    @Test
    public void invokeListIsNull() {
        FunctionTestUtil.assertResult(this.unionFunction.invoke(new Object[]{null}), Collections.singletonList(null), new String[0]);
    }

    @Test
    public void invokeListContainsNull() {
        FunctionTestUtil.assertResult(this.unionFunction.invoke(new Object[]{Arrays.asList(null, 10, null)}), Arrays.asList(null, 10), new String[0]);
    }

    @Test
    public void invokeListsNoDuplicates() {
        Object[] params = new Object[]{Arrays.asList(10, 8, 3), Arrays.asList(1, 15, 2)};
        FunctionTestUtil.assertResultList(this.unionFunction.invoke(params), Arrays.asList(10, 8, 3, 1, 15, 2));
    }

    @Test
    public void invokeListsSomeDuplicates() {
        Object[] params = new Object[]{Arrays.asList(10, 8, 3), Arrays.asList(1, 10, 2), Arrays.asList(10, 3, 2, 5)};
        FunctionTestUtil.assertResultList(this.unionFunction.invoke(params), Arrays.asList(10, 8, 3, 1, 2, 5));
    }

    @Test
    public void invokeListsAllDuplicates() {
        Object[] params = new Object[]{Arrays.asList(10, 8, 3), Arrays.asList(10, 8, 3), Arrays.asList(3, 10, 8)};
        FunctionTestUtil.assertResultList(this.unionFunction.invoke(params), Arrays.asList(10, 8, 3));
    }

    @Test
    public void invokeListAndSingleObject() {
        FunctionTestUtil.assertResultList(this.unionFunction.invoke(new Object[]{Arrays.asList(10, 4, 5), 1}), Arrays.asList(10, 4, 5, 1));
    }

    @Test
    public void invokeListAndSingleObjectWithDuplicates() {
        FunctionTestUtil.assertResultList(this.unionFunction.invoke(new Object[]{5, Arrays.asList(10, 4, 5), 10}), Arrays.asList(5, 10, 4));
    }

    @Test
    public void invokeMixedTypes() {
        FunctionTestUtil.assertResultList(this.unionFunction.invoke(new Object[]{"test", Arrays.asList(10, "test", 5), BigDecimal.TEN}), Arrays.asList("test", 10, 5, BigDecimal.TEN));
    }
}

