/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.AllFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class AllFunctionTest {
    private AllFunction allFunction;

    @Before
    public void setUp() {
        this.allFunction = new AllFunction();
    }

    @Test
    public void invokeBooleanParamNull() {
        FunctionTestUtil.assertResultNull(this.allFunction.invoke((Boolean)null), new String[0]);
    }

    @Test
    public void invokeBooleanParamTrue() {
        FunctionTestUtil.assertResult(this.allFunction.invoke(Boolean.valueOf(true)), true, new String[0]);
    }

    @Test
    public void invokeBooleanParamFalse() {
        FunctionTestUtil.assertResult(this.allFunction.invoke(Boolean.valueOf(false)), false, new String[0]);
    }

    @Test
    public void invokeArrayParamNull() {
        FunctionTestUtil.assertResultError(this.allFunction.invoke((Object[])null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeArrayParamEmptyArray() {
        FunctionTestUtil.assertResult(this.allFunction.invoke(new Object[0]), true, new String[0]);
    }

    @Test
    public void invokeArrayParamReturnTrue() {
        FunctionTestUtil.assertResult(this.allFunction.invoke(new Object[]{Boolean.TRUE, Boolean.TRUE}), true, new String[0]);
    }

    @Test
    public void invokeArrayParamReturnFalse() {
        FunctionTestUtil.assertResult(this.allFunction.invoke(new Object[]{Boolean.TRUE, Boolean.FALSE}), false, new String[0]);
        FunctionTestUtil.assertResult(this.allFunction.invoke(new Object[]{Boolean.TRUE, null, Boolean.FALSE}), false, new String[0]);
    }

    @Test
    public void invokeArrayParamReturnNull() {
        FunctionTestUtil.assertResultNull(this.allFunction.invoke(new Object[]{Boolean.TRUE, null, Boolean.TRUE}), new String[0]);
    }

    @Test
    public void invokeArrayParamTypeHeterogenousArray() {
        FunctionTestUtil.assertResultError(this.allFunction.invoke(new Object[]{Boolean.TRUE, 1}), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.allFunction.invoke(new Object[]{Boolean.FALSE, 1}), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.allFunction.invoke(new Object[]{Boolean.TRUE, null, 1}), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeListParamNull() {
        FunctionTestUtil.assertResultError(this.allFunction.invoke((List)null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeListParamEmptyList() {
        FunctionTestUtil.assertResult(this.allFunction.invoke(Collections.emptyList()), true, new String[0]);
    }

    @Test
    public void invokeListParamReturnTrue() {
        FunctionTestUtil.assertResult(this.allFunction.invoke(Arrays.asList(Boolean.TRUE, Boolean.TRUE)), true, new String[0]);
    }

    @Test
    public void invokeListParamReturnFalse() {
        FunctionTestUtil.assertResult(this.allFunction.invoke(Arrays.asList(Boolean.TRUE, Boolean.FALSE)), false, new String[0]);
        FunctionTestUtil.assertResult(this.allFunction.invoke(Arrays.asList(Boolean.TRUE, null, Boolean.FALSE)), false, new String[0]);
    }

    @Test
    public void invokeListParamReturnNull() {
        FunctionTestUtil.assertResultNull(this.allFunction.invoke(Arrays.asList(Boolean.TRUE, null, Boolean.TRUE)), new String[0]);
    }

    @Test
    public void invokeListParamTypeHeterogenousArray() {
        FunctionTestUtil.assertResultError(this.allFunction.invoke(Arrays.asList(Boolean.TRUE, 1)), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.allFunction.invoke(Arrays.asList(Boolean.FALSE, 1)), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.allFunction.invoke(Arrays.asList(Boolean.TRUE, null, 1)), InvalidParametersEvent.class, new String[0]);
    }
}

