/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.NotFunction;

public class NotFunctionTest {
    private NotFunction notFunction;

    @Before
    public void setUp() {
        this.notFunction = new NotFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultNull(this.notFunction.invoke(null), new String[0]);
    }

    @Test
    public void invokeWrongType() {
        FunctionTestUtil.assertResultError(this.notFunction.invoke((Object)1), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.notFunction.invoke((Object)"test"), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.notFunction.invoke((Object)BigDecimal.ZERO), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeTrue() {
        FunctionTestUtil.assertResult(this.notFunction.invoke((Object)true), false, new String[0]);
    }

    @Test
    public void invokeFalse() {
        FunctionTestUtil.assertResult(this.notFunction.invoke((Object)false), true, new String[0]);
    }
}

