/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.FloorFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class FloorFunctionTest {
    private FloorFunction floorFunction;

    @Before
    public void setUp() {
        this.floorFunction = new FloorFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultError(this.floorFunction.invoke(null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeZero() {
        FunctionTestUtil.assertResultBigDecimal((FEELFnResult<BigDecimal>)this.floorFunction.invoke(BigDecimal.ZERO), BigDecimal.ZERO);
    }

    @Test
    public void invokePositive() {
        FunctionTestUtil.assertResultBigDecimal((FEELFnResult<BigDecimal>)this.floorFunction.invoke(BigDecimal.valueOf(10.2)), BigDecimal.valueOf(10L));
    }

    @Test
    public void invokeNegative() {
        FunctionTestUtil.assertResultBigDecimal((FEELFnResult<BigDecimal>)this.floorFunction.invoke(BigDecimal.valueOf(-10.2)), BigDecimal.valueOf(-11L));
    }
}

