/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.interval;

import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.interval.MetByFunction;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

public class MetByFunctionTest {
    private MetByFunction metByFunction;

    @Before
    public void setUp() {
        this.metByFunction = MetByFunction.INSTANCE;
    }

    @Test
    public void invokeParamIsNull() {
        FunctionTestUtil.assertResultError(this.metByFunction.invoke(null, (Range)new RangeImpl()), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.metByFunction.invoke((Range)new RangeImpl(), null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamsCantBeCompared() {
        FunctionTestUtil.assertResultError(this.metByFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), Range.RangeBoundary.CLOSED)), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamRangeAndRange() {
        FunctionTestUtil.assertResult(this.metByFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.metByFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"c"), (Comparable)((Object)"k"), Range.RangeBoundary.CLOSED)), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.metByFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"f"), (Comparable)((Object)"k"), Range.RangeBoundary.CLOSED)), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.metByFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)((Object)"g"), (Comparable)((Object)"k"), Range.RangeBoundary.CLOSED)), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.metByFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"f"), (Comparable)((Object)"k"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.TRUE, new String[0]);
    }
}

