/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.codegen.feel11;

import com.github.javaparser.ast.expr.Expression;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.feel.codegen.feel11.ASTCompilerVisitor;
import org.kie.dmn.feel.codegen.feel11.CodegenTestUtil;
import org.kie.dmn.feel.codegen.feel11.CompiledCustomFEELFunction;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELExpression;
import org.kie.dmn.feel.codegen.feel11.CompilerBytecodeLoader;
import org.kie.dmn.feel.codegen.feel11.DirectCompilerResult;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.FEELProperty;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.Visitor;
import org.kie.dmn.feel.lang.impl.JavaBackedType;
import org.kie.dmn.feel.lang.impl.MapBackedType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.parser.feel11.ASTBuilderVisitor;
import org.kie.dmn.feel.parser.feel11.FEELParser;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Parser;
import org.kie.dmn.feel.util.DynamicTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectCompilerTest {
    public static final Logger LOG = LoggerFactory.getLogger(DirectCompilerTest.class);

    private Object parseCompileEvaluate(String feelLiteralExpression) {
        CompiledFEELExpression compiledExpression = this.parse(feelLiteralExpression);
        LOG.debug("{}", (Object)compiledExpression);
        EvaluationContext emptyContext = CodegenTestUtil.newEmptyEvaluationContext();
        Object result = compiledExpression.apply((Object)emptyContext);
        LOG.debug("{}", result);
        return result;
    }

    @Test
    public void test_FEEL_number() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("10")).isEqualTo((Object)BigDecimal.valueOf(10L));
    }

    @Test
    public void test_FEEL_negative_number() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("-10")).isEqualTo((Object)BigDecimal.valueOf(-10L));
    }

    @Test
    public void test_FEEL_DROOLS_2143() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("--10")).isEqualTo((Object)BigDecimal.valueOf(10L));
        Assertions.assertThat((Object)this.parseCompileEvaluate("---10")).isEqualTo((Object)BigDecimal.valueOf(-10L));
        Assertions.assertThat((Object)this.parseCompileEvaluate("+10")).isEqualTo((Object)BigDecimal.valueOf(10L));
    }

    @Test
    public void test_FEEL_boolean() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("false")).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("true")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("null")).isNull();
    }

    @Test
    public void test_FEEL_null() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("null")).isNull();
    }

    @Test
    public void test_FEEL_string() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("\"some string\"")).isEqualTo((Object)"some string");
    }

    @Test
    public void test_primary_parens() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("(\"some string\")")).isEqualTo((Object)"some string");
        Assertions.assertThat((Object)this.parseCompileEvaluate("(123)")).isEqualTo((Object)BigDecimal.valueOf(123L));
        Assertions.assertThat((Object)this.parseCompileEvaluate("(-123)")).isEqualTo((Object)BigDecimal.valueOf(-123L));
        Assertions.assertThat((Object)this.parseCompileEvaluate("-(123)")).isEqualTo((Object)BigDecimal.valueOf(-123L));
        Assertions.assertThat((Object)this.parseCompileEvaluate("(false)")).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("(true)")).isEqualTo((Object)Boolean.TRUE);
    }

    @Test
    public void test_ternary_logic() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("true and true")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("true and false")).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("true and null")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("false and true")).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("false and false")).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("false and null")).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("null and true")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("null and false")).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("null and null")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("true or true")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("true or false")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("true or null")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("false or true")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("false or false")).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("false or null")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("null or true")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("null or false")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("null or null")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("false and false or true")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("false and (false or true)")).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("true or false and false")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("(true or false) and false")).isEqualTo((Object)Boolean.FALSE);
    }

    @Test
    public void test_if() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("if true then 15 else 5")).isEqualTo((Object)BigDecimal.valueOf(15L));
        Assertions.assertThat((Object)this.parseCompileEvaluate("if false then 15 else 5")).isEqualTo((Object)BigDecimal.valueOf(5L));
        Assertions.assertThat((Object)this.parseCompileEvaluate("if null then 15 else 5")).isEqualTo((Object)BigDecimal.valueOf(5L));
        Assertions.assertThat((Object)this.parseCompileEvaluate("if \"hello\" then 15 else 5")).isEqualTo((Object)BigDecimal.valueOf(5L));
    }

    @Test
    public void test_additiveExpression() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("1 + 2")).isEqualTo((Object)BigDecimal.valueOf(3L));
        Assertions.assertThat((Object)this.parseCompileEvaluate("1 + null")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("1 - 2")).isEqualTo((Object)BigDecimal.valueOf(-1L));
        Assertions.assertThat((Object)this.parseCompileEvaluate("1 - null")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("\"Hello, \" + \"World\"")).isEqualTo((Object)"Hello, World");
    }

    @Test
    public void test_multiplicativeExpression() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("3 * 5")).isEqualTo((Object)BigDecimal.valueOf(15L));
        Assertions.assertThat((Object)this.parseCompileEvaluate("3 * null")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("10 / 2")).isEqualTo((Object)BigDecimal.valueOf(5L));
        Assertions.assertThat((Object)this.parseCompileEvaluate("10 / null")).isNull();
    }

    @Test
    public void test_exponentiationExpression() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("3 ** 3")).isEqualTo((Object)BigDecimal.valueOf(27L));
        Assertions.assertThat((Object)this.parseCompileEvaluate("3 ** null")).isNull();
    }

    @Test
    public void test_logicalNegationExpression() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("not true")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("not false")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("not null")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("not 3")).isNull();
    }

    @Test
    public void test_listExpression() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("[]")).asList().isEmpty();
        Assertions.assertThat((Object)this.parseCompileEvaluate("[ ]")).asList().isEmpty();
        Assertions.assertThat((Object)this.parseCompileEvaluate("[1]")).asList().containsExactly(new Object[]{BigDecimal.valueOf(1L)});
        Assertions.assertThat((Object)this.parseCompileEvaluate("[1, 2,3]")).asList().containsExactly(new Object[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L)});
    }

    @Test
    public void test_instanceOfExpression() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("123 instance of number")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("\"ciao\" instance of number")).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("123 instance of string")).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("\"ciao\" instance of string")).isEqualTo((Object)Boolean.TRUE);
    }

    @Test
    public void test_between() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("10 between 5 and 12")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("10 between 20 and 30")).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("10 between 5 and \"foo\"")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("\"foo\" between 5 and 12")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("\"foo\" between \"bar\" and \"zap\"")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("\"foo\" between null and \"zap\"")).isNull();
    }

    @Test
    public void test_filterPath() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][1]")).isEqualTo((Object)"a");
        Assertions.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][2]")).isEqualTo((Object)"b");
        Assertions.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][3]")).isEqualTo((Object)"c");
        Assertions.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][-1]")).isEqualTo((Object)"c");
        Assertions.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][-2]")).isEqualTo((Object)"b");
        Assertions.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][-3]")).isEqualTo((Object)"a");
        Assertions.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][4]")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][984]")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][-4]")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][-984]")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("\"a\"[1]")).isEqualTo((Object)"a");
        Assertions.assertThat((Object)this.parseCompileEvaluate("\"a\"[2]")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("\"a\"[-1]")).isEqualTo((Object)"a");
        Assertions.assertThat((Object)this.parseCompileEvaluate("\"a\"[-2]")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("[1, 2, 3, 4][item = 4]")).asList().containsExactly(new Object[]{BigDecimal.valueOf(4L)});
        Assertions.assertThat((Object)this.parseCompileEvaluate("[1, 2, 3, 4][item > 2]")).asList().containsExactly(new Object[]{BigDecimal.valueOf(3L), BigDecimal.valueOf(4L)});
        Assertions.assertThat((Object)this.parseCompileEvaluate("[1, 2, 3, 4][item > 5]")).asList().isEmpty();
        Assertions.assertThat((Object)this.parseCompileEvaluate("[ {x:1, y:2}, {x:2, y:3} ][x = 1]")).asList().containsExactly(new Object[]{DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("x", new BigDecimal(1)), DynamicTypeUtils.entry("y", new BigDecimal(2)))});
        Assertions.assertThat((Object)this.parseCompileEvaluate("[ {x:1, y:2}, {x:2, y:3} ][x > 1]")).asList().containsExactly(new Object[]{DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("x", new BigDecimal(2)), DynamicTypeUtils.entry("y", new BigDecimal(3)))});
        Assertions.assertThat((Object)this.parseCompileEvaluate("[ {x:1, y:2}, {x:2, y:3} ][x = 0]")).asList().isEmpty();
    }

    @Test
    public void test_filterPath_tricky1() {
        CompiledFEELExpression nameRef = this.parse("[ {x:1, y:2}, {x:2, y:3} ][x]");
        LOG.debug("{}", (Object)nameRef);
        EvaluationContext context = CodegenTestUtil.newEmptyEvaluationContext();
        context.setValue("x", (Object)2);
        Object result = nameRef.apply((Object)context);
        LOG.debug("{}", result);
        Assertions.assertThat((Object)result).isEqualTo(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("x", new BigDecimal(2)), DynamicTypeUtils.entry("y", new BigDecimal(3))));
    }

    @Test
    public void test_filterPath_tricky2() {
        CompiledFEELExpression nameRef = this.parse("[ {x:1, y:2}, {x:2, y:3} ][x]");
        LOG.debug("{}", (Object)nameRef);
        EvaluationContext context = CodegenTestUtil.newEmptyEvaluationContext();
        context.setValue("x", (Object)false);
        Object result = nameRef.apply((Object)context);
        LOG.debug("{}", result);
        Assertions.assertThat((Object)result).asList().isEmpty();
    }

    @Test
    public void test_filterPathSelection() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("[ {x:1, y:2}, {x:2, y:3} ].y")).asList().containsExactly(new Object[]{BigDecimal.valueOf(2L), BigDecimal.valueOf(3L)});
        Assertions.assertThat((Object)this.parseCompileEvaluate("[ {x:1, y:2}, {x:2} ].y")).asList().containsExactly(new Object[]{BigDecimal.valueOf(2L), null});
        Assertions.assertThat((Object)this.parseCompileEvaluate("[ {x:1, y:2}, {x:2, y:3} ].z")).asList().containsExactly(new Object[]{null, null});
    }

    @Test
    public void test_for() {
        Object parseCompileEvaluate = this.parseCompileEvaluate("for x in [ 10, 20, 30 ], y in [ 1, 2, 3 ] return x * y");
        Assertions.assertThat((Object)parseCompileEvaluate).asList().containsExactly(new Object[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L), BigDecimal.valueOf(30L), BigDecimal.valueOf(20L), BigDecimal.valueOf(40L), BigDecimal.valueOf(60L), BigDecimal.valueOf(30L), BigDecimal.valueOf(60L), BigDecimal.valueOf(90L)});
        Assertions.assertThat((Object)this.parseCompileEvaluate("for x in [1, 2, 3] return x+1")).asList().containsExactly(new Object[]{BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L)});
    }

    @Test
    public void test_quantifiedExpressions() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("some price in [ 80, 11, 110 ] satisfies price > 100")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("some price in [ 80, 11, 90 ] satisfies price > 100")).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("some x in [ 5, 6, 7 ], y in [ 10, 11, 6 ] satisfies x > y")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("every price in [ 80, 11, 90 ] satisfies price > 10")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("every price in [ 80, 11, 90 ] satisfies price > 70")).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("some x in [ 5, 6, 7 ], y in [ 10, 11, 12 ] satisfies x < y")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("some price in [ 80, 11, 110 ] satisfies price > max(100, 50, 10)")).isEqualTo((Object)Boolean.TRUE);
    }

    @Test
    public void test_basicFunctionInvocation() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("max(1, 2, 3)")).isEqualTo((Object)new BigDecimal(3));
    }

    @Test
    public void test_basicFunctionDefinition() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("function (a, b) a + b")).isInstanceOf(CompiledCustomFEELFunction.class);
        Assertions.assertThat((Object)this.parseCompileEvaluate("{ s : function (a, b) a + b, x : 1, y : 2, r : s(x,y) }.r")).isEqualTo((Object)new BigDecimal(3));
    }

    @Test
    public void test_namedFunctionInvocation() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("substring(start position: 2, string: \"FOOBAR\")")).isEqualTo((Object)"OOBAR");
        Assertions.assertThat((Object)this.parseCompileEvaluate("ceiling( n : 1.5 )")).isEqualTo((Object)new BigDecimal("2"));
    }

    @Test
    public void test_Misc_fromOriginalFEELInterpretedTestSuite() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("if null then \"foo\" else \"bar\"")).isEqualTo((Object)"bar");
        Assertions.assertThat((Object)this.parseCompileEvaluate("{ hello world : function() \"Hello World!\", message : hello world() }.message")).isEqualTo((Object)"Hello World!");
        Assertions.assertThat((Object)this.parseCompileEvaluate("1 + if true then 1 else 2")).isEqualTo((Object)new BigDecimal("2"));
        Assertions.assertThat((Object)this.parseCompileEvaluate("\"string with \\\"quotes\\\"\"")).isEqualTo((Object)"string with \"quotes\"");
        Assertions.assertThat((Object)this.parseCompileEvaluate("date( -0105, 8, 2 )")).isEqualTo((Object)LocalDate.of(-105, 8, 2));
        Assertions.assertThat((Object)this.parseCompileEvaluate("string(null)")).isNull();
        Assertions.assertThat((Object)this.parseCompileEvaluate("[ null ]")).asList().containsExactly(new Object[]{null});
        Assertions.assertThat((Object)this.parseCompileEvaluate("[ null, null ]")).asList().containsExactly(new Object[]{null, null});
        Assertions.assertThat((Object)this.parseCompileEvaluate("[ null, 47, null ]")).asList().containsExactly(new Object[]{null, BigDecimal.valueOf(47L), null});
    }

    @Test
    public void test_Benchmark_feelExpressions() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("{ full name: { first name: \"John\", last name: \"Doe\" } }.full name.last name")).isEqualTo((Object)"Doe");
        Assertions.assertThat((Object)this.parseCompileEvaluate("some price in [ 80, 11, 110 ] satisfies price > 100")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)this.parseCompileEvaluate("every price in [ 80, 11, 90 ] satisfies price > 10")).isEqualTo((Object)Boolean.TRUE);
    }

    @Test
    public void test_contextExpression() {
        Assertions.assertThat((Object)this.parseCompileEvaluate("{}")).isEqualTo(Collections.emptyMap());
        Assertions.assertThat((Object)this.parseCompileEvaluate("{ }")).isEqualTo(Collections.emptyMap());
        Assertions.assertThat((Object)this.parseCompileEvaluate("{ a : 1 }")).isEqualTo(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("a", new BigDecimal(1))));
        Assertions.assertThat((Object)this.parseCompileEvaluate("{ \"a\" : 1 }")).isEqualTo(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("a", new BigDecimal(1))));
        Assertions.assertThat((Object)this.parseCompileEvaluate("{ \" a\" : 1 }")).isEqualTo(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry(" a", new BigDecimal(1))));
        Assertions.assertThat((Object)this.parseCompileEvaluate("{ a : 1, b : 2, c : 3 }")).isEqualTo(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("a", new BigDecimal(1)), DynamicTypeUtils.entry("b", new BigDecimal(2)), DynamicTypeUtils.entry("c", new BigDecimal(3))));
        Assertions.assertThat((Object)this.parseCompileEvaluate("{ a : 1, a name : \"John Doe\" }")).isEqualTo(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("a", new BigDecimal(1)), DynamicTypeUtils.entry("a name", "John Doe")));
        Assertions.assertThat((Object)this.parseCompileEvaluate("{ a : 1, b : a }")).isEqualTo(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("a", new BigDecimal(1)), DynamicTypeUtils.entry("b", new BigDecimal(1))));
    }

    @Test
    public void testContextWithMultipleEntries() {
        String inputExpression = "{ \"a string key\" : 10,\n a non-string key : 11,\n a key.with + /' odd chars : 12 }";
        Assertions.assertThat((Object)this.parseCompileEvaluate(inputExpression)).isEqualTo(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("a string key", new BigDecimal(10)), DynamicTypeUtils.entry("a non-string key", new BigDecimal(11)), DynamicTypeUtils.entry("a key.with + /' odd chars", new BigDecimal(12))));
    }

    @Test
    public void testNestedContexts() {
        String inputExpression = "{ a value : 10,\n an applicant : { \n    first name : \"Edson\", \n    last + name : \"Tirelli\", \n    full name : first name + last + name, \n    address : {\n        street : \"55 broadway st\",\n        city : \"New York\" \n    }, \n    xxx: last + name\n } \n}";
        Assertions.assertThat((Object)this.parseCompileEvaluate(inputExpression)).isEqualTo(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("a value", new BigDecimal(10)), DynamicTypeUtils.entry("an applicant", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("first name", "Edson"), DynamicTypeUtils.entry("last + name", "Tirelli"), DynamicTypeUtils.entry("full name", "EdsonTirelli"), DynamicTypeUtils.entry("address", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("street", "55 broadway st"), DynamicTypeUtils.entry("city", "New York"))), DynamicTypeUtils.entry("xxx", "Tirelli")))));
    }

    @Test
    public void testNestedContexts2() {
        String complexContext = "{ an applicant : {                                \n    home address : {                              \n        street name: \"broadway st\",             \n        city : \"New York\"                       \n    }                                             \n   },                                             \n   street : an applicant.home address.street name \n}                                                 ";
        Assertions.assertThat((Object)this.parseCompileEvaluate(complexContext)).isEqualTo(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("an applicant", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("home address", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("street name", "broadway st"), DynamicTypeUtils.entry("city", "New York"))))), DynamicTypeUtils.entry("street", "broadway st")));
    }

    @Test
    public void testNameReference() {
        String inputExpression = "someSimpleName";
        CompiledFEELExpression nameRef = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("someSimpleName", BuiltInType.STRING)));
        LOG.debug("{}", (Object)nameRef);
        EvaluationContext context = CodegenTestUtil.newEmptyEvaluationContext();
        context.setValue("someSimpleName", (Object)123L);
        Object result = nameRef.apply((Object)context);
        LOG.debug("{}", result);
        Assertions.assertThat((Object)result).isEqualTo((Object)BigDecimal.valueOf(123L));
    }

    @Test
    public void testQualifiedName() {
        String inputExpression = "My Person.Full Name";
        MapBackedType personType = new MapBackedType("Person", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("Full Name", BuiltInType.STRING), DynamicTypeUtils.entry("Age", BuiltInType.NUMBER)));
        CompiledFEELExpression qualRef = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("My Person", personType)));
        LOG.debug("{}", (Object)qualRef);
        EvaluationContext context = CodegenTestUtil.newEmptyEvaluationContext();
        context.setValue("My Person", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("Full Name", "John Doe"), DynamicTypeUtils.entry("Age", 47)));
        Object result = qualRef.apply((Object)context);
        LOG.debug("{}", result);
        Assertions.assertThat((Object)result).isEqualTo((Object)"John Doe");
        CompiledFEELExpression personAgeExpression = this.parse("My Person.Age", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("My Person", personType)));
        LOG.debug("{}", (Object)personAgeExpression);
        Object resultPersonAge = personAgeExpression.apply((Object)context);
        LOG.debug("{}", resultPersonAge);
        Assertions.assertThat((Object)resultPersonAge).isEqualTo((Object)BigDecimal.valueOf(47L));
    }

    @Test
    public void testQualifiedName2() {
        String inputExpression = "My Person.Full Name";
        Type personType = JavaBackedType.of(MyPerson.class);
        CompiledFEELExpression qualRef = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("My Person", personType)));
        LOG.debug("{}", (Object)qualRef);
        EvaluationContext context = CodegenTestUtil.newEmptyEvaluationContext();
        context.setValue("My Person", (Object)new MyPerson());
        Object result = qualRef.apply((Object)context);
        LOG.debug("{}", result);
        Assertions.assertThat((Object)result).isEqualTo((Object)"John Doe");
    }

    @Test
    public void testQualifiedName3() {
        String inputExpression = "a date.year";
        BuiltInType dateType = BuiltInType.DATE;
        CompiledFEELExpression qualRef = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("a date", dateType)));
        LOG.debug("{}", (Object)qualRef);
        EvaluationContext context = CodegenTestUtil.newEmptyEvaluationContext();
        context.setValue("a date", (Object)LocalDate.of(2016, 8, 2));
        Object result = qualRef.apply((Object)context);
        LOG.debug("{}", result);
        Assertions.assertThat((Object)result).isEqualTo((Object)BigDecimal.valueOf(2016L));
    }

    private CompiledFEELExpression parse(String input) {
        return this.parse(input, Collections.emptyMap());
    }

    private CompiledFEELExpression parse(String input, Map<String, Type> inputTypes) {
        FEEL_1_1Parser parser = FEELParser.parse(null, (String)input, inputTypes, Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), null);
        FEEL_1_1Parser.Compilation_unitContext tree = parser.compilation_unit();
        ASTBuilderVisitor v = new ASTBuilderVisitor(inputTypes, null);
        BaseNode node = (BaseNode)v.visit((ParseTree)tree);
        DirectCompilerResult directResult = (DirectCompilerResult)node.accept((Visitor)new ASTCompilerVisitor());
        Expression expr = directResult.getExpression();
        CompiledFEELExpression cu = new CompilerBytecodeLoader().makeFromJPExpression(input, expr, directResult.getFieldDeclarations());
        return cu;
    }

    public static class MyPerson {
        @FEELProperty(value="Full Name")
        public String getFullName() {
            return "John Doe";
        }
    }
}

