/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.StartsWithFunction;

public class StartsWithFunctionTest {
    private StartsWithFunction startsWithFunction;

    @Before
    public void setUp() {
        this.startsWithFunction = new StartsWithFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultError(this.startsWithFunction.invoke((String)null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.startsWithFunction.invoke(null, "test"), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.startsWithFunction.invoke("test", null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeEmptyString() {
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("", ""), true, new String[0]);
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("", "test"), false, new String[0]);
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("test", ""), true, new String[0]);
    }

    @Test
    public void invokeStartsWith() {
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("test", "te"), true, new String[0]);
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("test", "t"), true, new String[0]);
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("test", "test"), true, new String[0]);
    }

    @Test
    public void invokeNotStartsWith() {
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("test", "tte"), false, new String[0]);
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("test", "tt"), false, new String[0]);
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("test", "ttest"), false, new String[0]);
    }
}

