/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.impl;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.FEELProfile;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.util.DynamicTypeUtils;

public class FEELProfileTest {
    @Test
    public void testFeelProfileFunctionsAndValues() {
        FEEL feel = FEEL.newInstance(List.of(new TestFEELProfile()));
        Assertions.assertThat((Object)feel.evaluate("use cache(\"val 1\")")).isEqualTo((Object)"1");
        Assertions.assertThat((Object)feel.evaluate("use cache(\"val 3\")")).isEqualTo((Object)"3");
        Assertions.assertThat((Object)feel.evaluate("use cache(\"val 5\")")).isNull();
    }

    public static class TestFEELProfile
    implements FEELProfile {
        public List<FEELFunction> getFEELFunctions() {
            return List.of(new UseCacheFunction());
        }

        public Map<String, Object> getValues() {
            return DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("[internal-cache]", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("val 1", "1"), DynamicTypeUtils.entry("val 2", "2"), DynamicTypeUtils.entry("val 3", "3"))));
        }
    }

    public static class UseCacheFunction
    extends BaseFEELFunction {
        public UseCacheFunction() {
            super("use cache");
        }

        public FEELFnResult<String> invoke(EvaluationContext ctx, String key) {
            Map cache = (Map)ctx.getValue("[internal-cache]");
            if (cache != null) {
                return FEELFnResult.ofResult((Object)((String)cache.get(key)));
            }
            return FEELFnResult.ofResult(null);
        }
    }
}

