/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.functions.DateAndTimeFunction;
import org.kie.dmn.feel.runtime.functions.DateFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.StringFunction;
import org.kie.dmn.feel.runtime.functions.TimeFunction;

public class ComposingDifferentFunctionsTest {
    private DateAndTimeFunction dateTimeFunction;
    private DateFunction dateFunction;
    private TimeFunction timeFunction;
    private StringFunction stringFunction;

    @Before
    public void setUp() {
        this.dateTimeFunction = new DateAndTimeFunction();
        this.dateFunction = new DateFunction();
        this.timeFunction = new TimeFunction();
        this.stringFunction = new StringFunction();
    }

    @Test
    public void testComposite1() {
        FEELFnResult p1 = this.dateTimeFunction.invoke("2017-08-10T10:20:00+02:00");
        FEELFnResult p2 = this.timeFunction.invoke("23:59:01");
        FunctionTestUtil.assertResult(p1, ZonedDateTime.of(2017, 8, 10, 10, 20, 0, 0, ZoneId.of("+02:00")), new String[0]);
        FunctionTestUtil.assertResult(p2, LocalTime.of(23, 59, 1), new String[0]);
        FEELFnResult result = this.dateTimeFunction.invoke((TemporalAccessor)p1.getOrElse(null), (TemporalAccessor)p2.getOrElse(null));
        FunctionTestUtil.assertResult(result, LocalDateTime.of(2017, 8, 10, 23, 59, 1), new String[0]);
    }

    @Test
    public void testComposite2() {
        FEELFnResult p1 = this.dateTimeFunction.invoke("-999999999-12-31T23:59:59.999999999+02:00");
        FunctionTestUtil.assertResult(p1, ZonedDateTime.of(-999999999, 12, 31, 23, 59, 59, 999999999, ZoneOffset.of("+02:00")), new String[0]);
        FunctionTestUtil.assertResult(this.stringFunction.invoke(p1.getOrElse(null)), "-999999999-12-31T23:59:59.999999999+02:00", new String[0]);
    }

    @Test
    public void testComposite3() {
        FEELFnResult p1 = this.dateTimeFunction.invoke("-999999999-12-31T23:59:59.999999999@Europe/Paris");
        FunctionTestUtil.assertResult(p1, ZonedDateTime.of(-999999999, 12, 31, 23, 59, 59, 999999999, ZoneId.of("Europe/Paris")), new String[0]);
        FunctionTestUtil.assertResult(this.stringFunction.invoke(p1.getOrElse(null)), "-999999999-12-31T23:59:59.999999999@Europe/Paris", new String[0]);
    }

    @Test
    public void testComposite4() {
        FEELFnResult p1 = this.dateFunction.invoke("2017-01-01");
        FEELFnResult p2 = this.timeFunction.invoke("23:59:01@Europe/Paris");
        FunctionTestUtil.assertResult(p1, LocalDate.of(2017, 1, 1), new String[0]);
        TemporalAccessor p2TA = (TemporalAccessor)p2.getOrElse(null);
        Assertions.assertThat((Object)p2TA).isNotNull();
        Assertions.assertThat((LocalTime)p2TA.query(TemporalQueries.localTime())).isEqualTo((Object)LocalTime.of(23, 59, 1));
        Assertions.assertThat((Object)p2TA.query(TemporalQueries.zone())).isEqualTo((Object)ZoneId.of("Europe/Paris"));
        FEELFnResult result = this.dateTimeFunction.invoke((TemporalAccessor)p1.getOrElse(null), (TemporalAccessor)p2.getOrElse(null));
        FunctionTestUtil.assertResult(result, ZonedDateTime.of(2017, 1, 1, 23, 59, 1, 0, ZoneId.of("Europe/Paris")), new String[0]);
    }

    @Test
    public void testComposite5() {
        FEELFnResult p1 = this.dateTimeFunction.invoke("2017-08-10T10:20:00@Europe/Paris");
        FunctionTestUtil.assertResult(p1, ZonedDateTime.of(2017, 8, 10, 10, 20, 0, 0, ZoneId.of("Europe/Paris")), new String[0]);
        TemporalAccessor timeOnDateTime = (TemporalAccessor)this.timeFunction.invoke((TemporalAccessor)p1.getOrElse(null)).getOrElse(null);
        Assertions.assertThat((Object)timeOnDateTime).isNotNull();
        Assertions.assertThat((LocalTime)timeOnDateTime.query(TemporalQueries.localTime())).isEqualTo((Object)LocalTime.of(10, 20, 0));
        Assertions.assertThat((Object)timeOnDateTime.query(TemporalQueries.zone())).isEqualTo((Object)ZoneId.of("Europe/Paris"));
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)timeOnDateTime), "10:20:00@Europe/Paris", new String[0]);
    }
}

