/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.DistinctValuesFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class DistinctValuesFunctionTest {
    private DistinctValuesFunction distinctValuesFunction;

    @Before
    public void setUp() {
        this.distinctValuesFunction = new DistinctValuesFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultError(this.distinctValuesFunction.invoke(null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamNotCollection() {
        FunctionTestUtil.assertResultList(this.distinctValuesFunction.invoke((Object)BigDecimal.valueOf(10.1)), Collections.singletonList(BigDecimal.valueOf(10.1)));
    }

    @Test
    public void invokeParamArray() {
        FunctionTestUtil.assertResultList(this.distinctValuesFunction.invoke((Object)new Object[]{BigDecimal.valueOf(10.1)}), Collections.singletonList(new Object[]{BigDecimal.valueOf(10.1)}));
    }

    @Test
    public void invokeEmptyList() {
        FunctionTestUtil.assertResultList(this.distinctValuesFunction.invoke(Collections.emptyList()), Collections.emptyList());
    }

    @Test
    public void invokeList() {
        List<Serializable> testValues = Arrays.asList(1, BigDecimal.valueOf(10.1), "test", 1, "test", BigDecimal.valueOf(10.1));
        FunctionTestUtil.assertResultList(this.distinctValuesFunction.invoke(testValues), Arrays.asList(1, BigDecimal.valueOf(10.1), "test"));
    }
}

