/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.MatchesFunction;

public class MatchesFunctionTest {
    private MatchesFunction matchesFunction;

    @Before
    public void setUp() {
        this.matchesFunction = new MatchesFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultError(this.matchesFunction.invoke((String)null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.matchesFunction.invoke(null, "test"), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.matchesFunction.invoke("test", null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeUnsupportedFlags() {
        FunctionTestUtil.assertResult(this.matchesFunction.invoke("foobar", "fo.bar", "g"), true, new String[0]);
    }

    @Test
    public void invokeWithoutFlagsMatch() {
        FunctionTestUtil.assertResult(this.matchesFunction.invoke("test", "test"), true, new String[0]);
        FunctionTestUtil.assertResult(this.matchesFunction.invoke("foobar", "^fo*b"), true, new String[0]);
    }

    @Test
    public void invokeWithoutFlagsNotMatch() {
        FunctionTestUtil.assertResult(this.matchesFunction.invoke("test", "testt"), false, new String[0]);
        FunctionTestUtil.assertResult(this.matchesFunction.invoke("foobar", "^fo*bb"), false, new String[0]);
        FunctionTestUtil.assertResult(this.matchesFunction.invoke("fo\nbar", "fo.bar"), false, new String[0]);
    }

    @Test
    public void invokeWithFlagDotAll() {
        FunctionTestUtil.assertResult(this.matchesFunction.invoke("fo\nbar", "fo.bar", "s"), true, new String[0]);
    }

    @Test
    public void invokeWithFlagMultiline() {
        FunctionTestUtil.assertResult(this.matchesFunction.invoke("fo\nbar", "^bar", "m"), true, new String[0]);
    }

    @Test
    public void invokeWithFlagCaseInsensitive() {
        FunctionTestUtil.assertResult(this.matchesFunction.invoke("foobar", "^Fo*bar", "i"), true, new String[0]);
    }

    @Test
    public void invokeWithAllFlags() {
        FunctionTestUtil.assertResult(this.matchesFunction.invoke("fo\nbar", "Fo.^bar", "smi"), true, new String[0]);
    }
}

