/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.ConcatenateFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class ConcatenateFunctionTest {
    private ConcatenateFunction concatenateFunction;

    @Before
    public void setUp() {
        this.concatenateFunction = new ConcatenateFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultError(this.concatenateFunction.invoke(null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeEmptyArray() {
        FunctionTestUtil.assertResultList(this.concatenateFunction.invoke(new Object[0]), Collections.emptyList());
    }

    @Test
    public void invokeArrayWithNull() {
        FunctionTestUtil.assertResultError(this.concatenateFunction.invoke(new Object[]{null}), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.concatenateFunction.invoke(new Object[]{1, null}), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeArrayWithList() {
        FunctionTestUtil.assertResultList(this.concatenateFunction.invoke(new Object[]{"test", 2, Arrays.asList(2, 3)}), Arrays.asList("test", 2, 2, 3));
    }

    @Test
    public void invokeArrayWithoutList() {
        FunctionTestUtil.assertResultList(this.concatenateFunction.invoke(new Object[]{"test", 2, BigDecimal.valueOf(25.3)}), Arrays.asList("test", 2, BigDecimal.valueOf(25.3)));
    }
}

