/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.DecimalFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class DecimalFunctionTest {
    private DecimalFunction decimalFunction;

    @Before
    public void setUp() {
        this.decimalFunction = new DecimalFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultError(this.decimalFunction.invoke((BigDecimal)null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.decimalFunction.invoke(BigDecimal.ONE, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.decimalFunction.invoke(null, BigDecimal.ONE), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeRoundingUp() {
        FunctionTestUtil.assertResult(this.decimalFunction.invoke(BigDecimal.valueOf(10.27), BigDecimal.ONE), BigDecimal.valueOf(10.3), new String[0]);
    }

    @Test
    public void invokeRoundingDown() {
        FunctionTestUtil.assertResult(this.decimalFunction.invoke(BigDecimal.valueOf(10.24), BigDecimal.ONE), BigDecimal.valueOf(10.2), new String[0]);
    }

    @Test
    public void invokeRoundingEven() {
        FunctionTestUtil.assertResult(this.decimalFunction.invoke(BigDecimal.valueOf(10.25), BigDecimal.ONE), BigDecimal.valueOf(10.2), new String[0]);
    }

    @Test
    public void invokeRoundingOdd() {
        FunctionTestUtil.assertResult(this.decimalFunction.invoke(BigDecimal.valueOf(10.35), BigDecimal.ONE), BigDecimal.valueOf(10.4), new String[0]);
    }

    @Test
    public void invokeLargerScale() {
        FunctionTestUtil.assertResult(this.decimalFunction.invoke(BigDecimal.valueOf(10.123456789), BigDecimal.valueOf(6L)), BigDecimal.valueOf(10.123457), new String[0]);
    }
}

