/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.util.List;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;

public final class FunctionTestUtil {
    public static <T> void assertResult(FEELFnResult<T> result, T expectedResult, String ... failMessage) {
        if (expectedResult == null) {
            FunctionTestUtil.assertResultNull(result, failMessage);
        } else {
            FunctionTestUtil.assertResultNotError(result, failMessage);
            Object resultValue = result.cata(left -> null, right -> right);
            Assertions.assertThat((Object)resultValue).isNotNull();
            Assertions.assertThat((Object)resultValue).isEqualTo(expectedResult);
        }
    }

    public static void assertResultBigDecimal(FEELFnResult<BigDecimal> result, BigDecimal expectedResult) {
        FunctionTestUtil.assertResultNotError(result, new String[0]);
        BigDecimal resultValue = (BigDecimal)result.cata(left -> null, right -> right);
        Assertions.assertThat((BigDecimal)resultValue).isNotNull();
        Assertions.assertThat((BigDecimal)resultValue).isEqualTo((Object)expectedResult);
    }

    public static <T> void assertResultList(FEELFnResult<List<T>> result, List<Object> expectedResult) {
        FunctionTestUtil.assertResultNotError(result, new String[0]);
        List resultList = (List)result.cata(left -> null, right -> right);
        Assertions.assertThat((List)resultList).hasSameSizeAs(expectedResult);
        if (expectedResult.isEmpty()) {
            Assertions.assertThat((List)resultList).isEmpty();
        } else {
            Assertions.assertThat((List)resultList).containsAll(expectedResult);
        }
    }

    public static <T> void assertPredicateOnResult(FEELFnResult<?> result, Class<T> clazz, Predicate<T> assertion) {
        FunctionTestUtil.assertResultNotError(result, new String[0]);
        Object resultValue = result.cata(left -> null, clazz::cast);
        Assertions.assertThat((Object)resultValue).isNotNull();
        Assertions.assertThat((boolean)assertion.test(resultValue)).isTrue();
    }

    public static <T> void assertResultNull(FEELFnResult<T> result, String ... failMessage) {
        FunctionTestUtil.assertResultNotError(result, failMessage);
        Object invokedResult = result.cata(left -> null, right -> right);
        Assertions.assertThat((Object)invokedResult).isNull();
    }

    public static <T> void assertResultNotError(FEELFnResult<T> result, String ... failMessage) {
        ObjectAssert feelFnResultObjectAssert = Assertions.assertThat(result);
        AbstractBooleanAssert abstractBooleanAssert = Assertions.assertThat((boolean)result.isRight());
        if (failMessage.length == 1) {
            String message = FunctionTestUtil.checkingMessage(failMessage[0]);
            feelFnResultObjectAssert = (ObjectAssert)feelFnResultObjectAssert.withFailMessage(message, new Object[0]);
            abstractBooleanAssert = (AbstractBooleanAssert)abstractBooleanAssert.withFailMessage(message, new Object[0]);
        }
        feelFnResultObjectAssert.isNotNull();
        abstractBooleanAssert.isTrue();
    }

    public static <T> void assertResultError(FEELFnResult<T> result, Class expectedErrorEventClass, String ... failMessage) {
        ObjectAssert feelFnResultObjectAssert = Assertions.assertThat(result);
        AbstractBooleanAssert abstractBooleanAssert = Assertions.assertThat((boolean)result.isLeft());
        if (failMessage.length == 1) {
            String message = FunctionTestUtil.checkingMessage(failMessage[0]);
            feelFnResultObjectAssert = (ObjectAssert)feelFnResultObjectAssert.withFailMessage(message, new Object[0]);
            abstractBooleanAssert = (AbstractBooleanAssert)abstractBooleanAssert.withFailMessage(message, new Object[0]);
        }
        feelFnResultObjectAssert.isNotNull();
        abstractBooleanAssert.isTrue();
        FEELEvent resultEvent = (FEELEvent)result.cata(left -> left, right -> null);
        FunctionTestUtil.checkErrorEvent(resultEvent, expectedErrorEventClass, new String[0]);
    }

    public static void checkErrorEvent(FEELEvent errorEvent, Class errorEventClass, String ... failMessage) {
        ObjectAssert feelEventObjectAssert = Assertions.assertThat((Object)errorEvent);
        AbstractComparableAssert severityAbstractComparableAssert = Assertions.assertThat((Comparable)errorEvent.getSeverity());
        if (failMessage.length == 1) {
            String message = FunctionTestUtil.checkingMessage(failMessage[0]);
            feelEventObjectAssert = (ObjectAssert)feelEventObjectAssert.withFailMessage(message, new Object[0]);
            severityAbstractComparableAssert = (AbstractComparableAssert)severityAbstractComparableAssert.withFailMessage(message, new Object[0]);
        }
        feelEventObjectAssert.isNotNull();
        feelEventObjectAssert.isInstanceOf(errorEventClass);
        severityAbstractComparableAssert.isEqualTo((Object)FEELEvent.Severity.ERROR);
    }

    private static String checkingMessage(String failMessage) {
        return String.format("Checking `%s`", failMessage);
    }

    private FunctionTestUtil() {
    }
}

